/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup.valid;

import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.provider.VdbProvider;

public abstract class DescriptorPropertyBase
extends MarkupBase
implements Comparable<DescriptorPropertyBase> {
    private Property m_property;

    public void setProperty(String property) throws BadMarkupException {
        try {
            this.m_property = new Property(VdbProvider.getPropertyProvider().getPropertyId(property));
        }
        catch (VDBGeneralException e) {
            throw new BadMarkupException(e);
        }
    }

    public String getProperty() throws BadMarkupException {
        return this.m_property.getProperty();
    }

    public int getPropertyId() {
        return this.m_property.getPropertyId();
    }

    public boolean equals(Object obj) {
        DescriptorPropertyBase s = (DescriptorPropertyBase)obj;
        return this.compareTo(s) == 0;
    }

    @Override
    public int compareTo(DescriptorPropertyBase o) {
        try {
            return this.getProperty().compareToIgnoreCase(o.getProperty());
        }
        catch (BadMarkupException e) {
            return 0;
        }
    }

    @Override
    public boolean isValid() throws BadMarkupException {
        this.getProperty();
        return true;
    }

    @Override
    public void reset() {
        this.m_property = null;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof DescriptorPropertyBase) {
            DescriptorPropertyBase p = (DescriptorPropertyBase)artifact;
            this.setProperty(p.getProperty());
        }
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        try {
            ret.append(this.getProperty());
        }
        catch (BadMarkupException badMarkupException) {
            // empty catch block
        }
        return ret.toString();
    }
}

