/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.load;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.Messages;
import com.ibm.appscan.vdb.annotation.VdbAnnotation;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.method.markup.ao.Option;
import com.ibm.appscan.vdb.method.markup.ao.Sink;
import com.ibm.appscan.vdb.method.markup.ao.Source;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.EnumProvider;
import com.ibm.appscan.vdb.provider.data.file.load.BaseXmlStreamReader;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class VdbHandler
extends BaseXmlStreamReader {
    private String m_package = null;
    private String m_class = null;
    private Method m_method;
    private ActionObject m_ao;
    private boolean m_in_action_object;
    private Vdb m_vdb;
    private boolean m_is_public;
    private boolean m_is_static;
    private XMLEventReader m_xmlReader;
    private Language.LANGUAGE m_lang;
    private String m_method_id = null;
    private String m_ao_id = null;
    private ArrayList<Option> m_extra_options = new ArrayList();
    private List<VdbAnnotation> m_annotations;
    private HashMap<String, List<VdbAnnotation>> m_arg_annotations;
    private String m_current_arg_type;
    private VdbAnnotation m_annotation;

    public VdbHandler(InputStream stream) throws VDBGeneralException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.m_xmlReader = factory.createFilteredReader(factory.createXMLEventReader(stream), this);
        }
        catch (XMLStreamException e) {
            throw new VDBGeneralException(e);
        }
    }

    public boolean parse() throws VDBGeneralException {
        try {
            this.read(this.m_xmlReader);
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            if (e.getLocalizedMessage().contains("START_ELEMENT")) {
                boolean bl = true;
                return bl;
            }
            throw new VDBGeneralException(e);
        }
        finally {
            if (this.m_xmlReader != null) {
                try {
                    this.m_xmlReader.close();
                }
                catch (XMLStreamException e) {
                    throw new VDBGeneralException(e);
                }
            }
        }
    }

    @Override
    protected boolean process(StartElement element) {
        block71: {
            if (element.getName().getLocalPart().equals("Header")) {
                this.m_lang = Language.getLanguage((String)this.getAttribute(element, "language"));
            } else if (element.getName().getLocalPart().equals("package") || element.getName().getLocalPart().equals("namespace")) {
                this.m_package = this.getAttribute(element, "name");
            } else if (element.getName().getLocalPart().equals("class") || element.getName().getLocalPart().equals("interface")) {
                this.m_class = this.getAttribute(element, "name");
            } else if (element.getName().getLocalPart().equals("method") || element.getName().getLocalPart().equals("nonclassfunction")) {
                this.m_is_static = false;
                this.m_method_id = this.getAttribute(element, "vuln_id");
                String accessibility = this.getAttribute(element, "accessibility");
                this.m_is_public = accessibility != null ? !accessibility.equals("Private") : true;
                String methodKind = this.getAttribute(element, "methodKind");
                if (methodKind != null && methodKind.equals("Static")) {
                    this.m_is_static = true;
                }
            } else if (element.getName().getLocalPart().equals("info_rule")) {
                this.m_method.setInfoId(this.getAttribute(element, "id"));
            } else if (element.getName().getLocalPart().equals("sink_rule")) {
                try {
                    this.m_ao = new Sink();
                    this.m_in_action_object = true;
                    this.m_ao.setId(this.getAttribute(element, "id"));
                }
                catch (BadMarkupException e) {
                    this.m_in_action_object = false;
                    CommonCore.getLogManager().log(new Message(4, "Error initializing sink " + this.getAttribute(element, "param") + " reason:" + e.toString()));
                }
            } else if (element.getName().getLocalPart().equals("source_rule")) {
                try {
                    this.m_ao = new Source();
                    this.m_in_action_object = true;
                    this.m_ao.setId(this.getAttribute(element, "id"));
                }
                catch (BadMarkupException e) {
                    this.m_in_action_object = false;
                    CommonCore.getLogManager().log(new Message(4, "Error initializing source " + this.getAttribute(element, "param") + " reason:" + e.toString()));
                }
            } else if (element.getName().getLocalPart().equals("rule")) {
                this.m_ao = new ActionObject();
                this.m_extra_options = new ArrayList();
                this.m_in_action_object = true;
            } else if (element.getName().getLocalPart().equals("taint_susceptible_input")) {
                if (this.m_in_action_object) {
                    try {
                        this.m_ao.setParam(this.getAttribute(element, "param"));
                        if (this.getAttribute(element, "return") != null) {
                            this.m_ao.setReturn(Boolean.parseBoolean(this.getAttribute(element, "return")));
                        }
                    }
                    catch (BadMarkupException e) {
                        this.m_in_action_object = false;
                        CommonCore.getLogManager().log(new Message(4, "Error setting action object sink parameter " + this.getAttribute(element, "param") + " for " + this.m_method.getSignature() + " reason:" + e.toString()));
                    }
                }
            } else if (element.getName().getLocalPart().equals("tainted_output")) {
                if (this.m_in_action_object) {
                    try {
                        this.m_ao.setParam(this.getAttribute(element, "param"));
                        this.m_ao.setReturn(Boolean.parseBoolean(this.getAttribute(element, "return")));
                        this.m_ao.setSeverity(VDBEnums.SEVERITY.Low);
                    }
                    catch (BadMarkupException e) {
                        this.m_in_action_object = false;
                        CommonCore.getLogManager().log(new Message(4, "Error setting action object source parameter " + this.getAttribute(element, "taint_susceptible_input") + " for:" + this.m_method.getSignature() + " reason:" + e.toString()));
                    }
                }
            } else if (element.getName().getLocalPart().equals("propagates_taint")) {
                try {
                    String dst_param = this.getAttribute(element, "dst_param");
                    if (dst_param == null && this.getAttribute(element, "param") != null) {
                        dst_param = this.getAttribute(element, "param");
                        CommonCore.getLogManager().log(new Message(1, Messages.getMessage("propagates.taint.param", new Object[0])));
                    }
                    this.m_method.addTaint(this.getAttribute(element, "source_param"), dst_param, Boolean.parseBoolean(this.getAttribute(element, "return")));
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error adding taint for " + this.m_method.getSignature() + " reason:" + e.toString()));
                }
            } else if (element.getName().getLocalPart().equals("does_not_propagate_taint")) {
                try {
                    this.m_method.setNotSusceptibleToTaint();
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error adding not-susceptible to taint " + e.toString()));
                }
            } else if (element.getName().getLocalPart().equals("option")) {
                try {
                    if (!this.m_in_action_object) break block71;
                    Option o = new Option();
                    o.setOptionName(EnumProvider.getOptionName(this.getAttribute(element, "option_name")));
                    o.setOptionOperator(EnumProvider.getOptionOperator(this.getAttribute(element, "operator")));
                    o.setOptionValue(this.getAttribute(element, "value"));
                    o.setParameter(this.getAttribute(element, "parameter_position"));
                    o.setMaxCon(EnumProvider.getOptionCon(this.getAttribute(element, "max_confidence")));
                    o.setMinCon(EnumProvider.getOptionCon(this.getAttribute(element, "min_confidence")));
                    if (!this.m_ao.addOption(o)) {
                        this.m_extra_options.add(o);
                    }
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error adding option " + e.toString()));
                }
            } else if (element.getName().getLocalPart().equals("call_back")) {
                this.m_method.setCallBack(true);
            } else if (element.getName().getLocalPart().equals("ActionObject")) {
                this.m_ao_id = this.getAttribute(element, "id");
            } else if (element.getName().getLocalPart().equals("ActionObject")) {
                this.m_ao_id = this.getAttribute(element, "id");
            } else if (element.getName().getLocalPart().equals("writes_through")) {
                try {
                    this.m_method.setWritesThrough(this.getAttribute(element, "param"));
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error adding writes through parameter:" + this.getAttribute(element, "param")));
                }
            } else if (element.getName().getLocalPart().equals("stores_writeable_aliases")) {
                try {
                    this.m_method.setAlias(this.getAttribute(element, "param"), Boolean.parseBoolean(this.getAttribute(element, "return")));
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error adding stores writeable alias through parameter:" + this.getAttribute(element, "param") + " and return:" + this.getAttribute(element, "return")));
                }
            } else if (element.getName().getLocalPart().equals("method_annotations")) {
                this.m_annotations = new ArrayList<VdbAnnotation>();
            } else if (element.getName().getLocalPart().equals("class_annotations")) {
                this.m_annotations = new ArrayList<VdbAnnotation>();
            } else if (element.getName().getLocalPart().equals("arg_annotations")) {
                this.m_arg_annotations = new HashMap();
            } else if (element.getName().getLocalPart().equals("arg")) {
                this.m_current_arg_type = this.getAttribute(element, "type");
                this.m_annotations = new ArrayList<VdbAnnotation>();
            } else if (element.getName().getLocalPart().equals("annotation")) {
                this.m_annotation = new VdbAnnotation(this.getAttribute(element, "name"));
            } else if (element.getName().getLocalPart().equals("AnnotationMember")) {
                this.m_annotation.addAnnotationMember(this.getAttribute(element, "key"), this.getAttribute(element, "value"));
            }
        }
        return super.process(element);
    }

    @Override
    protected boolean process(StartElement element, BaseXmlStreamReader.ElementValue value) throws XMLStreamException {
        block44: {
            if (element.getName().getLocalPart().equals("signature") && element.getEventType() == 1) {
                String val = value.getText();
                if (this.m_in_action_object) {
                    try {
                        this.m_ao.setId(this.getAttribute(element, "id"));
                        if (val.contains("OptionBasedTester")) {
                            val = "OptionBasedTester";
                        }
                        this.m_ao.setAoType(EnumProvider.getAoType(val));
                    }
                    catch (BadMarkupException e) {
                        this.m_in_action_object = false;
                        CommonCore.getLogManager().log(new Message(4, "Error setting action object type " + val + " reason:" + e.toString()));
                    }
                } else {
                    try {
                        this.m_method = MethodProvider.getMethod(val, this.m_lang);
                        if (this.m_method.getClassName() == null && this.m_class != null && this.m_class.length() > 0) {
                            this.m_method.setClassName(this.m_class);
                        }
                        if (this.m_method.getPackageName() == null && this.m_package != null && this.m_package.length() > 0) {
                            this.m_method.setPackageName(this.m_package);
                        }
                        this.m_method.setId(this.m_method_id);
                        if (!this.m_is_static) break block44;
                        try {
                            this.m_method.addProperty("Attribute.Modifier.Static");
                        }
                        catch (BadMarkupException e) {
                            CommonCore.getLogManager().log(new Message((Throwable)e));
                        }
                    }
                    catch (VDBException e1) {
                        CommonCore.getLogManager().log(new Message(4, "Invalid signature for method: " + val + " error:" + e1.toString()));
                    }
                    catch (Exception e) {
                        CommonCore.getLogManager().log(new Message(4, "Problem getting method object for signature: " + val + " error:" + e.toString()));
                    }
                }
            } else if (element.getName().getLocalPart().equals("vulnerability_type")) {
                if (this.m_in_action_object) {
                    String vuln = value.getText();
                    try {
                        this.m_ao.setVulnerability(vuln);
                    }
                    catch (BadMarkupException e) {
                        CommonCore.getLogManager().log(new Message(4, "Invalid vulnerability for action object " + vuln + e.toString()));
                    }
                }
            } else if (element.getName().getLocalPart().equals("severity")) {
                if (this.m_in_action_object) {
                    try {
                        this.m_ao.setSeverity(EnumProvider.getSeverity(value.getText()));
                    }
                    catch (BadMarkupException e) {
                        this.m_in_action_object = false;
                        CommonCore.getLogManager().log(new Message(4, "Error setting action object severity" + value.getText() + " reason:" + e.toString()));
                    }
                }
            } else if (element.getName().getLocalPart().equals("vulnerability")) {
                if (this.m_in_action_object) {
                    try {
                        this.m_ao.setVulnerability(value.getText());
                    }
                    catch (BadMarkupException e) {
                        this.m_in_action_object = false;
                        CommonCore.getLogManager().log(new Message(4, "Error setting action object vulnerability" + value.getText() + " reason:" + e.toString()));
                    }
                }
            } else if (element.getName().getLocalPart().equals("property") && this.m_method != null) {
                String prop = null;
                try {
                    prop = value.getText();
                    this.m_method.addProperty(prop);
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error setting action object vulnerability" + value.getText() + " reason:" + e.toString()));
                }
            } else if (element.getName().getLocalPart().equals("comment") && this.m_method != null) {
                this.m_method.addComment(value.getText());
            } else if (element.getName().getLocalPart().equals("class_hierachy_chain") && this.m_method != null) {
                String chain = value.getText();
                if (chain.contains(",")) {
                    for (String c : chain.split(",")) {
                        this.m_method.addClassHierachyChain(c);
                    }
                } else {
                    this.m_method.addClassHierachyChain(chain);
                }
            } else if (element.getName().getLocalPart().equals("class_interfaces") && this.m_method != null) {
                String chain = value.getText();
                if (chain.contains(",")) {
                    for (String c : chain.split(",")) {
                        this.m_method.addClassInterfaces(c);
                    }
                } else {
                    this.m_method.addClassInterfaces(chain);
                }
            }
        }
        return super.process(element, value);
    }

    @Override
    protected boolean process(EndElement element) {
        if (element.getName().getLocalPart().equals("method") || element.getName().getLocalPart().equals("nonclassfunction")) {
            try {
                if (this.m_is_public) {
                    this.m_vdb.addMethod(this.m_method);
                }
            }
            catch (BadMarkupException e) {
                CommonCore.getLogManager().log(new Message(4, "Error adding method " + this.m_method.getSignature() + e.toString()));
            }
            this.m_method_id = null;
            this.m_method = null;
        } else if (element.getName().getLocalPart().equals("rule") || element.getName().getLocalPart().equals("sink_rule") || element.getName().getLocalPart().equals("source_rule")) {
            if (this.m_in_action_object) {
                try {
                    this.m_ao.setId(this.m_ao_id);
                    this.m_method.addActionObject(this.m_ao);
                    for (Option o : this.m_extra_options) {
                        ActionObject a = new ActionObject();
                        a.setAoType(this.m_ao.getAoType());
                        a.setSeverity(this.m_ao.getSeverity());
                        a.setVulnerability(this.m_ao.getVulnerability());
                        a.addOption(o);
                        this.m_method.addActionObject(a);
                    }
                }
                catch (BadMarkupException e) {
                    CommonCore.getLogManager().log(new Message(4, "Error adding action object " + this.m_ao.toString() + " to method " + this.m_method.getSignature() + " error:" + e.toString()));
                }
            }
            this.m_ao_id = null;
            this.m_in_action_object = false;
        } else if (element.getName().getLocalPart().equals("package") || element.getName().getLocalPart().equals("namespace")) {
            this.m_package = null;
        } else if (element.getName().getLocalPart().equals("class") || element.getName().getLocalPart().equals("interface")) {
            this.m_class = null;
        } else if (element.getName().getLocalPart().equals("Header")) {
            this.m_vdb = new Vdb(this.m_lang);
        } else if (element.getName().getLocalPart().equals("method_annotations")) {
            this.m_method.setMethodAnnotation(this.m_annotations);
        } else if (element.getName().getLocalPart().equals("class_annotations")) {
            this.m_method.setClassAnnotations(this.m_annotations);
        } else if (element.getName().getLocalPart().equals("arg_annotations")) {
            this.m_method.setArgAnnotations(this.m_arg_annotations);
        } else if (element.getName().getLocalPart().equals("arg")) {
            this.m_arg_annotations.put(this.m_current_arg_type, this.m_annotations);
        } else if (element.getName().getLocalPart().equals("annotation")) {
            this.m_annotations.add(this.m_annotation);
        }
        return super.process(element);
    }

    protected Vdb getVdb() {
        return this.m_vdb;
    }
}

