/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.save;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.data.file.save.ClassWriter;
import com.ibm.appscan.vdb.provider.data.file.save.MethodWriter;
import com.ibm.appscan.vdb.provider.data.file.save.PackageWriter;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class VdbWriter {
    private DOMWriter m_writer;
    private DocumentBuilder m_builder;
    private Transformer m_transformer;
    private OutputStream m_stream;
    private PackageWriter m_package_writer;
    private ClassWriter m_class_writer;
    private MethodWriter m_method_writer;

    public VdbWriter(OutputStream stream) throws VDBGeneralException {
        this.m_stream = stream;
        this.init();
        this.m_writer = new DOMWriter(this.m_stream, this.m_builder);
    }

    protected DOMWriter getDomWriter() {
        return this.m_writer;
    }

    public void setDomWriterFile(File f) throws VDBGeneralException {
        try {
            this.m_writer = new DOMWriter(f.getParentFile(), f.getName(), this.m_builder);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    private PackageWriter getPackageWriter() {
        if (this.m_package_writer == null) {
            this.m_package_writer = new PackageWriter(this.m_writer);
        }
        return this.m_package_writer;
    }

    private ClassWriter getClassWriter() {
        if (this.m_class_writer == null) {
            this.m_class_writer = new ClassWriter(this.m_writer);
        }
        return this.m_class_writer;
    }

    private MethodWriter getMethodWriter() {
        if (this.m_method_writer == null) {
            this.m_method_writer = new MethodWriter(this.m_writer);
        }
        return this.m_method_writer;
    }

    private void init() throws VDBGeneralException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.m_builder = factory.newDocumentBuilder();
            TransformerFactory transform_factory = TransformerFactory.newInstance();
            this.m_transformer = transform_factory.newTransformer();
            this.m_transformer.setOutputProperty("indent", "yes");
            this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.m_transformer.setOutputProperty("standalone", "yes");
        }
        catch (ParserConfigurationException e) {
            throw new VDBGeneralException("Issue initializing document writer {0}", e.getLocalizedMessage());
        }
        catch (TransformerConfigurationException tce) {
            throw new VDBGeneralException("Issue configuring the transformer: {0}", tce.getLocalizedMessage());
        }
    }

    @SuppressSecurityTrace
    public boolean writeVdb(Vdb v) throws VDBGeneralException {
        this.m_writer.beginElement("LanguageDependentDB");
        this.addHeader(v);
        this.m_writer.beginElement("api_info");
        this.writePackages(v);
        this.writeClasses(v);
        this.writeNonClassFuncs(v);
        this.m_writer.endElement();
        this.m_writer.endElement();
        try {
            this.m_writer.write(this.m_transformer);
        }
        catch (TransformerException e) {
            throw new VDBGeneralException(e);
        }
        finally {
            IOUtil.close((Closeable)this.m_stream);
        }
        return true;
    }

    private boolean writeClasses(Vdb v) throws VDBGeneralException {
        for (VdbClass c : v.getClassMap().values()) {
            this.getClassWriter().writeClass(c);
        }
        return true;
    }

    private boolean writePackages(Vdb v) throws VDBGeneralException {
        for (VdbPackage p : v.getPackageMap().values()) {
            this.getPackageWriter().writePackage(p);
        }
        return true;
    }

    private boolean writeNonClassFuncs(Vdb v) throws VDBGeneralException {
        if (v.getNonClassFunctions().size() > 0) {
            for (Method m : v.getNonClassFunctions().values()) {
                this.getMethodWriter().writeMethod(m);
            }
        }
        return true;
    }

    private void addHeader(Vdb v) {
        this.m_writer.beginElement("Header");
        this.m_writer.setAttribute("language", v.getLang().to90String());
        this.m_writer.setAttribute("version", "3.0.0");
        this.m_writer.beginElement("description");
        this.m_writer.endElement("# # Ounce Labs Confidential # # Copyright (c) 2003, 2004 Ounce Labs, Inc. All-Rights Reserved. # # <a href=\"http://www.ouncelabs.com\">Ounce Labs</a> # # This software and documentation constitute an unpublished work and contains # valuable trade secrets and proprietary information belonging to Ounce Labs. # None of the foregoing material may be copied, duplicated or disclosed # without the express written permission of Ounce Labs. #");
        this.m_writer.endElement();
    }
}

