/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.property;

import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.misc.VDBEnums;
import java.util.ArrayList;

public abstract class BasePropertyProvider {
    public abstract boolean addProperty(String var1) throws VDBGeneralException;

    public ArrayList<String> getProperties(VDBEnums.PROPERTY_TYPE type) throws VDBGeneralException {
        if (type == VDBEnums.PROPERTY_TYPE.TECHNOLOGY) {
            return this.getTechnologies();
        }
        if (type == VDBEnums.PROPERTY_TYPE.MECHANISM) {
            return this.getMechanisms();
        }
        if (type == VDBEnums.PROPERTY_TYPE.VULNERABILITY) {
            return this.getVulnerabilities();
        }
        return this.getProperties();
    }

    public abstract ArrayList<String> getVulnerabilities() throws VDBGeneralException;

    public abstract ArrayList<String> getAllVulnerabilities() throws VDBGeneralException;

    public abstract ArrayList<String> getMechanisms() throws VDBGeneralException;

    public abstract ArrayList<String> getTechnologies() throws VDBGeneralException;

    public abstract ArrayList<String> getProperties() throws VDBGeneralException;

    public abstract int getPropertyId(String var1) throws VDBGeneralException;

    public abstract String getPropertyFqn(int var1) throws VDBGeneralException;

    public abstract boolean isMechanism(int var1) throws VDBGeneralException;

    public boolean isMechanism(String fqn) {
        return fqn.startsWith("Mechanism");
    }

    public abstract boolean isTechnology(int var1) throws VDBGeneralException;

    public boolean isTechnology(String fqn) {
        return fqn.startsWith("Technology");
    }

    public boolean isProperty(int id) throws VDBGeneralException {
        return !this.isVulnerability(id) && !this.isTechnology(id) && !this.isMechanism(id);
    }

    public abstract boolean isVulnerability(int var1) throws VDBGeneralException;

    public boolean isVulnerability(String fqn) {
        return fqn.startsWith("Vulnerability");
    }
}

