/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.rest;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.rest.BaseRestClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Set;

public class AuditRestClient
extends BaseRestClient {
    private Language.LANGUAGE m_lang;

    protected AuditRestClient(Language.LANGUAGE lang, String host, String port, boolean secure) {
        super(host, port, secure);
        this.m_lang = lang;
    }

    @Override
    protected String getApplicationBase() {
        return "sast/audit";
    }

    public Set<String> getAuditDates() throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/list/dates", "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during audit date retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Vdb getBeforePackageVdb(String date, String package_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/" + date + "/before/" + package_name, "GET");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                throw new VDBGeneralException("Server error during before package retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Vdb getAfterPackageVdb(String date, String package_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/" + date + "/after/" + package_name, "GET");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                throw new VDBGeneralException("Server error during after package retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Vdb getBeforeNcfVdb(String date, String package_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/" + date + "/before/ncf", "GET");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                throw new VDBGeneralException("Server error during before ncf vbd retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Vdb getAfterNcfVdb(String date, String package_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/" + date + "/before/ncf", "GET");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                throw new VDBGeneralException("Server error during after ncf vbd retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Set<String> getPackages(String bucket, String date) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/list/dates/" + date + "/" + bucket + "/packages", "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during packge list retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getClassesForPackage(String bucket, String date, String package_name) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/list/dates/" + date + "/" + bucket + "/packages/" + package_name, "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during packge list retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getMethodsForClass(String bucket, String date, String package_name, String class_name) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/list/dates/" + date + "/" + bucket + "/packages/" + package_name + "/" + class_name, "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during packge list retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getNcfs(String bucket, String date, String package_name, String class_name) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_lang.toString() + "/list/dates/" + date + "/" + bucket + "/non-class-funcs", "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during packge list retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }
}

