/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.rest;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.rest.AuditRestClient;
import com.ibm.appscan.vdb.provider.rest.AutoRestClient;
import com.ibm.appscan.vdb.provider.rest.BaseMarkupRestClient;
import com.ibm.appscan.vdb.provider.rest.BaseRuleRestClient;
import com.ibm.appscan.vdb.provider.rest.FactoryRestClient;
import com.ibm.appscan.vdb.provider.rest.IgnoreRestClient;
import com.ibm.appscan.vdb.provider.rest.MergeRestClient;
import com.ibm.appscan.vdb.provider.rest.MissingRestClient;
import com.ibm.appscan.vdb.provider.rest.NewRestClient;
import com.ibm.appscan.vdb.provider.rest.QueryRuleRestClient;
import com.ibm.appscan.vdb.provider.rest.RuleRestClient;
import com.ibm.appscan.vdb.provider.rest.VulnerabilityRestClient;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Properties;

public class RestProvider {
    private HashMap<Language.LANGUAGE, BaseMarkupRestClient> m_clients;
    private HashMap<Language.LANGUAGE, BaseMarkupRestClient> m_missing_clients;
    private HashMap<Language.LANGUAGE, BaseMarkupRestClient> m_ignore_clients;
    private HashMap<Language.LANGUAGE, BaseMarkupRestClient> m_merge_clients;
    private HashMap<Language.LANGUAGE, BaseMarkupRestClient> m_new_clients;
    private HashMap<Language.LANGUAGE, BaseMarkupRestClient> m_auto_clients;
    private HashMap<Language.LANGUAGE, AuditRestClient> m_audit_clients;
    private HashMap<Language.LANGUAGE, BaseRuleRestClient> m_rule_clients;
    private HashMap<Language.LANGUAGE, BaseRuleRestClient> m_query_clients;
    private static final String m_properties_filepath = CommonCore.getDirectoryLocator().getConfig() + "markup-server.properties";
    private String m_host = this.getHostName();
    private String m_port = this.getPort();
    private boolean m_secure = this.getSecure();
    private VulnerabilityRestClient m_v_rest_client;
    private static RestProvider s_provider = new RestProvider();

    private RestProvider() {
    }

    private static RestProvider getInstance() {
        return s_provider;
    }

    private String getPropertiesFromFile(String property) {
        Properties props = new Properties();
        try {
            props.load(new FileReader(m_properties_filepath));
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage((String)"file.read.error", (Object[])new Object[]{m_properties_filepath})));
        }
        return props.getProperty(property);
    }

    public String getHostName() {
        String host = this.getPropertiesFromFile("host");
        return host == null ? this.m_host : host;
    }

    public String getPort() {
        String port = this.getPropertiesFromFile("port");
        return port == null ? this.m_port : port;
    }

    public boolean getSecure() {
        String secure = this.getPropertiesFromFile("secure");
        return secure == null ? this.m_secure : Boolean.parseBoolean(secure);
    }

    public static void setHostName(String host) {
        RestProvider.getInstance().m_host = host;
        RestProvider.reset();
    }

    public static void setPort(String port) {
        RestProvider.getInstance().m_port = port;
        RestProvider.reset();
    }

    public static void setSecure(boolean secure) {
        RestProvider.getInstance().m_secure = secure;
        RestProvider.reset();
    }

    private static void reset() {
        RestProvider.getInstance().m_clients = null;
        RestProvider.getInstance().m_ignore_clients = null;
        RestProvider.getInstance().m_merge_clients = null;
        RestProvider.getInstance().m_missing_clients = null;
        RestProvider.getInstance().m_new_clients = null;
        RestProvider.getInstance().m_v_rest_client = null;
        RestProvider.getInstance().m_query_clients = null;
        RestProvider.getInstance().m_rule_clients = null;
    }

    public static BaseMarkupRestClient getFactoryRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_clients == null) {
            RestProvider.getInstance().m_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_clients.containsKey(lang)) {
            RestProvider.getInstance().m_clients.put(lang, new FactoryRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_clients.get(lang);
    }

    public static BaseMarkupRestClient getMissingRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_missing_clients == null) {
            RestProvider.getInstance().m_missing_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_missing_clients.containsKey(lang)) {
            RestProvider.getInstance().m_missing_clients.put(lang, new MissingRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_missing_clients.get(lang);
    }

    public static BaseMarkupRestClient getIgnoreRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_ignore_clients == null) {
            RestProvider.getInstance().m_ignore_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_ignore_clients.containsKey(lang)) {
            RestProvider.getInstance().m_ignore_clients.put(lang, new IgnoreRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_ignore_clients.get(lang);
    }

    public static BaseMarkupRestClient getMergeRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_merge_clients == null) {
            RestProvider.getInstance().m_merge_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_merge_clients.containsKey(lang)) {
            RestProvider.getInstance().m_merge_clients.put(lang, new MergeRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_merge_clients.get(lang);
    }

    public static BaseMarkupRestClient getNewRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_new_clients == null) {
            RestProvider.getInstance().m_new_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_new_clients.containsKey(lang)) {
            RestProvider.getInstance().m_new_clients.put(lang, new NewRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_new_clients.get(lang);
    }

    public static BaseMarkupRestClient getAutoRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_auto_clients == null) {
            RestProvider.getInstance().m_auto_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_auto_clients.containsKey(lang)) {
            RestProvider.getInstance().m_auto_clients.put(lang, new AutoRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_auto_clients.get(lang);
    }

    public static VulnerabilityRestClient getVulnerabilityRestClient() {
        if (RestProvider.getInstance().m_v_rest_client == null) {
            RestProvider.getInstance().m_v_rest_client = new VulnerabilityRestClient(RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure);
        }
        return RestProvider.getInstance().m_v_rest_client;
    }

    public static BaseRuleRestClient getRuleRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_rule_clients == null) {
            RestProvider.getInstance().m_rule_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_rule_clients.containsKey(lang)) {
            RestProvider.getInstance().m_rule_clients.put(lang, new RuleRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_rule_clients.get(lang);
    }

    public static BaseRuleRestClient getQueryRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_query_clients == null) {
            RestProvider.getInstance().m_query_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_query_clients.containsKey(lang)) {
            RestProvider.getInstance().m_query_clients.put(lang, new QueryRuleRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_query_clients.get(lang);
    }

    public static AuditRestClient getAuditRestClient(Language.LANGUAGE lang) {
        if (RestProvider.getInstance().m_audit_clients == null) {
            RestProvider.getInstance().m_audit_clients = new HashMap();
        }
        if (!RestProvider.getInstance().m_audit_clients.containsKey(lang)) {
            RestProvider.getInstance().m_audit_clients.put(lang, new AuditRestClient(lang, RestProvider.getInstance().m_host, RestProvider.getInstance().m_port, RestProvider.getInstance().m_secure));
        }
        return RestProvider.getInstance().m_audit_clients.get(lang);
    }

    public static Method findMethod(Language.LANGUAGE lang, String signature) throws VDBGeneralException {
        return RestProvider.getFactoryRestClient(lang).findMethod(signature);
    }
}

