/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule;

import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.misc.VDBEnums;
import java.util.ArrayList;

public abstract class BaseRuleMember
implements Comparable<BaseRuleMember> {
    private String m_rule_value;
    private boolean m_delete = false;

    public abstract String getDetailName();

    public void setDelete(boolean delete) {
        this.m_delete = delete;
    }

    public boolean isDelete() {
        return this.m_delete;
    }

    public void setRuleValue(String value) throws BadRuleException {
        if (value == null) {
            throw new BadRuleException("Cannot use null for a rule value");
        }
        this.m_rule_value = value;
    }

    public String getRuleValue() {
        return this.m_rule_value;
    }

    public boolean isRuleValid() {
        return this.getRuleValue() != null && this.getRuleValue().length() != 0;
    }

    protected boolean compareValues(VDBEnums.RULE_OPERATOR operator, VDBEnums.AO_TYPE methodType) {
        return this.compareValues(operator, methodType.toString());
    }

    protected boolean compareValues(VDBEnums.RULE_OPERATOR operator, boolean methodValue) {
        return this.compareValues(operator, Boolean.toString(methodValue));
    }

    public boolean compareValues(VDBEnums.RULE_OPERATOR operator, int count, int value) {
        boolean result = false;
        if (operator == VDBEnums.RULE_OPERATOR.INTEGER_EQUALS || operator == VDBEnums.RULE_OPERATOR.EQUALS) {
            if (value == count) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.INTEGER_NOT_EQUALS || operator == VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL) {
            if (value != count) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN) {
            if (value < count) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN_EQUALS) {
            if (value <= count) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN) {
            if (value > count) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN_EQUALS && value >= count) {
            result = true;
        }
        return result;
    }

    protected boolean compareValues(VDBEnums.RULE_OPERATOR operator, String methodValue) {
        return this.compareValues(operator, this.getRuleValue(), methodValue);
    }

    protected boolean compareValues(VDBEnums.RULE_OPERATOR operator, String rule_value, String methodValue) {
        if (operator == VDBEnums.RULE_OPERATOR.NULL) {
            return false;
        }
        rule_value = rule_value != null ? rule_value.toLowerCase() : "";
        methodValue = methodValue != null ? methodValue.toLowerCase() : "";
        rule_value = rule_value.replace("$", "");
        methodValue = methodValue.replace("$", "");
        rule_value = rule_value.replace(".", "");
        methodValue = methodValue.replace(".", "");
        boolean result = false;
        if (operator == VDBEnums.RULE_OPERATOR.EQUALS) {
            if (methodValue.equals(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL) {
            if (!methodValue.equals(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.STARTS_WITH) {
            if (methodValue.startsWith(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH) {
            if (!methodValue.startsWith(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.ENDS_WITH) {
            if (methodValue.endsWith(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.DOES_NOT_END_WITH) {
            if (!methodValue.endsWith(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.CONTAINS) {
            if (methodValue.equals(rule_value) || methodValue.contains(rule_value)) {
                result = true;
            }
        } else if (operator == VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN && !methodValue.equals(rule_value) && !methodValue.contains(rule_value)) {
            result = true;
        }
        return result;
    }

    protected boolean compareValues(VDBEnums.RULE_OPERATOR operator, ArrayList<String> methodValues) {
        boolean rtnValue = false;
        if (operator == VDBEnums.RULE_OPERATOR.CONTAINS || operator == VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN) {
            if (methodValues.size() == 0) {
                return operator != VDBEnums.RULE_OPERATOR.CONTAINS;
            }
            for (String value : methodValues) {
                if (!this.compareValues(operator, value)) continue;
                return true;
            }
        } else if (methodValues.size() == 1) {
            return this.compareValues(operator, methodValues.get(0));
        }
        return rtnValue;
    }

    @Override
    public int compareTo(BaseRuleMember o) {
        if (this.getRuleValue() == null && o.getRuleValue() != null) {
            return -1;
        }
        if (this.getRuleValue() != null) {
            if (o.getRuleValue() == null) {
                return 1;
            }
            return this.getRuleValue().compareToIgnoreCase(o.getRuleValue());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseRuleMember) {
            BaseRuleMember rule = (BaseRuleMember)obj;
            return this.compareTo(rule) == 0;
        }
        return super.equals(obj);
    }
}

