/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup;

import com.hcl.appscan.common.error.ComponentException;
import com.hcl.appscan.common.mlservices.MLServiceFactory;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.Messages;
import com.ibm.appscan.ica.markup.trainer.TaintTrainer;
import com.ibm.appscan.ica.markup.trainer.binary.SinkBinaryTrainer;
import com.ibm.appscan.ica.markup.trainer.binary.SourceBinaryTrainer;
import com.ibm.appscan.ica.markup.trainer.binary.TaintBinaryTrainer;
import com.ibm.appscan.ica.model.IIcaModel;
import com.ibm.appscan.ica.model.IcaServiceFactory;
import com.ibm.appscan.ica.model.IcaSinkModel;
import com.ibm.appscan.ica.model.IcaSinkPipeline;
import com.ibm.appscan.ica.model.IcaSinkVulnModel;
import com.ibm.appscan.ica.model.IcaSourceModel;
import com.ibm.appscan.ica.model.IcaTaintModel;
import com.ibm.appscan.ica.model.LazyModel;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

public class MarkupRunner {
    private IIcaModel m_sourceModel;
    private IIcaModel m_taintModel;
    private IIcaModel m_sinkModel;
    private boolean isIca2 = false;
    public static final String ICA_MAIN_ENDPOINT = "ICA_MAIN_ENDPOINT";
    public static final String ICA_VULN_ENDPOINT = "ICA_VULN_ENDPOINT";
    private ILogManager m_logger;

    public MarkupRunner() throws ComponentException {
        this(CommonCore.getLogManager());
    }

    public MarkupRunner(ILogManager logger) throws ComponentException {
        this.m_logger = logger;
        if (!SystemUtil.isIcaEnabled()) {
            this.m_logger.log(new Message(1, Messages.getMessage("ica.disabled", new Object[0])));
            return;
        }
    }

    public void initializeModels(boolean isIca2) throws ComponentException {
        if (isIca2) {
            this.m_logger.log(new Message(1, Messages.getMessage("ica.2.enabled", new Object[0])));
            try {
                IcaSinkVulnModel vuln;
                IcaSinkModel sink;
                IcaTaintModel taint;
                IcaSourceModel source;
                if (MLServiceFactory.areServicesAvailable()) {
                    source = (IcaSourceModel)IcaServiceFactory.get().build(IcaSourceModel.class);
                    taint = (IcaTaintModel)IcaServiceFactory.get().build(IcaTaintModel.class);
                    sink = (IcaSinkModel)IcaServiceFactory.get().build(IcaSinkModel.class);
                    vuln = (IcaSinkVulnModel)IcaServiceFactory.get().build(IcaSinkVulnModel.class);
                } else if (MarkupRunner.getMainEndpointSetting().isPresent() && MarkupRunner.getVulnEndpointSetting().isPresent()) {
                    source = (IcaSourceModel)IcaServiceFactory.get().build(IcaSourceModel.class, MarkupRunner.getMainEndpointSetting().get());
                    taint = (IcaTaintModel)IcaServiceFactory.get().build(IcaTaintModel.class, MarkupRunner.getMainEndpointSetting().get());
                    sink = (IcaSinkModel)IcaServiceFactory.get().build(IcaSinkModel.class, MarkupRunner.getMainEndpointSetting().get());
                    vuln = (IcaSinkVulnModel)IcaServiceFactory.get().build(IcaSinkVulnModel.class, MarkupRunner.getVulnEndpointSetting().get());
                } else {
                    throw new ComponentException(Messages.getMessage("ica.2.addressMissing", new Object[0]));
                }
                if (!(source.getHealth() && taint.getHealth() && sink.getHealth() && vuln.getHealth())) {
                    throw new ComponentException(Messages.getMessage("ica.2.serviceUnhealthy", new Object[0]));
                }
                this.m_sourceModel = source;
                this.m_taintModel = taint;
                this.m_sinkModel = new IcaSinkPipeline(sink, vuln);
                this.m_logger.log(new Message(1, Messages.getMessage("ica.2.ready", new Object[0])));
            }
            catch (Exception e) {
                throw new ComponentException("Failed to initialize ICA 2.0 Models: " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.m_logger.log(new Message(1, Messages.getMessage("ica.1.enabled", new Object[0])));
            this.m_sourceModel = new LazyModel(SourceBinaryTrainer::new);
            this.m_taintModel = new LazyModel(TaintBinaryTrainer::new);
            this.m_sinkModel = new LazyModel(SinkBinaryTrainer::new);
        }
    }

    public static Optional<String> getMainEndpointSetting() {
        return Optional.ofNullable(System.getProperty(ICA_MAIN_ENDPOINT));
    }

    public static Optional<String> getVulnEndpointSetting() {
        return Optional.ofNullable(System.getProperty(ICA_VULN_ENDPOINT));
    }

    public void saveVdbsToDir(Vdb v, File root) throws IfaException {
        this.saveVdbsToDir(v, root, "methods.vdb");
    }

    public void saveVdbsToDir(Vdb v, File root, String name) throws IfaException {
        root = new File(root + File.separator + v.getLang().toVdbString());
        try {
            VdbProvider.saveVdb((Vdb)v, (File)new File(root, name));
        }
        catch (VDBGeneralException e) {
            throw new IfaException((Throwable)e);
        }
    }

    public Vdb applyMarkup(Vdb v) throws IfaException, ComponentException {
        try {
            v = VdbProvider.getVdbFromVdb((Vdb)v);
            if (SystemUtil.isDisablePropertyNotSet((String)"ENABLE_ICA2") || SystemUtil.isCommonEngine()) {
                if (SystemUtil.isCommonEngine()) {
                    this.m_logger.log(new Message(1, Messages.getMessage("ica.2.commonEngine", new Object[0])));
                }
            } else if (v.getLang() == Language.LANGUAGE.JAVA) {
                this.isIca2 = true;
            }
            this.initializeModels(this.isIca2);
            this.applyIca(v.getMethods());
            Vdb ret = new Vdb(v.getLang());
            for (Method m : v.getMethods()) {
                if (!m.isMarkedUp()) continue;
                ret.addMethod(m);
            }
            try {
                Method ext = VdbProvider.getAutomaticCallbackSourceMethod((Language.LANGUAGE)v.getLang());
                if (ext != null) {
                    ret.addMethod(ext);
                }
                if ((ext = VdbProvider.getExternalSourceMethod((Language.LANGUAGE)v.getLang())) != null) {
                    ret.addMethod(ext);
                }
                if ((ext = VdbProvider.getExternalTaintMethod((Language.LANGUAGE)v.getLang())) != null) {
                    ret.addMethod(ext);
                }
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException((Throwable)e);
            }
            catch (VDBException e) {
                throw new VDBGeneralException((Throwable)e);
            }
            return ret;
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
        catch (VDBGeneralException e) {
            throw new IfaException((Throwable)e);
        }
    }

    public Vdb applyMarkupIcaStats(Vdb v) throws IfaException, ComponentException, VDBException {
        try {
            v = VdbProvider.getVdbFromVdb((Vdb)v);
            this.initializeModels(true);
            Vdb tmp = new Vdb(v.getLang());
            for (Method m : v.getMethods()) {
                if (m.isMarkedUp()) continue;
                tmp.addMethod(m);
            }
            this.applyIca(tmp.getMethods());
            Vdb ret = new Vdb(tmp.getLang());
            for (Method m : tmp.getMethods()) {
                if (!m.isMarkedUp()) continue;
                Method temp_m = MethodProvider.getMethod((Method)m);
                temp_m.getComments().clear();
                ret.addMethod(temp_m);
            }
            return ret;
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
        catch (VDBException e) {
            throw new IfaException((Throwable)e);
        }
    }

    private static String getPackagePrefix(Method m) {
        String[] p;
        if (m.getLang() != Language.LANGUAGE.JAVA) {
            return m.getPackageName();
        }
        if (m.getPackageName() != null && m.getPackageName().length() > 0 && (p = m.getPackageName().split("\\.")).length > 1) {
            return p[0] + "." + p[1];
        }
        return null;
    }

    static Collection<Method> filterForIca(Collection<Method> methods) throws BadMarkupException, ExclusionException {
        HashSet<String> defined_packages = new HashSet<String>();
        for (Method m : methods) {
            String s;
            if (!m.isDefined() || m.isMarkedUp() || (s = MarkupRunner.getPackagePrefix(m)) == null) continue;
            defined_packages.add(s);
        }
        ArrayList<Method> forIca = new ArrayList<Method>(methods.size());
        for (Method m : methods) {
            String s = MarkupRunner.getPackagePrefix(m);
            if (s != null && defined_packages.contains(s) || m.isDefined() || m.isMarkedUp() || m.getSimpleMethodName().toLowerCase().equals("main") || ExclusionProvider.getExclusion((Language.LANGUAGE)m.getLang()) != null && ExclusionProvider.getExclusion((Language.LANGUAGE)m.getLang()).isExcludedFromAutoMarkup(m) || m.getSignature().matches(".*?[a-zA-Z]+__[a-zA-Z0-9@]+.*")) continue;
            forIca.add(m);
        }
        return forIca;
    }

    protected void applyIca(Collection<Method> methods) throws IfaException, ComponentException {
        try {
            Collection<Method> forIca = MarkupRunner.filterForIca(methods);
            this.m_sourceModel.predict(forIca.stream().filter(m -> m.getSources().size() == 0 && m.getSinks().size() == 0).collect(Collectors.toList()));
            this.m_sinkModel.predict(forIca.stream().filter(m -> m.getSources().size() == 0 && m.getSinks().size() == 0).collect(Collectors.toList()));
            if (this.isIca2) {
                this.applyTaintPrefilter(forIca);
            }
            this.m_taintModel.predict(forIca.stream().filter(m -> m.getTaints().isEmpty()).filter(m -> m.getLang() == Language.LANGUAGE.JAVA && !m.isConstructor() || m.getLang() != Language.LANGUAGE.JAVA).collect(Collectors.toList()));
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
        catch (ExclusionException e) {
            throw new IfaException((Throwable)e);
        }
    }

    private void applyTaintPrefilter(Collection<Method> methods) {
        TaintTrainer t = new TaintTrainer();
        methods.forEach(m -> {
            if (m.getLang() != Language.LANGUAGE.JAVA) {
                return;
            }
            try {
                Taint taint = this.getTaintFromTrainer((Method)m, t);
                if (taint != null) {
                    m.addTaint(taint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private Taint getTaintFromTrainer(Method m, TaintTrainer t) throws IfaException, BadMarkupException {
        if (t.ruleApplies(m)) {
            return new Taint(t.getTaintFromString(t.getMarkupFromRule(m)));
        }
        return null;
    }
}

