/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.data;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.data.RawMarkupData;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.ifa.event.IfaEventHandler;
import com.ibm.appscan.ifa.event.IfaEventManager;
import com.ibm.appscan.ifa.tfidf.TfidfCalculator;
import com.ibm.appscan.ifa.tfidf.TfidfDictionary;
import com.ibm.appscan.ifa.tfidf.TfidfException;
import com.ibm.appscan.tokenizer.BaseTokenizer;
import com.ibm.appscan.tokenizer.MethodAllTokenizer;
import com.ibm.appscan.tokenizer.MethodArgTokenizer;
import com.ibm.appscan.tokenizer.MethodClassTokenizer;
import com.ibm.appscan.tokenizer.MethodNameTokenizer;
import com.ibm.appscan.tokenizer.MethodReturnTokenizer;
import com.ibm.appscan.tokenizer.PackageTokenizer;
import com.ibm.appscan.tokenizer.TokenizerException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.File;
import java.util.HashMap;

public class MarkupNormalizer
implements IfaEventHandler {
    private String m_associated_class;
    private RawMarkupData m_raw;
    private HashMap<MarkupActiveFeatures.MARKUP_FEATURES, TfidfCalculator> m_dictionaries = new HashMap();
    private MarkupTranslator m_translator;
    private HashMap<MarkupActiveFeatures.MARKUP_FEATURES, BaseTokenizer> m_tokenizers = new HashMap();
    private MarkupActiveFeatures m_active_features;
    private File m_dictionary_directory;

    public MarkupNormalizer(MarkupTranslator translator, RawMarkupData raw, String associated_class, MarkupActiveFeatures features) {
        this.m_raw = raw;
        this.m_translator = translator;
        this.m_associated_class = associated_class;
        this.m_active_features = features;
        this.m_dictionary_directory = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "dictionaries");
        IfaEventManager.addIfaEventListener((IfaEventHandler)this);
    }

    protected String processMarkup(StringBuffer str, Method m) throws MarkupException {
        if (this.m_translator.getMarkupString(m).equals(this.m_associated_class)) {
            return "1";
        }
        return "0";
    }

    public String getNormalizedMethod(Method m) throws MarkupException {
        try {
            StringBuffer str = new StringBuffer();
            str.append(this.processMarkup(str, m));
            str.append(" ");
            for (int i = 0; i < this.m_active_features.getFeatures().size(); ++i) {
                str.append(i + 1);
                str.append(":");
                if (this.isTokenizeable(this.m_active_features.getFeatures().get(i))) {
                    try {
                        str.append(this.getDictionary(this.m_active_features.getFeatures().get(i)).calcAverageTFIDF(this.getTokenizer(this.m_active_features.getFeatures().get(i)).getTokenSentence((Object)m)));
                    }
                    catch (TfidfException e) {
                        throw new MarkupException(e);
                    }
                    catch (TokenizerException e) {
                        throw new MarkupException(e);
                    }
                    catch (IfaException e) {
                        throw new MarkupException(e);
                    }
                }
                if (this.isTokenizeableNegative(this.m_active_features.getFeatures().get(i))) {
                    try {
                        str.append(this.getDictionary(this.m_active_features.getFeatures().get(i)).calcAverageTFIDF(this.getTokenizer(this.m_active_features.getFeatures().get(i)).getTokenSentence((Object)m)));
                    }
                    catch (TfidfException e) {
                        throw new MarkupException(e);
                    }
                    catch (TokenizerException e) {
                        throw new MarkupException(e);
                    }
                    catch (IfaException e) {
                        throw new MarkupException(e);
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.ARG_COUNT) {
                    str.append(m.getArgs().size());
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.STATIC) {
                    if (m.isStatic() || m.getMethodName().startsWith("+")) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.ALLOWS_RETURN) {
                    if (m.isReturn()) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.TYPE) {
                    if (m.isWebTechMech()) {
                        str.append("1");
                    } else if (m.isDbTechMech()) {
                        str.append("2");
                    } else if (m.isFileTechMech()) {
                        str.append("3");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.TECH_MECH) {
                    if (m.isDbTechMech()) {
                        str.append("1");
                    } else if (m.isFileTechMech()) {
                        str.append("2");
                    } else if (m.isWebTechMech()) {
                        str.append("3");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.META) {
                    if (m.isGetter() || VdbProvider.isGetterType((Method)m)) {
                        str.append("1");
                    } else if (m.isSetter() || VdbProvider.isSetterType((Method)m)) {
                        str.append("2");
                    } else if (m.isConstructor()) {
                        str.append("3");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.GETTER) {
                    if (m.isGetter() || VdbProvider.isGetterType((Method)m)) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.SETTER) {
                    if (m.isSetter() || VdbProvider.isSetterType((Method)m)) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.CONSTRUCTOR) {
                    if (m.isGetter() || VdbProvider.isGetterType((Method)m)) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.ALLOWS_TAINT_THROUGH_ARG) {
                    boolean allows = true;
                    for (String arg : m.getArgs()) {
                        if (VdbProvider.isTaintType((String)m.getSimpleArg(arg))) continue;
                        allows = false;
                        break;
                    }
                    if (allows) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.m_active_features.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.ALLOWS_TAINT_THROUGH_RETURN) {
                    if (!VdbProvider.isTaintType((String)m.getSimpleReturn())) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                }
                str.append(" ");
            }
            str.deleteCharAt(str.length() - 1);
            str.append(System.getProperty("line.separator"));
            String string = str.toString();
            return string;
        }
        catch (VDBException e) {
            throw new MarkupException(e);
        }
    }

    private TfidfCalculator getDictionary(MarkupActiveFeatures.MARKUP_FEATURES feature) throws TfidfException, TokenizerException, IfaException {
        if (!this.m_dictionaries.containsKey((Object)feature)) {
            File dict_file = new File(this.m_dictionary_directory.getPath() + File.separator + this.m_translator.getClass().getSimpleName() + File.separator + this.m_active_features.getLanguage().toVdbString() + File.separator + this.m_associated_class, feature.toString() + "_" + this.m_active_features.getDirString() + (this.isTokenizeableNegative(feature) ? "_NEG" : "") + ".dict");
            if (!dict_file.exists()) {
                dict_file.getParentFile().mkdirs();
                TfidfDictionary dict = new TfidfDictionary();
                for (Method m : this.m_raw.getTrainMethods()) {
                    if (this.isTokenizeableNegative(feature)) {
                        if (this.m_translator.getMarkupString(m).equals(this.m_associated_class)) continue;
                        dict.processNewDoc(this.getTokenizer(feature).getTokenSentence((Object)m));
                        continue;
                    }
                    if (!this.m_translator.getMarkupString(m).equals(this.m_associated_class)) continue;
                    dict.processNewDoc(this.getTokenizer(feature).getTokenSentence((Object)m));
                }
                dict.save(dict_file);
            }
            this.m_dictionaries.put(feature, new TfidfCalculator(new TfidfDictionary(dict_file)));
        }
        return this.m_dictionaries.get((Object)feature);
    }

    private boolean isTokenizeable(MarkupActiveFeatures.MARKUP_FEATURES feature) {
        return feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_ARGS || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_NAME || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_RETURN || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_CLASS || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PACKAGE;
    }

    private boolean isTokenizeableNegative(MarkupActiveFeatures.MARKUP_FEATURES feature) {
        return feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_NEG || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_ARGS_NEG || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_NAME_NEG || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_RETURN_NEG || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_CLASS_NEG || feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PACKAGE_NEG;
    }

    private BaseTokenizer getTokenizer(MarkupActiveFeatures.MARKUP_FEATURES feature) throws IfaException {
        if (this.m_tokenizers.get((Object)feature) == null) {
            this.m_tokenizers.put(feature, this.getTokenizerObject(feature));
        }
        return this.m_tokenizers.get((Object)feature);
    }

    private BaseTokenizer getTokenizerObject(MarkupActiveFeatures.MARKUP_FEATURES feature) throws IfaException {
        try {
            if (feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD) {
                return new MethodAllTokenizer();
            }
            if (feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_NAME) {
                return new MethodNameTokenizer();
            }
            if (feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_ARGS) {
                return new MethodArgTokenizer();
            }
            if (feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_RETURN) {
                return new MethodReturnTokenizer();
            }
            if (feature == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PACKAGE) {
                return new PackageTokenizer();
            }
            return new MethodClassTokenizer();
        }
        catch (TokenizerException e) {
            throw new IfaException((Throwable)e);
        }
    }

    public void handleDirtyEvent() {
        for (MarkupActiveFeatures.MARKUP_FEATURES f : this.m_dictionaries.keySet()) {
            new File(this.m_dictionary_directory, f.toString() + "_" + this.m_associated_class + "_" + this.m_active_features.getDirString() + ".dict").delete();
        }
        this.m_dictionaries.clear();
    }
}

