/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer.binary;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupData;
import com.ibm.appscan.ica.markup.data.RawMarkupData;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.ica.model.IIcaModel;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.ifa.model.SparkLogisiticRegressionModel;
import com.ibm.appscan.ifa.model.SparkModel;
import com.ibm.appscan.vdb.method.Method;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public abstract class BinaryMarkupTrainer
implements IIcaModel {
    private HashMap<String, HashMap<Language.LANGUAGE, SparkModel>> m_models;
    private HashMap<Language.LANGUAGE, HashMap<String, Integer>> m_classes;
    private HashMap<Language.LANGUAGE, File> m_class_file = new HashMap();
    private HashMap<String, HashMap<Language.LANGUAGE, MarkupData>> m_data;
    private MarkupTranslator m_checker;
    private HashMap<Language.LANGUAGE, RawMarkupData> m_raw_data;

    @Override
    public synchronized void predict(Collection<Method> methods) throws IfaException {
        for (Method m : methods) {
            m.addComment(this.printPredictions(m));
            if (this.getTranslator().hasMarkup(m)) continue;
            this.applyMarkup(m, this.getPredictedClass(m));
        }
    }

    public synchronized String getPredictedClass(Method m) throws MarkupException, IfaException {
        if (this.getTranslator().ruleAppliesToMethod(m) && this.getTranslator().isValidClassForMethod(this.getTranslator().getMarkupFromRule(m), m)) {
            return this.getTranslator().getMarkupFromRule(m);
        }
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (String clazz : this.getClasses(m.getLang())) {
            if (!this.getTranslator().isValidClassForMethod(clazz, m)) continue;
            results.put(clazz, this.getModel(clazz, m.getLang()).predict(this.getMarkupData(clazz, m.getLang()).getVector(m)));
        }
        LinkedHashMap<String, Double> map = this.getSortedProbabilities(results);
        for (String key : map.keySet()) {
            if (!(map.get(key) > this.getThreshold())) continue;
            return key;
        }
        return this.getTranslator().getDefaultValue();
    }

    protected double getThreshold() {
        return 0.0;
    }

    private RawMarkupData getRawMarkupData(Language.LANGUAGE lang) {
        if (this.m_raw_data == null) {
            this.m_raw_data = new HashMap();
        }
        if (this.m_raw_data.get(lang) == null) {
            this.m_raw_data.put(lang, new RawMarkupData(this.getTranslator(), this.getClass().getSimpleName(), lang));
        }
        return this.m_raw_data.get(lang);
    }

    public synchronized String printPredictions(Method m) throws MarkupException, IfaException {
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getSimpleName() + ": Predicted markup:" + this.getPredictedClass(m));
        str.append(System.getProperty("line.separator"));
        HashMap<String, Double> preds = new HashMap<String, Double>();
        for (String clazz : this.getClasses(m.getLang())) {
            double pred;
            if (!this.getTranslator().isValidClassForMethod(clazz, m) || (pred = this.getModel(clazz, m.getLang()).predict(this.getMarkupData(clazz, m.getLang()).getVector(m))) == 0.0) continue;
            preds.put(clazz, pred);
        }
        LinkedHashMap<String, Double> map = this.getSortedProbabilities(preds);
        int i = 0;
        for (String key : map.keySet()) {
            str.append("\tClass:" + key + " Prediction:" + map.get(key));
            str.append(System.getProperty("line.separator"));
            if (i > 5) break;
            ++i;
        }
        str.append(this.getTranslator().printRuleMatches(m));
        return str.toString();
    }

    protected boolean applyMarkup(Method m, String markupString) throws MarkupException {
        return this.getTranslator().applyMarkup(m, markupString);
    }

    private synchronized SparkModel getModel(String clazz, Language.LANGUAGE lang) throws IfaException {
        if (this.m_models == null) {
            this.m_models = new HashMap();
        }
        if (this.m_models.get(clazz) == null) {
            this.m_models.put(clazz, new HashMap());
        }
        if (this.m_models.get(clazz).get(lang) == null) {
            this.m_models.get(clazz).put(lang, (SparkModel)new SparkLogisiticRegressionModel(this.getClass().getSimpleName() + File.separator + lang.toVdbString() + File.separator + clazz + "_" + this.getMarkupData(clazz, lang).getActiveFeatures().getDirString(), this.getMarkupData(clazz, lang).getData(), 2));
        }
        return this.m_models.get(clazz).get(lang);
    }

    public synchronized MarkupTranslator getTranslator() {
        if (this.m_checker == null) {
            this.m_checker = this.initTranslator();
        }
        return this.m_checker;
    }

    protected abstract MarkupTranslator initTranslator();

    private MarkupData getMarkupData(String clazz, Language.LANGUAGE lang) throws MarkupException {
        if (this.m_data == null) {
            this.m_data = new HashMap();
        }
        if (!this.m_data.containsKey(clazz)) {
            this.m_data.put(clazz, new HashMap());
        }
        if (this.m_data.get(clazz).get(lang) == null) {
            this.m_data.get(clazz).put(lang, new MarkupData(this.getClass().getSimpleName(), clazz, this.m_checker, this.getRawMarkupData(lang), lang));
        }
        return this.m_data.get(clazz).get(lang);
    }

    private File getClassFile(Language.LANGUAGE lang) {
        if (this.m_class_file.get(lang) == null) {
            this.m_class_file.put(lang, new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "classes", this.getClass().getSimpleName() + "_" + lang.toVdbString() + ".classification"));
        }
        return this.m_class_file.get(lang);
    }

    private Set<String> getClasses(Language.LANGUAGE lang) throws MarkupException {
        block14: {
            block15: {
                if (this.m_classes == null) {
                    this.m_classes = new HashMap();
                }
                if (this.m_classes.get(lang) != null) break block14;
                if (this.getClassFile(lang).exists()) break block15;
                this.getClassFile(lang).getParentFile().mkdirs();
                for (Method method : this.getRawMarkupData(lang).getTrainMethods()) {
                    if (!this.m_classes.containsKey(lang)) {
                        this.m_classes.put(lang, new HashMap());
                    }
                    this.m_classes.get(lang).put(this.getTranslator().getMarkupString(method), 1);
                }
                PrintWriter w = null;
                try {
                    w = new PrintWriter(this.getClassFile(lang));
                    for (String key : this.m_classes.get(lang).keySet()) {
                        w.write(key);
                        w.write(System.getProperty("line.separator"));
                    }
                    w.flush();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        throw new MarkupException(fileNotFoundException);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(w);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)w);
                break block14;
            }
            Scanner scan = null;
            try {
                scan = new Scanner(this.getClassFile(lang));
                while (scan.hasNextLine()) {
                    String string = scan.nextLine();
                    if (!this.m_classes.containsKey(lang)) {
                        this.m_classes.put(lang, new HashMap());
                    }
                    this.m_classes.get(lang).put(string, 0);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    throw new MarkupException(fileNotFoundException);
                }
                catch (Throwable throwable) {
                    IOUtil.close(scan);
                    throw throwable;
                }
            }
            IOUtil.close((Closeable)scan);
        }
        return this.m_classes.get(lang).keySet();
    }

    public synchronized ArrayList<Method> getTestMethods(Language.LANGUAGE lang) throws MarkupException {
        return this.getRawMarkupData(lang).getTestMethods();
    }

    public boolean isSuperSet(String testMarkupString, String predictedMarkupString) {
        return false;
    }

    protected LinkedHashMap<String, Double> getSortedProbabilities(HashMap<String, Double> map) throws IfaException {
        LinkedList<Map.Entry<String, Double>> list = new LinkedList<Map.Entry<String, Double>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                return Double.compare(o2.getValue(), o1.getValue());
            }
        });
        LinkedHashMap<String, Double> sortedMap = new LinkedHashMap<String, Double>();
        for (Map.Entry entry : list) {
            if ((Double)entry.getValue() == 0.0) continue;
            sortedMap.put((String)entry.getKey(), (Double)entry.getValue());
        }
        return sortedMap;
    }
}

