/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.translator;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;
import com.ibm.appscan.vdb.rule.method.MethodSignatureRule;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class TaintTranslator
extends MarkupTranslator {
    @Override
    public boolean isValidClassForMethod(String markupString, Method m) throws MarkupException {
        ArrayList<Taint> taints = this.getTaintsFromString(markupString);
        for (Taint t : taints) {
            try {
                if (t.isValidForMethod(m)) continue;
                return false;
            }
            catch (BadMarkupException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getMarkupString(Method m) throws MarkupException {
        if (m.getTaints().size() == 0) {
            return "0";
        }
        StringBuffer taint = new StringBuffer();
        ArrayList<String> taints = new ArrayList<String>();
        HashMap<String, Taint> ts = new HashMap<String, Taint>();
        for (Taint taint2 : m.getTaints()) {
            ts.put(taint2.toString(m), taint2);
        }
        for (Taint taint3 : ts.values()) {
            taints.add(this.getTaintString(taint3, m));
        }
        Collections.sort(taints);
        for (String string : taints) {
            taint.append(string);
            taint.append(";");
        }
        if (taint.length() > 0) {
            taint.deleteCharAt(taint.length() - 1);
        }
        return taint.toString();
    }

    @Override
    public boolean hasMarkup(Method m) {
        return m.getTaints().size() > 0;
    }

    @Override
    public boolean applyMarkup(Method m, String markupString) throws MarkupException {
        Iterator<Taint> iterator = this.getTaintsFromString(markupString).iterator();
        if (iterator.hasNext()) {
            Taint t = iterator.next();
            try {
                m.addTaint(t.getSourceParam().toString(m), t.getDstParam().toString(m), t.isReturn());
            }
            catch (BadMarkupException e) {
                throw new MarkupException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean useOnlyMarkedUpMethods() {
        return true;
    }

    @Override
    protected String getMarkupType() {
        return "taint";
    }

    @Override
    public String convertRuleToMarkup(Method m) throws MarkupException {
        StringBuffer ret = new StringBuffer();
        HashMap<String, Taint> taints = new HashMap<String, Taint>();
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            try {
                Taint t = new Taint(r.getTaintRule().getSourceParameter(), r.getTaintRule().getDestinationParameter(), r.getTaintRule().isReturn());
                if (t.isNotSusceptibleToTaint()) {
                    return "dnp";
                }
                if (taints.containsKey(t.toString(m))) continue;
                taints.put(t.toString(m), t);
            }
            catch (BadMarkupException e) {
                throw new MarkupException(e);
            }
        }
        for (Taint t : taints.values()) {
            ret.append(this.getTaintString(t, m));
            ret.append(";");
        }
        if (ret.length() > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    @Override
    protected String getAntiMatch() {
        return null;
    }

    private String getTaintString(Taint t, Method m) {
        StringBuffer taint = new StringBuffer();
        if (t.isNotSusceptibleToTaint()) {
            taint.append("dnp");
        } else {
            String src = t.getSourceParam().toString(m);
            if (src.length() == 0) {
                src = "none";
            }
            src = src.replaceAll("-", "=");
            src = src.replaceAll(",", "_");
            String dst = t.getDstParam().toString(m);
            if (dst.length() == 0) {
                dst = "none";
            }
            dst = dst.replaceAll("-", "=");
            dst = dst.replaceAll(",", "_");
            taint.append(src);
            taint.append("-");
            taint.append(dst);
            taint.append("-");
            if (t.isReturn()) {
                taint.append("1");
            } else {
                taint.append("0");
            }
        }
        return taint.toString();
    }

    private ArrayList<Taint> getTaintsFromString(String markupString) throws MarkupException {
        ArrayList<Taint> ret = new ArrayList<Taint>();
        if (markupString.contains(";")) {
            for (String t : markupString.split(";")) {
                ret.add(this.getTaintFromString(t));
            }
        } else {
            ret.add(this.getTaintFromString(markupString));
        }
        return ret;
    }

    private Taint getTaintFromString(String t) throws MarkupException {
        String ret;
        String dst;
        String src;
        if (t.contains("-")) {
            src = t.split("-")[0];
            dst = t.split("-")[1];
            ret = t.split("-")[2];
            src = src.replaceAll("=", "-");
            src = src.replaceAll("_", ",");
            dst = dst.replaceAll("=", "-");
            dst = dst.replaceAll("_", ",");
            dst = dst.replaceAll("var,args", "var_args");
        } else {
            src = "none";
            dst = "none";
            ret = "0";
        }
        try {
            return new Taint(src, dst, ret.equals("1"));
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void initRules() throws MarkupException, BadRuleException {
        Rule r;
        for (VDBEnums.RULE_OPERATOR op : VDBEnums.RULE_OPERATOR.values()) {
            r = new Rule();
            r.setRuleName("method name " + op.getSimpleName() + " - dnp rule");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            File f = new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "rules" + File.separator, "method_" + op.getSimpleName() + "_dnp.rule");
            if (!f.exists()) continue;
            r.setRuleName("dnp_" + op.getSimpleName() + " - " + this.getMarkupType());
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String line = br.readLine();
                BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
                boolean add = false;
                while (line != null) {
                    if (line != null && line.length() > 0 && !line.startsWith("#")) {
                        add = true;
                        Rule r1 = g.createRule();
                        MethodSignatureRule sr = r1.getMethodRule().getSignatureRule();
                        sr.setRuleOperator(op);
                        sr.setRuleValue(line);
                    }
                    line = br.readLine();
                }
                if (add) {
                    this.getRules().add(r);
                }
            }
            catch (FileNotFoundException e) {
                try {
                    throw new MarkupException(e);
                    catch (IOException e2) {
                        throw new MarkupException(e2);
                    }
                    catch (BadRuleException e3) {
                        throw new MarkupException(e3);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(br);
                    throw throwable;
                }
            }
            IOUtil.close((Closeable)br);
        }
        try {
            r = new Rule();
            r.setRuleName("boolean only args - void return - all");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("Constructor");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("encrypt, decrypt");
            BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            Rule r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("encrypt");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("decrypt");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("protect");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("unprotect");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("encode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("decode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("encryptValue");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("decryptValue");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("encryptKey");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("decryptKey");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("DecodeBytes");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("EncodeBytes");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("encryptmessage");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("decryptmessage");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("htmlencode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("htmldecode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("urldecode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("urlencode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("uriencode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("uridecode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("xmlencode");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getSignatureRule().setRuleValue("xmldecode");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("op_ dnp");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("op_");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("hashcode dnp");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getSignatureRule().setRuleValue("GetHashCode");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("Add");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleValue("add");
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleValue("addAll");
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("String append");
            r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
            r.getMethodRule().getClassRule().setRuleValue("string");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleValue("append");
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleValue("concat");
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getTaintRule().setDestinationParameter("all");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("number only args - void return - all");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - string return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("string");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - number return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("log APIs - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("log");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - boolean return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - void return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("setter - more than 1 non-boolean, non-number arg - all");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r1 = g.createRule();
            r1.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getReturnRule().setRuleValue("void");
            Rule r2 = g.createRule();
            r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r2.getMethodRule().getArgumentRule().setRuleValue("number");
            Rule r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r3.getMethodRule().getArgumentRule().setRuleValue("boolean");
            Rule r4 = g.createRule();
            r4.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
            r4.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("setter - number args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("setter - boolean args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("Invoke");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getSignatureRule().setRuleValue("Invoke");
            r.getTaintRule().setDestinationParameter("all");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("getter 0 args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_GETTER);
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("getter - 1 non-boolean, non-number arg - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("get");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r1 = g.createRule();
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r1.getMethodRule().getReturnRule().setRuleValue("void");
            r1 = g.createRule();
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r1.getMethodRule().getReturnRule().setRuleValue("number");
            r1 = g.createRule();
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r1.getMethodRule().getReturnRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("-init constructor with non-boolean\non-number arguments - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r2.getMethodRule().getSignatureRule().setRuleValue("-init");
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r2.getMethodRule().getReturnRule().setRuleValue("id");
            r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r3.getMethodRule().getArgumentRule().setRuleValue("number");
            r4 = g.createRule();
            r4.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r4.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("-init constructor with boolean\number arguments - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r2.getMethodRule().getSignatureRule().setRuleValue("-init");
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r2.getMethodRule().getReturnRule().setRuleValue("id");
            r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r3.getMethodRule().getArgumentRule().setRuleValue("number");
            r4 = g.createRule();
            r4.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r4.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("ForKey: - non-void return - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r2.getMethodRule().getReturnRule().setRuleValue("number");
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r3.getMethodRule().getSignatureRule().setRuleValue("ForKey:");
            r3.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r3.getMethodRule().getReturnRule().setRuleValue("void");
            r4 = g.createRule();
            r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r4.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("object arg - void return - objectivec");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("object");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(1);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("1");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("object return - 0 args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("object");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("handle arg - void return - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("handle");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(1);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("1");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("handle return - 0 args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("handle");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("static 0 args - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r2 = g.createRule();
            r2.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_STATIC);
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r3.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("static 1 arg - void, boolean or number return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(1);
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r2 = g.createRule();
            r2.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_STATIC);
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r3.getMethodRule().getSignatureRule().setRuleValue("+");
            BaseLogicGate g2 = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r4 = g2.createRule();
            r4.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r4.getMethodRule().getReturnRule().setRuleValue("boolean");
            Rule r5 = g2.createRule();
            r5.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r5.getMethodRule().getReturnRule().setRuleValue("void");
            Rule r6 = g2.createRule();
            r6.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r6.getMethodRule().getReturnRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("no args handle return - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("handle");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("ForKey: number return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("ForKey:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("default to return - all");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("fromJson");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("toJson");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("deserialize");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("ForKey: - boolean return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("boolean");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("ForKey:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("number args - number return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("number args - number return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("scala apply and applyorelse");
            r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getPackageRule().setRuleValue("scala");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("apply");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("andThen");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("compose");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r1 = g.createRule();
            r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getClassRule().setRuleValue("Function");
            r1 = g.createRule();
            r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getClassRule().setRuleValue("PartialFunction");
            r.getTaintRule().setDestinationParameter("all");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("numberOfRowsInSection: - objective c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("numberOfRowsInSection:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("heightForRowAtIndexPath: - objective c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("heightForRowAtIndexPath:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("cellForRowAtIndexPath: - objective c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("cellForRowAtIndexPath:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("CompareTo - dnp");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("CompareTo");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("CompareTo - dnp");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("compareTo");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("Static For - id return - objectivec");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r2.getMethodRule().getReturnRule().setRuleValue("id");
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
            r3.getMethodRule().getSignatureRule().setRuleValue("For");
            r4 = g.createRule();
            r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r4.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("-stringByA method name - objetive c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("-stringByA");
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("encode method name - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("encode");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("create method name - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("create");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("dencode method name - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("dencode");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("log NSString*;... - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r3.getMethodRule().getArgumentRule().setArgPos(0);
            r3.getMethodRule().getArgumentRule().setRuleValue("NSString*");
            r3.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r3.getMethodRule().getReturnRule().setRuleValue("void");
            r4 = g.createRule();
            r4.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r4.getMethodRule().getArgumentRule().setRuleValue("...");
            r4.getMethodRule().getArgumentRule().setArgPos(1);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            for (int i = 0; i < 5; ++i) {
                r = new Rule();
                r.setRuleName("Nserror_" + i + " - objective c");
                r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
                r.getMethodRule().getArgumentRule().setRuleValue("NSError**");
                r.getMethodRule().getArgumentRule().setArgPos(i);
                r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
                r.getMethodRule().getSignatureRule().setRuleValue("+");
                r.getTaintRule().setDestinationParameter(Integer.toString(i + 1));
                r.getTaintRule().setSourceParameter("this");
                r.getTaintRule().setReturn(false);
                this.getRules().add(r);
            }
            return;
        }
        catch (BadRuleException e) {
            throw new MarkupException(e);
        }
    }

    @Override
    protected void initAntiRules() throws MarkupException, BadRuleException {
    }

    @Override
    public String getDefaultValue() {
        return "dnp";
    }
}

