/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg.util;

import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.loader.csharp.CSharpInterface;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ScopeUtil {
    public static AnalysisScope getJavaScope(String javaScopePath) throws IOException {
        return AnalysisScopeReader.readJavaScope((String)javaScopePath, (File)TaintFileProvider.getFile((String)"dat/exclusions.java.dat"), (ClassLoader)AbstractAnalysisEngine.class.getClassLoader());
    }

    public static CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> getDotNetAnalysisScope(String scopeFileName) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(scopeFileName));
        String f = "";
        if (!in.ready()) {
            in.close();
            throw new IOException();
        }
        while ((f = in.readLine()) != null) {
            if (f.trim().length() == 0) continue;
            files.add(f);
        }
        in.close();
        SetOfClasses exclusions = new SetOfClasses(){
            private final Collection<String> exclusionsList = this.parseExclusionsFile("dat/exclusions.dotnet.dat");
            private static final long serialVersionUID = 1L;

            private Collection<String> parseExclusionsFile(String exclusionsFile) {
                HashSet result = HashSetFactory.make();
                try {
                    FileProvider fp = new FileProvider();
                    File f = fp.getFile(exclusionsFile);
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    String line = "";
                    if (!in.ready()) {
                        in.close();
                        throw new IOException();
                    }
                    while ((line = in.readLine()) != null) {
                        if (line.trim().length() == 0) continue;
                        result.add(line);
                    }
                    in.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return result;
            }

            public boolean contains(String klassName) {
                for (String exclusion : this.exclusionsList) {
                    if (!klassName.startsWith(exclusion)) continue;
                    return true;
                }
                return false;
            }

            public void add(String klass) {
                Assertions.UNREACHABLE();
            }
        };
        Iterator itr = files.iterator();
        String sysLine = (String)itr.next();
        String sysPath = sysLine.substring(sysLine.indexOf(44) + 1);
        File sysAssembly = new File(sysPath);
        HashSet appAssemblies = HashSetFactory.make();
        HashSet libAssemblies = HashSetFactory.make();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            int indexOfFirstComma = line.indexOf(44);
            String appOrLib = line.substring(0, indexOfFirstComma);
            String path = line.substring(indexOfFirstComma + 1);
            if (appOrLib.equals("app")) {
                appAssemblies.add(new File(path));
                continue;
            }
            assert (appOrLib.equals("lib"));
            libAssemblies.add(new File(path));
        }
        CSharpInterface i = new CSharpInterface();
        i.clearCaches();
        CLRAnalysisScope scope = new CLRAnalysisScope(sysAssembly, (Set)libAssemblies, (Set)appAssemblies, exclusions, (LowLevelInterface)i);
        return scope;
    }

    public static String getWorkspaceDir() {
        String workspaceDir = System.getProperty("WorkSpace");
        assert (workspaceDir != null) : "should set WorkSpace property";
        return workspaceDir;
    }
}

