/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.core.FixedOrderedEntrypointsCollector;
import com.ibm.wala.andromeda.core.IEntrypointsCollector;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.TaintAnalyzer;
import com.ibm.wala.andromeda.core.TaintGraphUtils;
import com.ibm.wala.andromeda.harness.JspServices;
import com.ibm.wala.andromeda.harness.MergedRule;
import com.ibm.wala.andromeda.harness.TaintResult;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServicesForFastanalysis;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.modular.FlowAnalyzer;
import com.ibm.wala.andromeda.progress.JavaProcessLauncher;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.andromeda.rules.management.Issue;
import com.ibm.wala.andromeda.rules.management.RuleManager;
import com.ibm.wala.andromeda.util.GraphOutput;
import com.ibm.wala.andromeda.util.InvalidFlowException;
import com.ibm.wala.andromeda.util.ScopePartitioning;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.andromeda.util.TaintRunnerStats;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TaintAnalysis {
    private static final int ONE_SECOND = 1000;
    private final int CHUNK_SIZE = 5000000;
    private static final boolean DEBUG = false;
    private static final boolean PARALLELISM_ENABLED = false;
    private static final int NUMBER_OF_JOBS_PER_PROCESSOR = 10;
    private static final boolean PERSIST_RESULTS = true;
    private static final boolean USE_LCPS = true;
    protected final IClassHierarchy cha;
    protected final ILanguageSpecificServicesForFastanalysis langServices;
    protected final IEntrypointsCollector entrypointsCollector;
    protected final AnalysisCache analysisCache = new AnalysisCache();
    protected final Set<TaintRule> analysisRules;
    private boolean isStandalone = false;
    private static boolean PROPAGATION_GRAPH_DEBUG = false;
    private static int graphNum = 0;

    private TaintAnalysis(IClassHierarchy cha, Set<TaintRule> analysisRules, IEntrypointsCollector entrypointsCollector, ILanguageSpecificServicesForFastanalysis langServices, boolean isStandalone) throws ClassHierarchyException, InvalidClassFileException, IllegalArgumentException, CallGraphBuilderCancelException {
        this.cha = cha;
        this.analysisRules = analysisRules;
        this.langServices = langServices;
        this.entrypointsCollector = entrypointsCollector;
        this.isStandalone = isStandalone;
    }

    public TaintAnalysis(IClassHierarchy cha, Set<TaintRule> analysisRules, IEntrypointsCollector entrypointsCollector, ILanguageSpecificServicesForFastanalysis langServices) throws ClassHierarchyException, InvalidClassFileException, IllegalArgumentException, CallGraphBuilderCancelException {
        this(cha, analysisRules, entrypointsCollector, langServices, false);
    }

    private Set<MergedRule> mergeRules(Set<TaintRule> analysisRules, TICallGraph cg) {
        HashSet result = HashSetFactory.make();
        HashMap partition = HashMapFactory.make();
        for (TaintRule tr : analysisRules) {
            IMethod m;
            HashSet sources = HashSetFactory.make();
            HashSet sanitizers = HashSetFactory.make();
            HashSet sinks = HashSetFactory.make();
            Pair key = Pair.make((Object)sources, (Object)sanitizers);
            for (MethodReference sinkRef : tr.getSinkRefs()) {
                m = this.cha.resolveMethod(sinkRef);
                if (cg.scanForCalls((Collection<IMethod>)Collections.singleton(m)).size() <= 0) continue;
                sinks.add(m);
            }
            if (sinks.size() == 0) continue;
            for (MethodReference sourceRef : tr.getSourceRefs()) {
                m = this.cha.resolveMethod(sourceRef);
                if (cg.scanForCalls((Collection<IMethod>)Collections.singleton(m)).size() <= 0) continue;
                sources.add(m);
            }
            if (sources.size() == 0) continue;
            for (MethodReference sanitizerRef : tr.getSanitizerRefs()) {
                m = this.cha.resolveMethod(sanitizerRef);
                if (cg.scanForCalls((Collection<IMethod>)Collections.singleton(m)).size() <= 0) continue;
                sanitizers.add(m);
            }
            Set S = MapUtil.findOrCreateSet((Map)partition, (Object)key);
            S.add(tr);
        }
        for (Set S : partition.values()) {
            MergedRule mr = new MergedRule(S);
            result.add(mr);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, InvalidClassFileException, Decoder.InvalidBytecodeException {
        String entrypointsPath = args[0];
        String scopePath = args[1];
        String rulesPath = args[2];
        boolean useOnlyDefaultRules = Boolean.parseBoolean(args[3]);
        AnalysisScope scope = AnalysisScopeReader.readJavaScope((String)scopePath, (File)TaintFileProvider.getFile((String)"dat/exclusions.java.dat"), (ClassLoader)AbstractAnalysisEngine.class.getClassLoader());
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope);
        FixedOrderedEntrypointsCollector fixedCollector = new FixedOrderedEntrypointsCollector(TaintAnalysis.parseMethods((IClassHierarchy)cha, entrypointsPath));
        RuleManager rm = RuleManager.getRuleManager(rulesPath);
        Set<IRawTaintRule> declarativeRules = rm.getRules();
        if (useOnlyDefaultRules) {
            declarativeRules = TaintAnalysis.getDefaultRules(rm, declarativeRules);
        }
        HashSet analysisRules = HashSetFactory.make((int)declarativeRules.size());
        for (IRawTaintRule rule : declarativeRules) {
            TaintRule tr = new TaintRule((IClassHierarchy)cha, rule);
            analysisRules.add(tr);
        }
        TaintAnalysis ta = new TaintAnalysis((IClassHierarchy)cha, analysisRules, fixedCollector, JavaServicesForFastanalysis.JAVA, true);
        ta.run();
    }

    private static Set<IRawTaintRule> getDefaultRules(RuleManager ruleManager, Set<IRawTaintRule> allRules) {
        HashSet result = HashSetFactory.make();
        for (IRawTaintRule rule : allRules) {
            Issue issue = ruleManager.getIssue(rule.getIssueID());
            int exploitability = rule.getExploitabilityLevel();
            int severity = issue.getSeverity();
            if (exploitability != 0 || severity >= 4) continue;
            result.add(rule);
        }
        return result;
    }

    private static List<IMethod> parseMethods(IClassHierarchy cha, String entrypointsPath) throws IOException {
        String line;
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        BufferedReader in = new BufferedReader(new FileReader(entrypointsPath));
        while ((line = in.readLine()) != null) {
            result.add(SignatureUtil.sig2Method((String)line, (IClassHierarchy)cha, (Language)Language.JAVA));
        }
        return result;
    }

    public Pair<Set<ITaintResult>, TaintRunnerStats> run() throws InvalidClassFileException, ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, Decoder.InvalidBytecodeException {
        Collection<IMethod> entrypoints = this.entrypointsCollector.collectEntrypoints(this.cha);
        OfflineSpecification offlineSpec = OfflineSpecification.loadDefaultSpec(this.cha, this.langServices, this.langServices);
        if (!this.isStandalone) {
            // empty if block
        }
        return this.run(entrypoints, offlineSpec);
    }

    private Set<ITaintResult> partitionAndSpawnJobs(Collection<IMethod> entrypoints, OfflineSpecification offlineSpec) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        HashSet result = HashSetFactory.make();
        Set<ITaintResult> synchronizedResult = Collections.synchronizedSet(result);
        Collection<AnalysisJob> jobs = this.createJobs(entrypoints, offlineSpec, synchronizedResult);
        if (jobs.size() == 1) {
            jobs.iterator().next().execute();
        } else {
            HashSet remainingJobs = HashSetFactory.make(jobs);
            HashSet runningJobs = HashSetFactory.make();
            while (remainingJobs.size() > 0 || runningJobs.size() > 0) {
                HashSet toRemove = HashSetFactory.make();
                for (AnalysisJob runningJob : runningJobs) {
                    if (!runningJob.hasCompleted()) continue;
                    toRemove.add(runningJob);
                }
                runningJobs.removeAll(toRemove);
                while (runningJobs.size() < Runtime.getRuntime().availableProcessors() && remainingJobs.size() > 0) {
                    AnalysisJob nextJob = (AnalysisJob)remainingJobs.iterator().next();
                    remainingJobs.remove(nextJob);
                    runningJobs.add(nextJob);
                    nextJob.start();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return synchronizedResult;
    }

    private Pair<Set<ITaintResult>, TaintRunnerStats> run(Collection<IMethod> entrypoints, OfflineSpecification offlineSpec) throws ClassHierarchyException, CallGraphBuilderCancelException, InvalidClassFileException {
        HashSet result = HashSetFactory.make();
        Collection<IMethod> remainingEntrypoints = entrypoints;
        int numChunks = (int)Math.ceil((double)entrypoints.size() * 1.0 / 5000000.0);
        assert (numChunks == 1);
        int cgSize = 0;
        for (int i = 0; i < numChunks; ++i) {
            EntrypointSet s = this.getNextEntrypointSet(remainingEntrypoints, numChunks - i, this.entrypointsCollector.isOrdered());
            TICallGraph cg = this.buildCallGraph(offlineSpec, s);
            cgSize = cg.getNumberOfNodes();
            for (CGNode n : cg) {
                remainingEntrypoints.remove(n.getMethod());
            }
            result.addAll(this.analyzeCG(cg, offlineSpec));
        }
        this.persistToDisk(result);
        return Pair.make((Object)result, (Object)new TaintRunnerStats(cgSize));
    }

    private void persistToDisk(Set<ITaintResult> result) {
        try {
            File resultsFile = new File("c:/temp/results-" + this.hashCode() + ".txt");
            FileWriter fw = new FileWriter(resultsFile);
            for (ITaintResult R : result) {
                fw.write(R.toString());
                fw.write("\r\n");
            }
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Collection<AnalysisJob> createJobs(Collection<IMethod> entrypoints, OfflineSpecification offlineSpec, Set<ITaintResult> resultsContainer) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        assert (false) : "ERROR: cannot break analysis into jobs when parallelism is disabled!";
        Collection partition = ScopePartitioning.partition((IClassHierarchy)this.cha);
        HashMap classes2entrypoints = new HashMap();
        for (Set S : partition) {
            LinkedList<IMethod> orderedEntrypoints = new LinkedList<IMethod>();
            for (IMethod entrypoint : entrypoints) {
                if (!S.contains(entrypoint.getDeclaringClass())) continue;
                orderedEntrypoints.add(entrypoint);
            }
            classes2entrypoints.put(S, orderedEntrypoints);
        }
        int numBuckets = Runtime.getRuntime().availableProcessors() * 10;
        HashSet jobs = HashSetFactory.make((int)numBuckets);
        for (int i = 0; i < numBuckets; ++i) {
            AnalysisJob job = new AnalysisJob();
            jobs.add(job);
        }
        for (List entrypointList : classes2entrypoints.values()) {
            Iterator iter = jobs.iterator();
            AnalysisJob leastBurdened = (AnalysisJob)iter.next();
            while (iter.hasNext()) {
                AnalysisJob candidate = (AnalysisJob)iter.next();
                if (candidate.getNumberOfEntrypoints() >= leastBurdened.getNumberOfEntrypoints()) continue;
                leastBurdened = candidate;
            }
            leastBurdened.addEntrypoints(entrypointList);
        }
        HashSet result = HashSetFactory.make();
        for (AnalysisJob job : jobs) {
            if (job.getNumberOfEntrypoints() <= 0) continue;
            result.add(job);
        }
        return result;
    }

    private EntrypointSet getNextEntrypointSet(Collection<IMethod> entrypoints, int numChunks, boolean isOrdered) {
        Collection<IMethod> sorted = isOrdered ? entrypoints : this.sort(entrypoints);
        Iterator<IMethod> iter = sorted.iterator();
        HashSet methods = HashSetFactory.make();
        for (int numEntrypoints = entrypoints.size() / numChunks; iter.hasNext() && numEntrypoints > 0; --numEntrypoints) {
            IMethod next = iter.next();
            methods.add(next);
        }
        return new EntrypointSet(methods);
    }

    private SortedSet<IMethod> sort(Collection<IMethod> entrypoints) {
        TreeSet<IMethod> s = new TreeSet<IMethod>(new MethodSorter());
        s.addAll(entrypoints);
        return s;
    }

    protected Set<ITaintResult> analyzeCG(TICallGraph cg, OfflineSpecification spec) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, InvalidClassFileException {
        HashSet result = HashSetFactory.make();
        DebugOutput.println((boolean)false, this.analysisRules);
        Set<MergedRule> mergedRules = this.mergeRules(this.analysisRules, cg);
        Map<FieldReference, Set<IMethod>> allStaticGetFields = this.accountForStaticGetFields(cg, spec);
        for (MergedRule mergedRule : mergedRules) {
            TaintAnalyzer analyzer = new TaintAnalyzer(this.cha, mergedRule.getSourceRefs(), mergedRule.getSanitizerRefs(), mergedRule.getSinkRefs(), this.langServices, spec, cg, allStaticGetFields);
            RawAnalysisResult rawResult = analyzer.run();
            if (PROPAGATION_GRAPH_DEBUG) {
                if (graphNum == 0) {
                    GraphOutput.clearOutputDirectory();
                }
                GraphOutput.printRawGraph((String)("rawpropgraph-" + graphNum + ".txt"), rawResult.getPropagationGraph());
                GraphOutput.printGraphTXT((String)("propgraph-" + graphNum + ".txt"), rawResult.getPropagationGraph());
                ++graphNum;
            }
            try {
                result.addAll(TaintResult.toTaintResults(TaintGraphUtils.processWithLCPs(rawResult, mergedRule), JspServices.findOrCreate(cg.getClassHierarchy().getScope())));
            }
            catch (InvalidFlowException ife) {
                System.err.println("Invalid flow");
            }
        }
        return result;
    }

    private Map<FieldReference, Set<IMethod>> accountForStaticGetFields(TICallGraph cg, OfflineSpecification spec) {
        HashMap allStaticGetFields = HashMapFactory.make();
        for (CGNode n : cg) {
            IMethod m = n.getMethod();
            if (spec.hasSpecForMethod(m)) continue;
            Map<FieldReference, Set<IMethod>> temp = this.langServices.accountForStaticGetFields(n);
            for (Map.Entry<FieldReference, Set<IMethod>> e : temp.entrySet()) {
                MapUtil.findOrCreateSet((Map)allStaticGetFields, (Object)e.getKey()).addAll((Collection)e.getValue());
            }
        }
        return allStaticGetFields;
    }

    protected static OfflineSpecification loadOfflineSpecification(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fastLangServices) {
        String offlineSpecFile = langServices.getOfflineSpecificationFile();
        try {
            File f = TaintFileProvider.getFile((String)offlineSpecFile);
            File autoSummariesFile = new File(FlowAnalyzer.AUTO_SUMMARIES_FILE_NAME);
            return OfflineSpecification.load(f, autoSummariesFile, cha, langServices.getLanguage(), fastLangServices);
        }
        catch (IOException e) {
            System.err.println("Failed to load offline specification " + offlineSpecFile + ": " + e);
            return null;
        }
    }

    protected TICallGraph buildCallGraph(OfflineSpecification spec, IEntrypointLocator locator) {
        if (this.langServices.excludeSourcesAndSinksFromCG()) {
            for (TaintRule tr : this.analysisRules) {
                for (MethodReference mr : tr.getSourceRefs()) {
                    spec.addExclusion(this.cha.resolveMethod(mr));
                }
                for (MethodReference mr : tr.getSinkRefs()) {
                    spec.addExclusion(this.cha.resolveMethod(mr));
                }
            }
        }
        return new TICallGraph(this.cha, locator, spec, this.langServices, this.analysisCache, AccuracyLevel.getDefaultLevel(), new TICallGraph.VirtualResolutionOptions(5, 1, true, true, false));
    }

    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze() {
        try {
            Pair<Set<ITaintResult>, TaintRunnerStats> run = this.run();
            return run;
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (CallGraphBuilderCancelException e) {
            e.printStackTrace();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
        }
        catch (Decoder.InvalidBytecodeException e) {
            e.printStackTrace();
        }
        Set emptySet = Collections.emptySet();
        return Pair.make(emptySet, null);
    }

    private static class EntrypointSet
    implements IEntrypointLocator {
        private final Set<IMethod> entrypoints;

        EntrypointSet(Set<IMethod> entrypoints) {
            this.entrypoints = entrypoints;
        }

        @Override
        public Set<IMethod> locateEntrypoints(IClassHierarchy cha) {
            return Collections.unmodifiableSet(this.entrypoints);
        }
    }

    private static class MethodSorter
    implements Comparator<IMethod> {
        private MethodSorter() {
        }

        @Override
        public int compare(IMethod m1, IMethod m2) {
            String s2;
            String s1 = m1.getDeclaringClass().getName().toString();
            if (!s1.equals(s2 = m2.getDeclaringClass().getName().toString())) {
                return s1.compareTo(s2);
            }
            return m1.toString().compareTo(m2.toString());
        }
    }

    private class AnalysisJob
    extends Thread {
        private final List<IMethod> entrypoints = new LinkedList<IMethod>();
        private boolean hasCompleted = false;

        private AnalysisJob() {
        }

        @Override
        public void run() {
            this.execute();
        }

        public void addEntrypoints(List<IMethod> entrypoints) {
            this.entrypoints.addAll(entrypoints);
        }

        private void execute() {
            String entrypointsPath = null;
            String scopePath = null;
            try {
                entrypointsPath = this.exportEntrypointsToFile(this.entrypoints);
                scopePath = this.exportScopeToFile(TaintAnalysis.this.cha.getScope());
            }
            catch (IOException e) {
                Assertions.UNREACHABLE();
            }
            String rulesPath = "../com.ibm.wala.andromeda/dat/rules_java.xml";
            String programArgs = entrypointsPath + " " + scopePath + " " + rulesPath + " true";
            int memoryUseMB = 1024;
            JavaProcessLauncher launcher = JavaProcessLauncher.make(programArgs, TaintAnalysis.class.getName(), null, memoryUseMB);
            try {
                Process P = launcher.start();
                P.waitFor();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.hasCompleted = true;
        }

        private String exportScopeToFile(AnalysisScope scope) throws IOException {
            File scopeFile = File.createTempFile("scope.", ".tmp");
            FileWriter fw = new FileWriter(scopeFile);
            for (Module m : scope.getModules(ClassLoaderReference.Primordial)) {
                if (m instanceof BinaryDirectoryTreeModule) {
                    fw.write("Primordial,Java,binaryDir," + ((BinaryDirectoryTreeModule)m).getPath());
                } else {
                    assert (m instanceof JarFileModule);
                    fw.write("Primordial,Java,jarFile," + ((JarFileModule)m).getAbsolutePath());
                }
                fw.write("\r\n");
            }
            for (Module m : scope.getModules(ClassLoaderReference.Extension)) {
                if (m instanceof BinaryDirectoryTreeModule) {
                    fw.write("Extension,Java,binaryDir," + ((BinaryDirectoryTreeModule)m).getPath());
                } else {
                    assert (m instanceof JarFileModule);
                    fw.write("Extension,Java,jarFile," + ((JarFileModule)m).getAbsolutePath());
                }
                fw.write("\r\n");
            }
            for (Module m : scope.getModules(ClassLoaderReference.Application)) {
                if (m instanceof BinaryDirectoryTreeModule) {
                    fw.write("Application,Java,binaryDir," + ((BinaryDirectoryTreeModule)m).getPath());
                } else {
                    assert (m instanceof JarFileModule);
                    fw.write("Application,Java,jarFile," + ((JarFileModule)m).getAbsolutePath());
                }
                fw.write("\r\n");
            }
            fw.close();
            return scopeFile.getAbsolutePath();
        }

        private String exportEntrypointsToFile(List<IMethod> entrypoints) throws IOException {
            File entrypointsFile = File.createTempFile("entrypoins.", ".tmp");
            FileWriter fw = new FileWriter(entrypointsFile);
            for (IMethod m : entrypoints) {
                fw.write(m.getSignature());
                fw.write("\r\n");
            }
            fw.close();
            return entrypointsFile.getAbsolutePath();
        }

        public int getNumberOfEntrypoints() {
            return this.entrypoints.size();
        }

        public boolean hasCompleted() {
            return this.hasCompleted;
        }
    }
}

