/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.BFSPathsFinder;
import com.ibm.wala.andromeda.core.BasicPropagationWitness;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.PartialPropagationWitness;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.TransitivePropagationWitness;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.harness.AbstractTaintRule;
import com.ibm.wala.andromeda.harness.MergedRule;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.util.ErrorLog;
import com.ibm.wala.andromeda.util.GraphView;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.graph.labeled.LabeledGraph;
import com.ibm.wala.util.graph.traverse.BFSIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaintGraphUtils {
    private static final boolean SHOW_DEBUG_WITNESS = false;

    public static Set<Variable> computeSlice(Graph<Variable> mapping, Collection<Variable> seeds) {
        BFSIterator iter = new BFSIterator(mapping, seeds.iterator());
        HashSet result = HashSetFactory.make();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static Collection<List<Variable>> solve(Graph<Variable> mapping, Collection<Variable> seeds) {
        Filter<Variable> filter = new Filter<Variable>(){

            public boolean accepts(Variable v) {
                return v instanceof ViolationVariable;
            }
        };
        Map<Variable, Set<List<Variable>>> results = BFSPathsFinder.findPathsFromMultipleSources(mapping, seeds, filter);
        HashSet retval = HashSetFactory.make();
        for (Set<List<Variable>> s : results.values()) {
            retval.addAll(s);
        }
        return retval;
    }

    private static int findLibraryCallPointAppEndpointIndex(List<Variable> path) {
        for (int index = path.size() - 1; index >= 0; --index) {
            IClass klass = path.get(index).getMethod().getDeclaringClass();
            if (!klass.getClassHierarchy().getScope().isApplicationLoader(klass.getClassLoader())) continue;
            return index;
        }
        Assertions.UNREACHABLE((String)"ERROR: expected at least one application milestone!");
        return -1;
    }

    public static Set<Variable> findBackwardsReachableSources(Graph<Variable> propagationGraph, Predicate<Variable> sourceFilter, Variable sinkVariable) {
        Graph invertedGraph = GraphInverter.invert(propagationGraph);
        BFSIterator iter = new BFSIterator(invertedGraph, (Object)sinkVariable);
        HashSet result = HashSetFactory.make();
        while (iter.hasNext()) {
            Variable next = (Variable)iter.next();
            if (!sourceFilter.test((Object)next)) continue;
            result.add(next);
        }
        return result;
    }

    public static Map<List<IPropagationWitness>, Set<TaintRule>> process(RawAnalysisResult rawResult, AbstractTaintRule rule) {
        Collection<TaintRule> taintRules = TaintGraphUtils.getRules(rule);
        HashMap result = HashMapFactory.make();
        Set<List<IPropagationWitness>> S = TaintGraphUtils.process(rawResult, taintRules);
        for (List<IPropagationWitness> propagationWitnessChain : S) {
            Set rules = MapUtil.findOrCreateSet((Map)result, propagationWitnessChain);
            rules.addAll(taintRules);
        }
        return result;
    }

    public static Map<List<IPropagationWitness>, Set<TaintRule>> processWithLCPs(RawAnalysisResult rawResult, AbstractTaintRule rule) {
        Collection<TaintRule> taintRules = TaintGraphUtils.getRules(rule);
        HashMap result = HashMapFactory.make();
        Set<List<IPropagationWitness>> S = TaintGraphUtils.processWithLCPs(rawResult, taintRules);
        for (List<IPropagationWitness> propagationWitnessChain : S) {
            Set rules = MapUtil.findOrCreateSet((Map)result, propagationWitnessChain);
            rules.addAll(taintRules);
        }
        return result;
    }

    private static Collection<TaintRule> getRules(AbstractTaintRule rule) {
        Collection<TaintRule> taintRules;
        if (rule instanceof MergedRule) {
            taintRules = ((MergedRule)rule).getMergedRules();
        } else if (rule instanceof TaintRule) {
            taintRules = Collections.singleton((TaintRule)rule);
        } else {
            Assertions.UNREACHABLE((String)"ERROR: expected an instance of either 'MergedRule' or 'TaintRule'.");
            taintRules = null;
        }
        return taintRules;
    }

    public static Set<List<IPropagationWitness>> processWithLCPs(RawAnalysisResult rawResult, Collection<TaintRule> taintRules, Collection<Variable> sources, Collection<Variable> sinks) {
        Set<List<Variable>> paths = TaintGraphUtils.solveWithLCPs(rawResult.getPropagationGraph(), sources, sinks, taintRules);
        return TaintGraphUtils.processPaths(rawResult, taintRules, paths, true);
    }

    public static Set<List<IPropagationWitness>> processWithLCPs(RawAnalysisResult rawResult, Collection<TaintRule> taintRules) {
        Set<Variable> sources = rawResult.getPropagationSeeds();
        Collection<List<Variable>> paths = TaintGraphUtils.solveWithLCPs(rawResult.getPropagationGraph(), sources, taintRules);
        return TaintGraphUtils.processPaths(rawResult, taintRules, paths, true);
    }

    public static Set<List<IPropagationWitness>> process(RawAnalysisResult rawResult, Collection<TaintRule> taintRules) {
        Set<Variable> sources = rawResult.getPropagationSeeds();
        Collection<List<Variable>> paths = TaintGraphUtils.solve(rawResult.getPropagationGraph(), sources);
        return TaintGraphUtils.processPaths(rawResult, taintRules, paths, false);
    }

    private static Set<List<IPropagationWitness>> processPaths(RawAnalysisResult rawResult, Collection<TaintRule> taintRules, Collection<List<Variable>> paths, boolean withLCPs) {
        HashSet result = HashSetFactory.make();
        for (List<Variable> path : paths) {
            Set<List<IPropagationWitness>> propagationWitnessChains = TaintGraphUtils.toPropagationWitnessChains(path, rawResult.getPropagationGraph(), withLCPs);
            result.addAll(propagationWitnessChains);
        }
        return result;
    }

    public static Set<List<IPropagationWitness>> toPropagationWitnessChains(List<Variable> path, AbstractNumberedLabeledGraph<Variable, IPropagationWitness> mapping, boolean withLCPs) {
        assert (path != null && path.size() >= 2);
        int lcpAppEndpointIndex = withLCPs ? TaintGraphUtils.findLibraryCallPointAppEndpointIndex(path) : -1;
        HashSet result = HashSetFactory.make();
        ArrayList<IPropagationWitness> prefix = new ArrayList<IPropagationWitness>();
        ArrayList suffix = new ArrayList();
        ArrayList<IPropagationWitness> currentList = prefix;
        Variable sourceVar = path.get(0);
        IMethod sourceMethod = sourceVar.getMethod();
        Context sourceContext = sourceVar.getContext();
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(sourceMethod, sourceContext);
        SSAInstruction sourceDef = du.getDef(sourceVar.getVarID());
        if (sourceDef == null) {
            throw new NullPointerException("The sourceDef should not be null, but it is");
        }
        prefix.add(new BasicPropagationWitness(sourceMethod, sourceContext, sourceDef));
        for (int index = 0; index < path.size() - 1; ++index) {
            IPropagationWitness w;
            Object vNext;
            if (index == lcpAppEndpointIndex) {
                currentList = suffix;
                continue;
            }
            Variable v = path.get(index);
            Set propagationWitnesses = mapping.getEdgeLabels((Object)v, vNext = path.get(index + 1));
            if (propagationWitnesses.size() >= 1) {
                w = null;
                for (IPropagationWitness witness : propagationWitnesses) {
                    if (witness instanceof TransitivePropagationWitness) continue;
                    w = witness;
                    break;
                }
                if (w == null) {
                    w = (IPropagationWitness)propagationWitnesses.iterator().next();
                    ErrorLog.i().register("WARNING: failed to find non-transitive witness for: " + v + " ---> " + vNext + ".", ErrorLog.Kind.WARNING);
                }
            } else {
                w = new PartialPropagationWitness(v.getMethod(), v.getContext());
                ErrorLog.i().register("WARNING: abnormal propagation. Failed to find witness for: " + v + " ---> " + vNext + ".", ErrorLog.Kind.ERROR);
            }
            currentList.add(w);
        }
        if (withLCPs) {
            assert (lcpAppEndpointIndex >= 0) : "ERROR: expected to find application-level part of library call point when solving with LCPs.";
            Set propagationWitnesses = mapping.getEdgeLabels((Object)path.get(lcpAppEndpointIndex), (Object)path.get(lcpAppEndpointIndex + 1));
            int resultSizeBefore = result.size();
            for (IPropagationWitness w : propagationWitnesses) {
                if (!(w instanceof BasicPropagationWitness)) continue;
                ArrayList<IPropagationWitness> fullPath = new ArrayList<IPropagationWitness>(prefix.size() + suffix.size() + 1);
                fullPath.addAll(prefix);
                fullPath.add(w);
                fullPath.addAll(suffix);
                result.add(fullPath);
            }
            int resultSizeAfter = result.size();
            assert (resultSizeAfter > resultSizeBefore) : "ERROR: must find at least one basic relation between application endpoint and library endpoint of LCP.";
        } else {
            result.add(prefix);
        }
        return result;
    }

    public static Set<List<Variable>> solveWithLCPs(Graph<Variable> mapping, Collection<Variable> sources, Collection<Variable> sinks, Collection<TaintRule> rules) {
        final Graph invertedGraph = GraphInverter.invert(mapping);
        Filter<Variable> lcpFilter = new Filter<Variable>(){

            public boolean accepts(Variable o) {
                if (!o.getMethod().getClassHierarchy().getScope().isApplicationLoader(o.getMethod().getDeclaringClass().getClassLoader())) {
                    Iterator it = invertedGraph.getSuccNodes((Object)o);
                    while (it.hasNext()) {
                        Variable succ = (Variable)it.next();
                        if (!succ.getMethod().getClassHierarchy().getScope().isApplicationLoader(succ.getMethod().getDeclaringClass().getClassLoader())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        Map<Variable, Set<List<Variable>>> pathsFromSinksToLCPsByLCP = BFSPathsFinder.findPathsFromMultipleSources(invertedGraph, sinks, lcpFilter);
        final Set<Variable> lcps = pathsFromSinksToLCPsByLCP.keySet();
        Filter<Variable> filter = new Filter<Variable>(){

            public boolean accepts(Variable v) {
                return lcps.contains(v);
            }
        };
        Map<Variable, Set<List<Variable>>> pathsFromSourcesToLCPsByLCP = BFSPathsFinder.findPathsFromMultipleSources(mapping, sources, filter);
        HashMap rulesToSinks = HashMapFactory.make();
        for (TaintRule r : rules) {
            for (Variable sink : sinks) {
                if (!r.acceptsSink(sink.getMethodRef())) continue;
                Set S = MapUtil.findOrCreateSet((Map)rulesToSinks, (Object)r);
                S.add(sink.getMethod());
            }
        }
        Map sinksToRules = MapUtil.inverseMap((Map)rulesToSinks);
        HashMap lcpsToUniquePaths = HashMapFactory.make();
        for (Variable lcp : lcps) {
            HashMap pathsByRules = HashMapFactory.make();
            for (List<Variable> pathFromSink : pathsFromSinksToLCPsByLCP.get(lcp)) {
                Variable sink = pathFromSink.get(0);
                Set key = (Set)sinksToRules.get(sink.getMethod());
                assert (key != null) : "ERROR: expected sink to match at least one rule!";
                List p = (List)pathsByRules.get(key);
                if (p != null) continue;
                Collections.reverse(pathFromSink);
                pathsByRules.put(key, pathFromSink);
            }
            lcpsToUniquePaths.put(lcp, pathsByRules.values());
        }
        HashSet result = HashSetFactory.make();
        for (Variable lcp : pathsFromSourcesToLCPsByLCP.keySet()) {
            for (List<Variable> pathToLCP : pathsFromSourcesToLCPsByLCP.get(lcp)) {
                for (List pathFromLcpToRepSink : (Collection)lcpsToUniquePaths.get(lcp)) {
                    ArrayList<Variable> l = new ArrayList<Variable>(pathToLCP.size() + pathFromLcpToRepSink.size() - 1);
                    l.addAll(pathToLCP);
                    l.remove(l.size() - 1);
                    l.addAll(pathFromLcpToRepSink);
                    result.add(l);
                }
            }
        }
        return result;
    }

    public static Collection<List<Variable>> solveWithLCPs(Graph<Variable> mapping, Collection<Variable> sources, Collection<TaintRule> rules) {
        HashSet sinks = HashSetFactory.make();
        for (Variable v : mapping) {
            if (!(v instanceof ViolationVariable)) continue;
            sinks.add(v);
        }
        return TaintGraphUtils.solveWithLCPs(mapping, sources, sinks, rules);
    }

    private static Pair<GraphView.MappingFilter<Variable>, GraphView.MappingFilter<Variable>> createSummaryEliminationFilters(final LabeledGraph<Variable, IPropagationWitness> g) {
        GraphView.MappingFilter<Variable> predMF = new GraphView.MappingFilter<Variable>(){

            public Set<Variable> filter(Variable key, Set<Variable> values) {
                HashSet result = HashSetFactory.make();
                block0: for (Variable v : values) {
                    Set labels = g.getEdgeLabels((Object)v, (Object)key);
                    if (labels == null) continue;
                    for (IPropagationWitness w : labels) {
                        if (w instanceof TransitivePropagationWitness) continue;
                        result.add(v);
                        continue block0;
                    }
                }
                return result;
            }
        };
        GraphView.MappingFilter<Variable> succMF = new GraphView.MappingFilter<Variable>(){

            public Set<Variable> filter(Variable key, Set<Variable> values) {
                HashSet result = HashSetFactory.make();
                block0: for (Variable v : values) {
                    Set labels = g.getEdgeLabels((Object)key, (Object)v);
                    if (labels == null) continue;
                    for (IPropagationWitness w : labels) {
                        if (w instanceof TransitivePropagationWitness) continue;
                        result.add(v);
                        continue block0;
                    }
                }
                return result;
            }
        };
        return Pair.make((Object)predMF, (Object)succMF);
    }
}

