/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.util.Cache;
import com.ibm.wala.andromeda.util.SimpleCache;
import com.ibm.wala.andromeda.util.Triple;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.BFSPathFinder;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaintedLexicalAccesses {
    private static boolean USE_BFS_CACHE = true;
    private static Cache<Triple<TICallGraph, CGNode, CGNode>, List<CGNode>> forwardBFSCache;
    private static Cache<Triple<TICallGraph, CGNode, CGNode>, List<CGNode>> backwardsBFSCache;
    private final Map<AccessLite, Set<Pair<CGNode, AstLexicalAccess.Access>>> lexicalAccessesToCGNodes = HashMapFactory.make();
    private final TICallGraph cg;

    public static void setupCaches() {
        forwardBFSCache = new SimpleCache();
        backwardsBFSCache = new SimpleCache();
    }

    public static void resetStaticData() {
        TaintedLexicalAccesses.setupCaches();
    }

    public TaintedLexicalAccesses(TICallGraph callGraph) {
        this.cg = callGraph;
    }

    public void notify(Variable cause, AstLexicalAccess.Access access, ILanguageSpecificServicesForFastanalysis langServices, IFlowHandler handler) {
        CGNode causeNode = this.cg.getNode(cause.getMethod(), cause.getContext());
        Set<Pair<CGNode, AstLexicalAccess.Access>> nodes = this.lexicalAccessesToCGNodes.get(new AccessLite(access.variableName, access.variableDefiner));
        for (Pair<CGNode, AstLexicalAccess.Access> info : nodes) {
            List backPath;
            List path;
            CGNode n = (CGNode)info.fst;
            AstLexicalAccess.Access a = (AstLexicalAccess.Access)info.snd;
            Triple key = Triple.make((Object)this.cg, (Object)causeNode, (Object)n);
            if (USE_BFS_CACHE && forwardBFSCache.containsKey((Object)key)) {
                path = (List)forwardBFSCache.get((Object)key);
            } else {
                BFSPathFinder forwardBFS = new BFSPathFinder((Graph)this.cg, (Object)causeNode, (Object)n);
                path = forwardBFS.find();
                if (USE_BFS_CACHE) {
                    forwardBFSCache.put((Object)key, (Object)path);
                }
            }
            if (path != null) {
                Variable effect = Variable.failOrCreate(n.getMethod(), n.getContext(), a.valueNumber, cause.getAccessPath(), langServices);
                handler.act(effect);
                continue;
            }
            if (USE_BFS_CACHE && backwardsBFSCache.containsKey((Object)key)) {
                backPath = (List)backwardsBFSCache.get((Object)key);
            } else {
                BFSPathFinder backwardsBFS = new BFSPathFinder((Graph)this.cg, (Object)n, (Object)causeNode);
                backPath = backwardsBFS.find();
                if (USE_BFS_CACHE) {
                    backwardsBFSCache.put((Object)key, (Object)backPath);
                }
            }
            if (backPath == null) continue;
            Variable effect = Variable.failOrCreate(n.getMethod(), n.getContext(), a.valueNumber, cause.getAccessPath(), langServices);
            handler.act(effect);
        }
    }

    public void findAccesses() {
        for (CGNode n : this.cg) {
            for (SSAInstruction i : TaintAnalysisCache.soleInstance().getIR(n).getInstructions()) {
                if (!(i instanceof AstLexicalRead)) continue;
                AstLexicalRead read = (AstLexicalRead)i;
                for (AstLexicalAccess.Access access : read.getAccesses()) {
                    MapUtil.findOrCreateSet(this.lexicalAccessesToCGNodes, (Object)new AccessLite(access.variableName, access.variableDefiner)).add(Pair.make((Object)n, (Object)access));
                }
            }
        }
    }

    private class AccessLite {
        private String name;
        private String definer;

        public AccessLite(String name, String definer) {
            this.name = name;
            this.definer = definer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.definer == null ? 0 : this.definer.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccessLite other = (AccessLite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.definer == null ? other.definer != null : !this.definer.equals(other.definer)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        private TaintedLexicalAccesses getOuterType() {
            return TaintedLexicalAccesses.this;
        }
    }

    public static interface IFlowHandler {
        public void act(Variable var1);
    }
}

