/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Set;

public class WebEntrypointsFilter
implements Filter<IMethod> {
    private static final TypeReference HTTP_SERVLET = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (String)"Ljavax/servlet/http/HttpServlet");
    private static final TypeReference HTTP_JSP_PAGE = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (String)"Ljavax/servlet/jsp/HttpJspPage");
    private static final MethodReference DO_GET = MethodReference.findOrCreate((TypeReference)HTTP_SERVLET, (Atom)Atom.findOrCreateUnicodeAtom((String)"doGet"), (Descriptor)Descriptor.findOrCreateUTF8((String)"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"));
    private static final MethodReference DO_POST = MethodReference.findOrCreate((TypeReference)HTTP_SERVLET, (Atom)Atom.findOrCreateUnicodeAtom((String)"doPost"), (Descriptor)Descriptor.findOrCreateUTF8((String)"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"));
    private static final MethodReference JSP_SERVICE = MethodReference.findOrCreate((TypeReference)HTTP_JSP_PAGE, (Atom)Atom.findOrCreateUnicodeAtom((String)"_jspService"), (Descriptor)Descriptor.findOrCreateUTF8((String)"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"));
    private static final Set<IMethod> webEntrypoints = HashSetFactory.make();
    private final IClassHierarchy cha;

    public WebEntrypointsFilter(IClassHierarchy cha) {
        this.cha = cha;
        webEntrypoints.add(this.cha.resolveMethod(DO_GET));
        webEntrypoints.add(this.cha.resolveMethod(DO_POST));
        webEntrypoints.add(this.cha.resolveMethod(JSP_SERVICE));
    }

    public Set<IMethod> getWebEntrypoints() {
        return webEntrypoints;
    }

    public boolean accepts(IMethod candidate) {
        for (IMethod webEntrypoint : webEntrypoints) {
            if (!webEntrypoint.getSelector().equals((Object)candidate.getSelector()) || !this.cha.isAssignableFrom(webEntrypoint.getDeclaringClass(), candidate.getDeclaringClass())) continue;
            return true;
        }
        return false;
    }
}

