/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.diagnostics;

import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.andromeda.cg.util.UserLog;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TaintStatistics {
    private static final Logger logger = SALogger.logger;
    private static TaintStatistics _i = new TaintStatistics();
    private Map<String, String> data = new TreeMap<String, String>();

    public static TaintStatistics i() {
        return _i;
    }

    private TaintStatistics() {
    }

    public void clearStatistics() {
        this.data.clear();
    }

    public void putStatisticInfo(String key, String value) {
        String oldValue = this.data.get(key);
        if (oldValue != null && logger.isDebugEnabled()) {
            logger.debug((Object)("replacing statistic value. key=" + key + " old value=" + oldValue + " new value=" + value));
        }
        this.data.put(key, value);
    }

    public void logStatistics() {
        if (this.data.entrySet().size() > 0) {
            UserLog.logger.info((Object)"Statistics:");
            for (Map.Entry<String, String> e : this.data.entrySet()) {
                UserLog.logger.info((Object)("\t" + e.getKey() + ": " + e.getValue()));
            }
        }
    }

    public void increaseCounter(String key) {
        this.increaseCounter(key, 1);
    }

    public void increaseCounter(String key, int howMuch) {
        String currentValue = this.data.get(key);
        int currentIntValue = currentValue == null ? 0 : Integer.parseInt(currentValue);
        this.data.put(key, "" + (currentIntValue += howMuch));
    }
}

