/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.andromeda.core.CustomEntrypointsCollector;
import com.ibm.wala.andromeda.core.IEntrypointsCollector;
import com.ibm.wala.andromeda.core.TaintAnalysis;
import com.ibm.wala.andromeda.core.TaintAnalyzer;
import com.ibm.wala.andromeda.frameworks.FrameworkSupport;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.jsp.JSPUtil;
import com.ibm.wala.andromeda.lang.DotNetServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServicesForFastanalysis;
import com.ibm.wala.andromeda.progress.ITaintRunnerDebug;
import com.ibm.wala.andromeda.progress.SolverKind;
import com.ibm.wala.andromeda.progress.Step;
import com.ibm.wala.andromeda.rules.FlowStep;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.andromeda.rules.Rules;
import com.ibm.wala.andromeda.rules.management.TaintEntrypointType;
import com.ibm.wala.andromeda.util.TaintRunnerStats;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.andromeda.util.scopes.ScopeUtil;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.StringStuff;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TaintRunner
implements ITaintRunnerDebug {
    private static final String TAINT_RUNNER_STATS_FILE_WITHOUT_SUMMARIES = "taint_runner_stats_without_summaries.txt";
    private static final String TAINT_RUNNER_STATS_FILE_WITH_SUMMARIES = "taint_runner_stats_with_summaries.txt";
    private static final String RESULTS_FOR_TRUE_SET_COMPARISON_FILE_NAME = "res.csv";
    private static final Collection<TaintEntrypointType> SUPPORTED_ENTRYPOINT_TYPES;
    private static final TypeReference HTTP_SERVLET;
    private final Set<IRawTaintRule> declarativeRules = HashSetFactory.make();
    private final Set<TaintRule> analysisRules = HashSetFactory.make();
    private final IClassHierarchy cha;
    private Predicate<IClass> interestingClassesFilter = new Predicate<IClass>(){

        public boolean test(IClass o) {
            return o.getClassHierarchy().getScope().isApplicationLoader(o.getClassLoader());
        }
    };
    private Collection<IClass> entrypoints;
    private IEntrypointsCollector entrypointsCollector;
    private TaintAnalysis analysis;
    private Predicate<IClass> currentFilter;
    private final ILanguageSpecificServicesForFastanalysis langServices;
    public static boolean USE_FRAMEWORKS;
    public static boolean USE_COMBINED_ENTRYPOINTS;
    public static String FRAMEWORKS_ENTRYPOINTS_FILEPATH;
    public static String FRAMEWORKS_CALLSITE_REPLACEMENTS_FILEPATH;
    public static final boolean FLATTEN_THREADS = true;

    public TaintRunner(AnalysisScope scope) throws ClassHierarchyException {
        this((IClassHierarchy)ClassHierarchy.make((AnalysisScope)scope));
    }

    public TaintRunner(IClassHierarchy cha) throws ClassHierarchyException {
        this(cha, new CustomEntrypointsCollector(new Predicate<IClass>(){

            public boolean test(IClass o) {
                return o.getClassHierarchy().getScope().isApplicationLoader(o.getClassLoader());
            }
        }, new Predicate<IMethod>(){

            public boolean test(IMethod o) {
                return (o.isProtected() || o.isPublic()) && !o.isNative() && !o.isAbstract();
            }
        }));
    }

    public TaintRunner(IClassHierarchy cha, IEntrypointsCollector entrypointCollector) {
        this.cha = cha;
        this.entrypointsCollector = entrypointCollector;
        AnalysisScope scope = cha.getScope();
        assert (scope.getLanguages().size() == 1);
        Language soleLang = (Language)scope.getLanguages().iterator().next();
        assert (soleLang.equals(Language.JAVA) || soleLang.equals(CLRLanguage.lang));
        this.langServices = soleLang.equals(Language.JAVA) ? JavaServicesForFastanalysis.JAVA : DotNetServicesForFastanalysis.DOTNET;
        JSPUtil.registerScope(scope);
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze(Step<String> step) {
        return this.analyze();
    }

    private void updateAnalysisRules() {
        this.analysisRules.clear();
        for (IRawTaintRule rule : this.declarativeRules) {
            if (!rule.getContext().acceptsAny(SUPPORTED_ENTRYPOINT_TYPES)) continue;
            TaintRule tr = new TaintRule(this.cha, rule);
            this.analysisRules.add(tr);
        }
        this.invalidateAnalysis();
    }

    private void invalidateAnalysis() {
        this.analysis = null;
    }

    private Pair<Set<ITaintResult>, TaintRunnerStats> doAnalysis() {
        Pair<Set<ITaintResult>, TaintRunnerStats> result = null;
        try {
            if (this.analysis == null) {
                this.analysis = new TaintAnalysis(this.cha, this.analysisRules, this.entrypointsCollector, this.langServices);
            }
            result = this.analysis.run();
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (CallGraphBuilderCancelException e) {
            e.printStackTrace();
        }
        catch (Decoder.InvalidBytecodeException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze(String[] testClasses, Step<String> step) {
        HashSet classes = HashSetFactory.make();
        for (String testClass : testClasses) {
            classes.add(this.lookupClass(testClass));
        }
        this.updateEntrypointsCollector((Predicate<IClass>)new CollectionFilter((Collection)classes));
        return this.doAnalysis();
    }

    private IClass lookupClass(String testClass) {
        String klassName = StringStuff.deployment2CanonicalTypeString((String)testClass);
        TypeReference t = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)klassName);
        IClass klass = this.cha.lookupClass(t);
        return klass;
    }

    private void updateEntrypointsCollector(Predicate<IClass> filter) {
        if (this.currentFilter == null || !filter.equals(this.currentFilter)) {
            this.currentFilter = filter;
            this.entrypointsCollector = new CustomEntrypointsCollector(this.currentFilter, new Predicate<IMethod>(){

                public boolean test(IMethod o) {
                    return (o.isProtected() || o.isPublic()) && !o.isNative() && !o.isAbstract();
                }
            });
            this.invalidateAnalysis();
        }
    }

    private void updateEntrypoints() {
        IClass httpServlet = this.cha.lookupClass(HTTP_SERVLET);
        assert (httpServlet != null) : "ERROR: expected 'HttpServlet' class to be in scope!";
        this.entrypoints = HashSetFactory.make();
        for (IClass c : this.cha) {
            if (!this.interestingClassesFilter.test((Object)c) || c.isAbstract() || c.isInterface() || !this.cha.isAssignableFrom(httpServlet, c)) continue;
            this.entrypoints.add(c);
        }
    }

    @Override
    public void setEventHandler(ITaintRunnerDebug.ITaintRunnerEventHandler handler) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void setSolver(SolverKind solver) {
    }

    @Override
    public void setAccuracyLevel(int accuracyLevelIndex) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addRule(IRawTaintRule rule) {
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze(String testClass) {
        return this.analyze(new String[]{testClass}, null);
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze(String testClass, String sanitizerSignature) {
        return this.analyze(new String[]{testClass}, null);
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze() {
        this.updateEntrypointsCollector(this.interestingClassesFilter);
        return this.doAnalysis();
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze(String[] testClasses) {
        return this.analyze(testClasses, null);
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyzeEach(Collection<String> methodSig) {
        return null;
    }

    @Override
    public CallGraph buildCallGraph(String taintClass) {
        return null;
    }

    @Override
    public AnalysisScope getAnalysisScope() {
        return this.cha.getScope();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public Set<IRawTaintRule> getRules() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public boolean removeRule(IRawTaintRule rule) {
        return false;
    }

    @Override
    public void setRules(Set<IRawTaintRule> rules) {
        this.analysisRules.clear();
        for (IRawTaintRule r : rules) {
            this.analysisRules.add(new TaintRule(this.cha, r));
        }
        this.invalidateAnalysis();
    }

    public static void main(String[] args) throws IOException, ClassHierarchyException {
        TaintRunnerProgramArgs parsedArgs = new TaintRunnerProgramArgs(args);
        long startTime = System.currentTimeMillis();
        String scopePath = parsedArgs.scopePath;
        String statsFile = parsedArgs.statsFile;
        USE_FRAMEWORKS = parsedArgs.usingFrameworks;
        FRAMEWORKS_ENTRYPOINTS_FILEPATH = parsedArgs.frameworksEntrypointsFilename;
        FRAMEWORKS_CALLSITE_REPLACEMENTS_FILEPATH = parsedArgs.frameworksCallReplacementFilename;
        TaintAnalyzer.ENABLE_SPECIAL_TREATMENT_FOR_SESSION_OBJECTS = parsedArgs.withSessionsAsMaps;
        ClassLoader javaLoader = AbstractAnalysisEngine.class.getClassLoader();
        AnalysisScope scope = TaintRunner.loadAnalysisScope(scopePath, javaLoader);
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope);
        TaintRunner runner = new TaintRunner((IClassHierarchy)cha);
        runner.setRules(Rules.getAllJavaRules());
        if (USE_FRAMEWORKS) {
            FrameworkSupport.deserialize(FRAMEWORKS_CALLSITE_REPLACEMENTS_FILEPATH, (IClassHierarchy)cha);
        }
        Pair<Set<ITaintResult>, TaintRunnerStats> results = runner.analyze();
        long stopTime = System.currentTimeMillis();
        long runningTime = stopTime - startTime;
        FileWriter out = new FileWriter(new File(statsFile), true);
        out.write(scopePath + ", " + runningTime + ", " + ((TaintRunnerStats)results.snd).numCGNodes + ", " + ((Set)results.fst).size() + "\n");
        out.close();
        int idx = 0;
        ObjectOutputStream serialOut = new ObjectOutputStream(new FileOutputStream("results"));
        serialOut.writeObject(results.fst);
        serialOut.close();
        TaintRunner.writeTrueSetComparisonFile(results);
        for (ITaintResult result : (Set)results.fst) {
            System.out.println("Result #" + idx++ + ":");
            System.out.println(result);
        }
        if (TaintAnalyzer.GENERATE_CANDIDATES_FILE) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new File("./candidates.txt"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            for (IMethod m : TaintAnalyzer.offlineCandidates) {
                writer.println(m.getSignature());
            }
            writer.close();
        }
    }

    private static AnalysisScope loadAnalysisScope(String scopePath, ClassLoader javaLoader) throws IOException {
        AnalysisScope scope = ScopeUtil.substituteAndCreateJavaAnalysisScope((String)scopePath, (File)TaintFileProvider.getFile((String)"dat/exclusions.java.dat"), (ClassLoader)javaLoader);
        if (USE_FRAMEWORKS) {
            FileProvider fp = new FileProvider();
            File frameworksDir = fp.getFile(System.getProperty("FrameWorks"), javaLoader);
            scope.addToScope(scope.getApplicationLoader(), (Module)new BinaryDirectoryTreeModule(frameworksDir));
        }
        return scope;
    }

    private static void writeTrueSetComparisonFile(Pair<Set<ITaintResult>, TaintRunnerStats> results) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(RESULTS_FOR_TRUE_SET_COMPARISON_FILE_NAME));
        for (ITaintResult result : (Set)results.fst) {
            List<FlowStep> flow = result.getFlow();
            FlowStep flowStep = flow.get(flow.size() - 1);
            String s = flowStep.getFileName() + ":" + flowStep.getLineNumber();
            bw.write(s + "\n");
        }
        bw.flush();
        bw.close();
    }

    static {
        HTTP_SERVLET = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (String)"Ljavax/servlet/http/HttpServlet");
        SUPPORTED_ENTRYPOINT_TYPES = HashSetFactory.make();
        SUPPORTED_ENTRYPOINT_TYPES.add(TaintEntrypointType.Servlet);
        SUPPORTED_ENTRYPOINT_TYPES.add(TaintEntrypointType.CGI);
    }

    public static class TaintRunnerProgramArgs {
        public String scopePath;
        public String statsFile;
        public boolean usingSummaries;
        public boolean usingFrameworks;
        public boolean usingCombinedEntrypoints;
        public String frameworksEntrypointsFilename;
        public String frameworksCallReplacementFilename;
        public boolean withSessionsAsMaps;

        private void printUsage() {
            System.out.println("java ... scope_path");
            System.out.println("--with-summaries");
            System.out.println("--without-summaries");
            System.out.println("--with-frameworks");
            System.out.println("--without-frameworks");
            System.out.println("--with-sessions-as-maps");
            System.out.println("--without-sessions-as-maps");
            System.out.println("--frameworks-entrypoints filename");
            System.out.println("--frameworks-callreplacements filename");
            System.out.println("--with-combined-entrypoints");
            System.out.println("--without-combined-entrypoints");
        }

        public TaintRunnerProgramArgs(String[] args) {
            boolean setUsingSummaries = false;
            boolean setUsingFrameworks = false;
            boolean setWithSessionsAsMaps = false;
            boolean setUsingCombinedEntrypoints = false;
            if (args.length < 2) {
                this.printUsage();
                System.exit(127);
            }
            this.scopePath = args[0];
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("--with-summaries")) {
                    this.statsFile = TaintRunner.TAINT_RUNNER_STATS_FILE_WITH_SUMMARIES;
                    this.usingSummaries = true;
                    setUsingSummaries = true;
                    continue;
                }
                if (arg.equals("--without-summaries")) {
                    this.statsFile = TaintRunner.TAINT_RUNNER_STATS_FILE_WITHOUT_SUMMARIES;
                    this.usingSummaries = false;
                    setUsingSummaries = true;
                    continue;
                }
                if (arg.equals("--with-frameworks")) {
                    this.usingFrameworks = true;
                    setUsingFrameworks = true;
                    continue;
                }
                if (arg.equals("--without-frameworks")) {
                    this.usingFrameworks = false;
                    setUsingFrameworks = true;
                    continue;
                }
                if (arg.equals("--with-sessions-as-maps")) {
                    this.withSessionsAsMaps = true;
                    setWithSessionsAsMaps = true;
                    continue;
                }
                if (arg.equals("--without-sessions-as-maps")) {
                    this.withSessionsAsMaps = false;
                    setWithSessionsAsMaps = true;
                    continue;
                }
                if (arg.equals("--frameworks-entrypoints")) {
                    if (i + 1 >= args.length) {
                        this.printUsage();
                        System.exit(127);
                    }
                    this.frameworksEntrypointsFilename = args[i + 1];
                    ++i;
                    continue;
                }
                if (arg.equals("--frameworks-callreplacements")) {
                    if (i + 1 >= args.length) {
                        this.printUsage();
                        System.exit(127);
                    }
                    this.frameworksCallReplacementFilename = args[i + 1];
                    ++i;
                    continue;
                }
                if (arg.equals("--with-combined-entrypoints")) {
                    setUsingCombinedEntrypoints = true;
                    this.usingCombinedEntrypoints = true;
                    continue;
                }
                if (arg.equals("--without-combined-entrypoints")) {
                    setUsingCombinedEntrypoints = true;
                    this.usingCombinedEntrypoints = false;
                    continue;
                }
                System.err.println("Invalid argument: " + arg);
                this.printUsage();
                System.exit(127);
            }
            if (!setUsingFrameworks) {
                System.err.println("You must set if you are using frameworks or not");
                this.printUsage();
                System.exit(127);
            } else if (!setUsingSummaries) {
                System.err.println("You must set if you are using summaries or not");
                this.printUsage();
                System.exit(127);
            } else if (!setWithSessionsAsMaps) {
                System.err.println("You must set if you want to use sessions as maps");
                this.printUsage();
                System.exit(127);
            } else if (this.usingFrameworks && !setUsingCombinedEntrypoints) {
                System.err.println("You set using frameworks but didn't set if we are using combined entrypoints");
                this.printUsage();
                System.exit(127);
            } else if (this.usingFrameworks && (this.frameworksCallReplacementFilename == null || this.frameworksEntrypointsFilename == null)) {
                System.err.println("You set using frameworks but didn't set the call replacement file and the entrypoints file");
                this.printUsage();
                System.exit(127);
            } else if (this.withSessionsAsMaps && this.usingFrameworks) {
                System.err.println("You shouldn't be running with frameworks AND sessions as maps");
                this.printUsage();
                System.exit(127);
            }
        }
    }
}

