/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.incremental.ISupportGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BasicSupportGraph
implements ISupportGraph {
    private final AbstractNumberedLabeledGraph<ISupportGraph.Fact, ISupportGraph.EdgeType> graph = new SlowSparseNumberedLabeledGraph((Object)ISupportGraph.EdgeType.INTRAPROCEDURAL);
    private final Map<IMethod, Set<ISupportGraph.Fact>> factBindings = HashMapFactory.make();

    public String toString() {
        return this.graph.toString();
    }

    @Override
    public boolean addFact(ISupportGraph.Fact f) {
        this.graph.addNode((Object)f);
        return true;
    }

    @Override
    public boolean addSupport(ISupportGraph.Fact from, ISupportGraph.Fact to) {
        this.graph.addNode((Object)from);
        this.graph.addNode((Object)to);
        this.graph.addEdge((Object)from, (Object)to, (Object)(from.getBindings().equals(to.getBindings()) ? ISupportGraph.EdgeType.INTRAPROCEDURAL : ISupportGraph.EdgeType.INTERPROCEDURAL));
        IMethod m = from.getBindings();
        Set boundedFacts = MapUtil.findOrCreateSet(this.factBindings, (Object)m);
        boundedFacts.add(from);
        return true;
    }

    @Override
    public Set<ISupportGraph.Fact> getBoundedFacts(IMethod m) {
        return this.factBindings.get(m);
    }

    @Override
    public Collection<ISupportGraph.Fact> getSupportedFacts(ISupportGraph.Fact f) {
        return Iterator2Collection.toSet((Iterator)this.graph.getSuccNodes((Object)f));
    }

    @Override
    public Set<ISupportGraph.Fact> invalidate(ISupportGraph.Fact fact) {
        HashSet result = HashSetFactory.make();
        if (this.graph.containsNode((Object)fact)) {
            HashSet worklist = HashSetFactory.make();
            HashSet handled = HashSetFactory.make();
            worklist.add(fact);
            while (!worklist.isEmpty()) {
                Iterator factIter = worklist.iterator();
                worklist = HashSetFactory.make();
                while (factIter.hasNext()) {
                    ISupportGraph.Fact current = (ISupportGraph.Fact)factIter.next();
                    handled.add(current);
                    Iterator succIter = this.graph.getSuccNodes((Object)current);
                    while (succIter.hasNext()) {
                        ISupportGraph.Fact succ = (ISupportGraph.Fact)succIter.next();
                        if (this.graph.getPredNodeCount((Object)succ) != 1 || handled.contains(succ)) continue;
                        worklist.add(succ);
                    }
                    this.graph.removeNodeAndEdges((Object)current);
                    result.add(current);
                }
            }
        }
        return result;
    }

    @Override
    public Set<ISupportGraph.Fact> invalidateAll(Set<ISupportGraph.Fact> facts) {
        HashSet result = HashSetFactory.make();
        for (ISupportGraph.Fact fact : facts) {
            result.addAll(this.invalidate(fact));
        }
        return result;
    }

    @Override
    public ISupportGraph.EdgeType getEdgeType(ISupportGraph.Fact A, ISupportGraph.Fact B) {
        assert (this.graph.containsNode((Object)A));
        assert (this.graph.containsNode((Object)B));
        Set labels = this.graph.getEdgeLabels((Object)A, (Object)B);
        assert (labels.size() == 1);
        return (ISupportGraph.EdgeType)((Object)labels.iterator().next());
    }

    @Override
    public int getNumberOfFacts() {
        return this.graph.getNumberOfNodes();
    }
}

