/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.classLoader.IMethod;
import java.util.Collection;
import java.util.Set;

public interface ISupportGraph {
    public boolean addFact(Fact var1);

    public boolean addSupport(Fact var1, Fact var2);

    public Collection<Fact> getSupportedFacts(Fact var1);

    public Set<Fact> getBoundedFacts(IMethod var1);

    public Set<Fact> invalidate(Fact var1);

    public Set<Fact> invalidateAll(Set<Fact> var1);

    public EdgeType getEdgeType(Fact var1, Fact var2);

    public int getNumberOfFacts();

    public static class BinaryFact
    extends Fact {
        private final Variable lhs;
        private final Variable rhs;

        public BinaryFact(Variable lhs, Variable rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public String toString() {
            return "BINARY FACT: " + this.lhs + " ---> " + this.rhs + ".";
        }

        public Variable getLHS() {
            return this.lhs;
        }

        public Variable getRHS() {
            return this.rhs;
        }

        @Override
        public IMethod getBindings() {
            return this.lhs.getMethod();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinaryFact other = (BinaryFact)obj;
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }
    }

    public static class UnaryFact
    extends Fact {
        private final Variable variable;

        public UnaryFact(Variable variable) {
            this.variable = variable;
        }

        public Variable getVariable() {
            return this.variable;
        }

        @Override
        public IMethod getBindings() {
            return this.variable.getMethod();
        }

        public String toString() {
            return "UNARY FACT: " + this.variable + ".";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnaryFact other = (UnaryFact)obj;
            return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
        }
    }

    public static abstract class Fact {
        public abstract IMethod getBindings();
    }

    public static enum EdgeType {
        INTERPROCEDURAL,
        INTRAPROCEDURAL,
        BRIDGE;

    }
}

