/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.models;

import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.modular.FlowAnalyzer;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OfflineSpecificationReader {
    private static final Logger logger = SALogger.logger;
    private final IClassHierarchy cha;
    private final ILangServices langServices;
    private final ILanguageSpecificServicesForFastanalysis fastLangServices;
    private final Collection<IMember> sourceCodePatterns;
    private final Collection<IMember> sinkPatterns;

    public static OfflineSpecification createSpecification(Set<IRawTaintRule> rules, IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fastLangServices) {
        HashSet sourceCodePatterns = HashSetFactory.make();
        HashSet sinkCodePatterns = HashSetFactory.make();
        for (IRawTaintRule rule : rules) {
            sourceCodePatterns.addAll(rule.getSources());
            sinkCodePatterns.addAll(rule.getSinks());
        }
        OfflineSpecificationReader specificationReader = new OfflineSpecificationReader(cha, langServices, fastLangServices, sourceCodePatterns, sinkCodePatterns);
        return specificationReader.createSpecification();
    }

    public OfflineSpecificationReader(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fastLangServices, Collection<IMember> sourceCodePatterns, Collection<IMember> sinkCodePatterns) {
        this.cha = cha;
        this.langServices = langServices;
        this.fastLangServices = fastLangServices;
        this.sourceCodePatterns = sourceCodePatterns;
        this.sinkPatterns = sinkCodePatterns;
    }

    public OfflineSpecification createSpecification() {
        OfflineSpecification offline = this.loadOfflineSpecification();
        Collection<String> allSourcePatterns = this.collectAllSourcePatterns();
        Set sourceMethods = SignatureUtil.findMatchingMethods((IClassHierarchy)this.cha, allSourcePatterns, (Language)this.langServices.getLanguage());
        offline.addTerminatingMethods(sourceMethods);
        Collection<String> allSinkSigs = this.collectAllSinkPatterns();
        if (!this.langServices.getLanguage().equals(JavaScriptLoader.JS)) {
            Set sinkMethods = SignatureUtil.findMatchingMethods((IClassHierarchy)this.cha, allSinkSigs, (Language)this.langServices.getLanguage());
            offline.addTerminatingMethods(sinkMethods);
        }
        return offline;
    }

    private Collection<String> collectAllSourcePatterns() {
        HashSet result = HashSetFactory.make();
        for (IMember source : this.sourceCodePatterns) {
            result.add(source.getPattern());
        }
        return result;
    }

    private Collection<String> collectAllSinkPatterns() {
        HashSet result = HashSetFactory.make();
        for (IMember sink : this.sinkPatterns) {
            result.add(sink.getPattern());
        }
        return result;
    }

    private OfflineSpecification loadOfflineSpecification() {
        String offlineSpecFile = this.langServices.getOfflineSpecificationFile();
        try {
            File f = TaintFileProvider.getFile((String)offlineSpecFile);
            File autoSummariesFile = new File(FlowAnalyzer.AUTO_SUMMARIES_FILE_NAME);
            return OfflineSpecification.load(f, autoSummariesFile, this.cha, this.langServices.getLanguage(), this.fastLangServices);
        }
        catch (IOException e) {
            logger.fatal((Object)("Failed to load offline specification " + offlineSpecFile), (Throwable)e);
            return null;
        }
    }
}

