/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.modular;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ConcreteResolutionEnumerator {
    private final IClassHierarchy cha;
    private static final int INFINITY = -1;

    public ConcreteResolutionEnumerator(IClassHierarchy cha) {
        this.cha = cha;
    }

    private boolean isMatchedBy(TypeAbstraction abstraction, TypeReference tr) {
        if (abstraction != null) {
            IClass klass = this.cha.lookupClass(tr);
            if (klass != null) {
                if (abstraction instanceof ConeType) {
                    IClass cone = abstraction.getType();
                    if (this.cha.isAssignableFrom(cone, klass)) {
                        return true;
                    }
                } else if (abstraction instanceof PointType) {
                    IClass point = abstraction.getType();
                    if (point.equals(klass)) {
                        return true;
                    }
                } else if (abstraction instanceof PrimitiveType) {
                    if (abstraction.getTypeReference().equals((Object)tr)) {
                        return true;
                    }
                } else if (abstraction instanceof SetType) {
                    SetType st = (SetType)abstraction;
                    Iterator it = st.iteratePoints();
                    while (it.hasNext()) {
                        TypeReference trInSet = (TypeReference)it.next();
                        IClass classInSet = this.cha.lookupClass(trInSet);
                        if (classInSet == null || !classInSet.equals(klass)) continue;
                        return true;
                    }
                } else {
                    Assertions.UNREACHABLE((String)"ERROR: unexpected type of 'TypeAbstraction'!");
                }
            }
            return false;
        }
        return true;
    }

    public Iterator<List<TypeReference>> getBoundedIterator(IMethod m, int bound) {
        return this.getBoundedIterator(m, bound, null);
    }

    public Iterator<List<TypeReference>> getBoundedIterator(IMethod m, int bound, TypeAbstraction[] constraints) {
        int numberOfParameters = m.getNumberOfParameters();
        ArrayList<List<TypeReference>> allOptions = new ArrayList<List<TypeReference>>(numberOfParameters);
        for (int index = 0; index < numberOfParameters; ++index) {
            ArrayList<TypeReference> concreteResolutions = new ArrayList<TypeReference>();
            TypeReference t = m.getParameterType(index);
            if (this.isPrimitiveType(t, m.getDeclaringClass().getClassLoader().getLanguage())) {
                concreteResolutions.add(t);
            } else {
                IClass klass = this.cha.lookupClass(t);
                if (klass != null) {
                    Collection subclasses = this.cha.computeSubClasses(t);
                    for (IClass c : subclasses) {
                        if (c.isAbstract() || c.isInterface() || constraints != null && !this.isMatchedBy(constraints[index], c.getReference())) continue;
                        concreteResolutions.add(c.getReference());
                    }
                }
            }
            allOptions.add(concreteResolutions);
        }
        return new ConcreteResolutionIterator(m, allOptions, bound);
    }

    private boolean isPrimitiveType(TypeReference t, Language language) {
        if (language.equals(Language.JAVA)) {
            return t.isPrimitiveType();
        }
        if (language.equals(CLRLanguage.lang)) {
            TypeReference ref = CLRTypeReference.getPrimitive((String)t.getName().toString().substring(1));
            return ref == null ? false : ref.equals((Object)t);
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public Iterator<List<TypeReference>> getIterator(IMethod m) {
        return this.getBoundedIterator(m, -1, null);
    }

    public Iterator<List<TypeReference>> getIterator(IMethod m, TypeAbstraction[] abstractions) {
        return this.getBoundedIterator(m, -1, abstractions);
    }

    private static class ConcreteResolutionIterator
    implements Iterator<List<TypeReference>> {
        private final IMethod m;
        private final List<List<TypeReference>> allOptions;
        private final List<List<Integer>> allCombinations;
        private Integer indexIntoAllCombinations = 0;

        public ConcreteResolutionIterator(IMethod m, List<List<TypeReference>> allOptions, int bound) {
            this.m = m;
            this.allOptions = this.limit(allOptions, bound);
            this.allCombinations = this.computeAllCombinations();
        }

        private List<List<TypeReference>> limit(List<List<TypeReference>> allOptions, int bound) {
            if (bound == -1) {
                return allOptions;
            }
            ArrayList<List<TypeReference>> result = new ArrayList<List<TypeReference>>(allOptions.size());
            for (int index = 0; index < allOptions.size(); ++index) {
                List<TypeReference> current = allOptions.get(index);
                int currentSize = Math.min(bound, current.size());
                ArrayList<TypeReference> l = new ArrayList<TypeReference>(currentSize);
                for (int i = 0; i < currentSize; ++i) {
                    l.add(current.get(i));
                }
                result.add(l);
            }
            return result;
        }

        private List<List<Integer>> computeAllCombinations() {
            if (this.allOptions.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
            result.addAll(this.computeAllCombinationsImpl(0));
            return result;
        }

        private List<List<Integer>> computeAllCombinationsImpl(int i) {
            ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
            if (i == this.allOptions.size() - 1) {
                for (int index = 0; index < this.allOptions.get(i).size(); ++index) {
                    ArrayList<Integer> l = new ArrayList<Integer>(1);
                    l.add(index);
                    result.add(l);
                }
            } else {
                List<List<Integer>> suffixes = this.computeAllCombinationsImpl(i + 1);
                for (int index = 0; index < this.allOptions.get(i).size(); ++index) {
                    for (List<Integer> suffix : suffixes) {
                        ArrayList<Integer> l = new ArrayList<Integer>(1);
                        l.add(index);
                        l.addAll(suffix);
                        result.add(l);
                    }
                }
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.indexIntoAllCombinations <= this.allCombinations.size() - 1;
        }

        @Override
        public List<TypeReference> next() {
            assert (this.hasNext());
            List<Integer> currentCombination = this.allCombinations.get(this.indexIntoAllCombinations);
            ArrayList<TypeReference> result = new ArrayList<TypeReference>(this.m.getNumberOfParameters());
            for (int i = 0; i < this.m.getNumberOfParameters(); ++i) {
                result.add(this.allOptions.get(i).get(currentCombination.get(i)));
            }
            this.indexIntoAllCombinations = this.indexIntoAllCombinations + 1;
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

