/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.modular;

import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.cg.util.ScopeUtil;
import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.BFSPathsFinder;
import com.ibm.wala.andromeda.core.BasicPropagationWitness;
import com.ibm.wala.andromeda.core.DeadEndVariable;
import com.ibm.wala.andromeda.core.DependenceMap;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.NullPropagationWitness;
import com.ibm.wala.andromeda.core.PartialPropagationWitness;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.SummaryPropagationWitness;
import com.ibm.wala.andromeda.core.TaintGraphUtils;
import com.ibm.wala.andromeda.core.TransitivePropagationWitness;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.VariableRegistry;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.diagnostics.TimedSection;
import com.ibm.wala.andromeda.diagnostics.Timing;
import com.ibm.wala.andromeda.incremental.ISupportGraph;
import com.ibm.wala.andromeda.incremental.SummaryCache;
import com.ibm.wala.andromeda.lang.DotNetServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServicesForFastanalysis;
import com.ibm.wala.andromeda.management.AnalysisOptions;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.modular.ConcreteResolutionEnumerator;
import com.ibm.wala.andromeda.modular.ContextualSummary;
import com.ibm.wala.andromeda.modular.ExhaustiveSummary;
import com.ibm.wala.andromeda.modular.SummaryCallGraph;
import com.ibm.wala.andromeda.policy.IPropagationPolicy;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.management.Issue;
import com.ibm.wala.andromeda.rules.management.RuleManager;
import com.ibm.wala.andromeda.util.ErrorLog;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ReflectiveMemberAccess;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAAbstractUnaryInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowAnalyzer {
    private static final boolean DEBUG = true;
    private static final boolean LOG_DEBUG_HOOK = false;
    private static final Predicate<IMethod> LOG_DEBUG_FILTER = new IndiscriminateFilter();
    private static final Predicate<Variable> SLICING_FILTER = new Predicate<Variable>(){

        public boolean test(Variable o) {
            return o.getVarID() == 6 && o.getMethod().getName().toString().equals("getRawParameter");
        }
    };
    private static final int UNCONDITIONAL_INDEX = 0;
    private static final String SYSTEM_COLLECTIONS_ICOLLECTION = "LSystem/Collections/ICollection";
    private static final String SYSTEM_WEB_SESSION_STATE_HTTP_SESSION_STATE = "LSystem/Web/SessionState/HttpSessionState";
    private static final String SYSTEM_COLLECTIONS_IDICTIONARY = "LSystem/Collections/IDictionary";
    private static final boolean PARANOID = false;
    private static final boolean VERBOSE = false;
    private static final int ARRAY_INDEX_USE_INDEX = 1;
    private static final int ARRAY_VALUE_USE_INDEX = 2;
    private static final int MAP_REF_USE_INDEX = 0;
    private static final int MAP_KEY_USE_INDEX = 1;
    private static final int MAP_VALUE_USE_INDEX = 2;
    private static final int FIELD_PUT_GET_REF_USE_INDEX = 0;
    private static final int FIELD_PUT_VALUE_USE_INDEX = 1;
    private static final int ARRAY_REF_USE_INDEX = 0;
    private static final MethodReference CTOR_NEW_INSTANCE = MethodReference.findOrCreate((TypeReference)TypeReference.JavaLangReflectConstructor, (String)"newInstance", (String)"([Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Selector GET_SELECTOR = Selector.make((String)"get(Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Selector GET_ATTRIBUTE_SELECTOR = Selector.make((String)"getAttribute(Ljava/lang/String;)Ljava/lang/Object;");
    private static final Atom GET_ITEM_ATOM = Atom.findOrCreateUnicodeAtom((String)"get_Item");
    private static final Selector PUT_SELECTOR = Selector.make((String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Selector SET_ATTRIBUTE_SELECTOR = Selector.make((String)"setAttribute(Ljava/lang/String;Ljava/lang/Object;)V");
    private static final Atom SET_ITEM_ATOM = Atom.findOrCreateUnicodeAtom((String)"set_Item");
    private static final TypeReference HTTP_SESSION_TYPE_REF = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (TypeName)TypeName.string2TypeName((String)"Ljavax/servlet/http/HttpSession"));
    private static final boolean ACCOUNT_FOR_UNCONDITIONAL_FLOWS = true;
    private static final boolean SUPERPOSE_BALANCED_AND_UNBALANCED_FLOWS = true;
    public static final String AUTO_SUMMARIES_FILE_NAME = System.getProperty("TaintResources") + File.separator + "autoSummaries.txt";
    private static final int POLYMORPHISM = 3;
    private final IClassHierarchy cha;
    private final Filter<MethodReference> sourceFilter;
    private final Filter<MethodReference> sinkFilter;
    private final VariableRegistry discovered;
    private final VariableRegistry explored;
    private final ISupportGraph supportGraph = AnalysisOptions.getSupportGraph();
    private final Map<Variable, Set<Variable>> waitingList = HashMapFactory.make();
    private IClass systemCollectionsIDictionary;
    private IClass systemCollectionsICollection;
    private IClass systemWebSessionState;
    private final Map<FieldReference, Set<IMethod>> allStaticGetFields = HashMapFactory.make();
    private final Map<FieldReference, Set<Variable>> taintedStaticGetFields = HashMapFactory.make();
    private final Map<IMethod, Map<Variable, Set<Variable>>> formalToActualParameters = HashMapFactory.make();
    private final Map<Pair<IMethod, Integer>, IClass> concreteResolutions = HashMapFactory.make();
    private final AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph = new SlowSparseNumberedLabeledGraph((Object)NullPropagationWitness.soleInstance());
    private final DependenceMap<Variable> dependenceMap = new DependenceMap();
    private final Set<Variable> seeds = HashSetFactory.make();
    private final OfflineSpecification spec;
    private TICallGraph cg;
    private final Filter<Pair<Variable, SSAAbstractInvokeInstruction>> shortCircuitFilter;
    private IPropagationPolicy propagationPolicy = AnalysisOptions.getPropagationPolicy();
    private final ILangServices langServices;
    private final ILanguageSpecificServicesForFastanalysis fastLangServices;
    Set<Pair<Variable, Variable>> history = HashSetFactory.make();

    public FlowAnalyzer(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services) {
        this(cha, langServices, fast_lang_services, OfflineSpecification.loadDefaultSpec(cha, langServices, fast_lang_services));
    }

    public FlowAnalyzer(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services, OfflineSpecification spec) {
        this(cha, langServices, fast_lang_services, spec, new Filter<MethodReference>(){

            public boolean accepts(MethodReference o) {
                return false;
            }
        }, new Filter<MethodReference>(){

            public boolean accepts(MethodReference o) {
                return false;
            }
        });
    }

    public FlowAnalyzer(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services, Filter<MethodReference> sourceFilter, Filter<MethodReference> sinkFilter) {
        this(cha, langServices, fast_lang_services, OfflineSpecification.loadDefaultSpec(cha, langServices, fast_lang_services), sourceFilter, sinkFilter);
    }

    public FlowAnalyzer(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services, OfflineSpecification spec, Filter<MethodReference> sourceFilter, Filter<MethodReference> sinkFilter) {
        this.cha = cha;
        this.langServices = langServices;
        this.fastLangServices = fast_lang_services;
        this.discovered = new VariableRegistry(this.cha);
        this.explored = new VariableRegistry(this.cha);
        this.shortCircuitFilter = this.createShortCircuitFilter();
        this.spec = spec;
        this.sourceFilter = sourceFilter;
        this.sinkFilter = sinkFilter;
    }

    private Filter<Pair<Variable, SSAAbstractInvokeInstruction>> createShortCircuitFilter() {
        return new Filter<Pair<Variable, SSAAbstractInvokeInstruction>>(){

            public boolean accepts(Pair<Variable, SSAAbstractInvokeInstruction> pair) {
                Variable v = (Variable)pair.fst;
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)pair.snd;
                MethodReference mr = invoke.getDeclaredTarget();
                Set useIndices = FlowAnalyzer.this.getUseIndices((SSAInstruction)invoke, v.getVarID());
                if (useIndices.size() == 1) {
                    int useIndex = (Integer)useIndices.iterator().next();
                    boolean isInit = mr.isInit();
                    boolean isCollection = false;
                    if (FlowAnalyzer.this.langServices.getLanguage().equals(Language.JAVA)) {
                        isCollection = FlowAnalyzer.this.cha.getLeastCommonSuperclass(mr.getDeclaringClass(), TypeReference.JavaUtilCollection).getName().equals((Object)TypeReference.JavaUtilCollection.getName());
                    } else {
                        assert (FlowAnalyzer.this.langServices.getLanguage().equals(CLRLanguage.lang));
                        IClass c = FlowAnalyzer.this.cha.lookupClass(mr.getDeclaringClass());
                        if (c != null) {
                            if (FlowAnalyzer.this.systemCollectionsICollection == null) {
                                FlowAnalyzer.this.systemCollectionsICollection = FlowAnalyzer.this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)FlowAnalyzer.SYSTEM_COLLECTIONS_ICOLLECTION));
                            }
                            if (FlowAnalyzer.this.systemCollectionsICollection != null) {
                                isCollection = FlowAnalyzer.this.cha.isAssignableFrom(FlowAnalyzer.this.systemCollectionsICollection, c);
                            }
                        }
                    }
                    if (isCollection && isInit && useIndex == 0) {
                        return true;
                    }
                    boolean isMap = false;
                    if (FlowAnalyzer.this.langServices.getLanguage().equals(Language.JAVA)) {
                        isMap = FlowAnalyzer.this.cha.getLeastCommonSuperclass(mr.getDeclaringClass(), TypeReference.JavaUtilMap).getName().equals((Object)TypeReference.JavaUtilMap.getName());
                    } else {
                        assert (FlowAnalyzer.this.langServices.getLanguage().equals(CLRLanguage.lang));
                        IClass c = FlowAnalyzer.this.cha.lookupClass(mr.getDeclaringClass());
                        if (c != null) {
                            if (FlowAnalyzer.this.systemCollectionsIDictionary == null) {
                                FlowAnalyzer.this.systemCollectionsIDictionary = FlowAnalyzer.this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)FlowAnalyzer.SYSTEM_COLLECTIONS_IDICTIONARY));
                            }
                            if (FlowAnalyzer.this.systemCollectionsIDictionary != null) {
                                isMap = FlowAnalyzer.this.cha.isAssignableFrom(FlowAnalyzer.this.systemCollectionsIDictionary, c);
                            }
                        }
                    }
                    if (isMap && isInit && useIndex == 0) {
                        return true;
                    }
                    List<FieldReference> accessPath = v.getAccessPath();
                    if ((accessPath == null || accessPath.size() == 1 && accessPath.contains(Variable.DOT_STAR)) && isInit && useIndex == 0) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private Collection<IMethod> getLiveTargets(IMethod caller, CallSiteReference site) {
        HashSet result = HashSetFactory.make();
        CGNode n = this.cg.getNode(caller, (Context)Everywhere.EVERYWHERE);
        if (n != null) {
            Set<CGNode> possibleTargets = this.cg.getPossibleTargets(n, site);
            for (CGNode possibleTarget : possibleTargets) {
                result.add(possibleTarget.getMethod());
            }
        }
        return result;
    }

    private Collection<IMethod> getPossibleTargets(IMethod caller, CallSiteReference site) {
        IClass concreteResolution;
        Integer receiver;
        Collection<IMethod> result = null;
        MethodReference mr = site.getDeclaredTarget();
        IClass k = this.cha.lookupClass(mr.getDeclaringClass());
        if (k != null && (receiver = this.getReceiver(caller, site)) != null && (concreteResolution = this.concreteResolutions.get(Pair.make((Object)caller, (Object)receiver))) != null) {
            result = Collections.singleton(concreteResolution.getMethod(mr.getSelector()));
        }
        if (result == null) {
            result = this.getLiveTargets(caller, site);
        }
        for (IMethod m : result) {
            Set<SummaryCache.TaintRelation> summary = SummaryCache.soleInstance().getMethodSummary(m);
            if (summary == null) continue;
            HashSet clone = HashSetFactory.make(summary);
            for (SummaryCache.TaintRelation tr : clone) {
                Set<Pair<Variable, Variable>> callerLevelConstraints = tr.apply(caller, site);
                for (Pair<Variable, Variable> callerLevelConstraint : callerLevelConstraints) {
                    this.recordFlow((Variable)callerLevelConstraint.fst, (Variable)callerLevelConstraint.snd, new PartialPropagationWitness(m, (Context)Everywhere.EVERYWHERE));
                }
            }
        }
        return result;
    }

    private Integer getReceiver(IMethod m, CallSiteReference site) {
        IR ir = TaintAnalysisCache.soleInstance().getIR(m);
        if (ir != null) {
            SSAAbstractInvokeInstruction call;
            SSAAbstractInvokeInstruction[] calls;
            try {
                calls = ir.getCalls(site);
            }
            catch (IllegalArgumentException e) {
                calls = null;
            }
            if (calls != null && calls.length == 1 && !(call = calls[0]).isStatic()) {
                return call.getUse(0);
            }
        }
        return null;
    }

    private boolean isSource(MethodReference mr) {
        return this.sourceFilter.accepts((Object)mr);
    }

    private boolean isSink(MethodReference mr) {
        return this.sinkFilter.accepts((Object)mr);
    }

    public Set<SummaryCache.TaintRelation> summarizeTaintPropagation(IMethod m, List<IClass> pointerAnalysis) throws InvalidClassFileException, ClassHierarchyException {
        this.init(m);
        this.addSeedsAndSolve(m, pointerAnalysis);
        return this.computeTaintRelations(m);
    }

    private Set<SummaryCache.TaintRelation> computeTaintRelations(IMethod m) {
        HashSet result = SummaryCache.soleInstance().getMethodSummary(m);
        if (result == null) {
            result = HashSetFactory.make();
        }
        Collection<List<Variable>> paths = TaintGraphUtils.solve(this.propagationGraph, this.seeds);
        for (List<Variable> l : paths) {
            if (l == null || l.size() <= 0) continue;
            SummaryCache.UnconditionalEffectRelation uer = SummaryCache.UnconditionalEffectRelation.create(SummaryCache.TaintFact.extractTaintFact(l.get(0)), l.get(l.size() - 1), this.fastLangServices);
            result.add(uer);
        }
        return result;
    }

    private void addSeedsAndSolve(IMethod m, List<IClass> pointerAnalysis) throws InvalidClassFileException {
        this.addSeeds(m, pointerAnalysis);
        this.solve();
    }

    private void solve() throws InvalidClassFileException {
        HashSet discovered = HashSetFactory.make();
        for (Variable element : this.dependenceMap.getElements()) {
            discovered.add(element);
        }
        this.solve(discovered, false);
        this.logDebugHook();
        this.destroy();
    }

    private void addSeeds(IMethod m, List<IClass> pointerAnalysis) {
        this.addSeedsFromSourceCalls();
        this.addSeedsFromParameters(m, pointerAnalysis);
    }

    private void addSeedsFromSourceCalls() {
        for (CGNode n : this.cg) {
            IMethod m = n.getMethod();
            if (this.spec.hasSpecForMethod(m)) continue;
            Collection callSiteReferences = null;
            try {
                callSiteReferences = CodeScanner.getCallSites((IMethod)m);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                // empty catch block
            }
            if (callSiteReferences == null) continue;
            for (CallSiteReference cs : callSiteReferences) {
                MethodReference declaredTarget = cs.getDeclaredTarget();
                if (!this.isSource(declaredTarget)) continue;
                IR ir = TaintAnalysisCache.soleInstance().getIR(n);
                for (SSAAbstractInvokeInstruction invoke : ir.getCalls(cs)) {
                    int varID = invoke.getDef();
                    Variable v = Variable.failOrCreate(m, varID, declaredTarget.getReturnType().isPrimitiveType() ? null : Variable.dotStarAccessPath(), this.fastLangServices);
                    this.addSeed(v);
                }
            }
        }
    }

    private void addSeed(Variable v) {
        this.dependenceMap.registerElement(v);
        this.seeds.add(v);
    }

    private void addSeedsFromParameters(IMethod m, List<IClass> pointerAnalysis) {
        for (int i = 0; i < m.getNumberOfParameters(); ++i) {
            Variable v;
            IClass concrete = pointerAnalysis.get(i);
            if (concrete == null) {
                v = Variable.failOrCreate(m, i + 1, null, this.fastLangServices);
                this.addSeed(v);
                continue;
            }
            this.concreteResolutions.put((Pair<IMethod, Integer>)Pair.make((Object)m, (Object)(i + 1)), concrete);
            if (concrete instanceof ArrayClass) {
                v = Variable.failOrCreate(m, i + 1, Variable.dotStarAccessPath(), this.fastLangServices);
                this.addSeed(v);
                continue;
            }
            if (this.langServices.getLanguage().isStringType(concrete.getReference())) {
                v = Variable.failOrCreate(m, i + 1, Variable.dotStarAccessPath(), this.fastLangServices);
                this.addSeed(v);
                continue;
            }
            for (IField f : concrete.getAllFields()) {
                ArrayList<FieldReference> accessPath = new ArrayList<FieldReference>(1);
                accessPath.add(f.getReference());
                if (!f.getFieldTypeReference().isPrimitiveType()) {
                    accessPath.addAll(Variable.dotStarAccessPath());
                }
                Variable v2 = Variable.failOrCreate(m, i + 1, accessPath, this.fastLangServices);
                this.addSeed(v2);
            }
        }
    }

    private void init(final IMethod m) {
        this.cg = new SummaryCallGraph(m.getClassHierarchy(), new IEntrypointLocator(){

            @Override
            public Set<IMethod> locateEntrypoints(IClassHierarchy cha) {
                return Collections.singleton(m);
            }
        }, this.spec, this.langServices, new AnalysisCache(), AccuracyLevel.getDefaultSummaryLevel(), new TICallGraph.VirtualResolutionOptions(3, 1, true, true, true));
        TaintAnalysisCache.setCallGraph(this.cg);
        this.explored.clear();
        this.discovered.clear();
        SummaryCache.soleInstance().invalidateAll();
        this.dependenceMap.clear();
        this.seeds.clear();
    }

    private void destroy() {
        this.cg = null;
    }

    private void logDebugHook() {
    }

    private String prettyPrint(Variable variable) {
        StringBuilder result = new StringBuilder();
        result.append(variable.getVarID());
        if (variable.getAccessPath() != null) {
            result.append('.');
            for (int index = 0; index < variable.getAccessPath().size(); ++index) {
                FieldReference fr = variable.getAccessPath().get(index);
                if (fr == null) continue;
                result.append(fr.equals((Object)Variable.DOT_STAR) ? Character.valueOf('*') : fr.getName().toString());
                if (index >= variable.getAccessPath().size() - 1) continue;
                result.append('.');
            }
        }
        return result.toString();
    }

    public RawAnalysisResult run() throws InvalidClassFileException {
        SummaryCache.soleInstance().invalidateAll();
        HashSet discovered = HashSetFactory.make();
        for (Variable element : this.dependenceMap.getElements()) {
            discovered.add(element);
        }
        this.solve(discovered, false);
        return new RawAnalysisResult(this.propagationGraph, this.supportGraph, this.seeds);
    }

    private void solve(Set<Variable> worklist, boolean allowOnlineModels) throws InvalidClassFileException {
        int MAX_WORKLIST_SIZE_THRESHOLD = 100;
        int MIN_WORKLIST_SIZE_THRESHOLD = 10;
        HashSet blocked = HashSetFactory.make();
        Set<Variable> initialBlocked = this.guessSubset(worklist, worklist.size() - 100);
        blocked.addAll(initialBlocked);
        worklist.removeAll(initialBlocked);
        while (!worklist.isEmpty()) {
            assert (worklist.size() <= 100);
            Iterator<Variable> iter = worklist.iterator();
            worklist = HashSetFactory.make();
            while (iter.hasNext()) {
                Set<Variable> dependentsOnCurrent;
                Variable current = iter.next();
                if (this.analyze(current, allowOnlineModels) && (dependentsOnCurrent = this.dependenceMap.getDependents(current)) != null) {
                    Set<Variable> subset = this.guessSubset(dependentsOnCurrent, 100 - worklist.size());
                    worklist.addAll(subset);
                    dependentsOnCurrent.removeAll(subset);
                    blocked.addAll(dependentsOnCurrent);
                }
                if (worklist.size() > 10) continue;
                Set<Variable> subset = this.guessSubset(blocked, 100 - worklist.size());
                worklist.addAll(subset);
                blocked.removeAll(subset);
            }
        }
    }

    private Set<Variable> guessSubset(Set<Variable> set, int size) {
        if (size <= 0) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        Iterator<Variable> iter = set.iterator();
        while (iter.hasNext() && size > 0) {
            result.add(iter.next());
            --size;
        }
        return result;
    }

    private boolean analyze(Variable variable, boolean allowOnlineModels) throws InvalidClassFileException {
        this.discovered.clear();
        if (!this.explored.contains(variable)) {
            this.explored.add(variable);
            this.propagationGraph.addNode((Object)variable);
            if (!(variable instanceof ViolationVariable) && !(variable instanceof DeadEndVariable)) {
                this.analyzeVariable(variable, allowOnlineModels);
                Set<Variable> waitingVariables = this.waitingList.get(variable);
                if (waitingVariables != null) {
                    this.discovered.addAll(waitingVariables);
                    this.waitingList.remove(variable);
                }
                for (Variable v : this.discovered) {
                    this.dependenceMap.registerDependence(variable, v);
                }
            }
        }
        return this.discovered.size() > 0;
    }

    private void analyzeVariable(Variable variable, boolean allowOnlineModels) throws InvalidClassFileException {
        block27: {
            IMethod m;
            block28: {
                block26: {
                    m = variable.getMethod();
                    if (!this.spec.hasSpecForMethod(m)) break block26;
                    this.applyOfflineSummary(variable);
                    break block27;
                }
                if (!this.propagationPolicy.allowsOnlineModels() || !SummaryCache.soleInstance().hasSummary(variable)) break block28;
                Set<SummaryCache.TaintRelation> summary = SummaryCache.soleInstance().getSummary(variable);
                HashMap summarizedEffects = HashMapFactory.make();
                for (SummaryCache.TaintRelation relation : summary) {
                    Pair<Variable, Variable> outcome = relation.instantiate(variable.getMethod());
                    Set varEffects = MapUtil.findOrCreateSet((Map)summarizedEffects, (Object)outcome.fst);
                    varEffects.add(outcome.snd);
                    if (!relation.hasSideEffects()) continue;
                    this.summarizeConstraintsForSideEffect((Variable)outcome.fst, (Variable)outcome.snd);
                }
                for (Variable cause : summarizedEffects.keySet()) {
                    if (!this.fastLangServices.isParameter(cause)) continue;
                    this.recordSummaryConstraintsOnCallSites(m, cause, (Set)summarizedEffects.get(cause));
                }
                break block27;
            }
            DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, variable.getContext());
            if (du == null) break block27;
            Iterator instrIter = du.getUses(variable.getVarID());
            while (instrIter.hasNext()) {
                Object accessPathSuffix;
                List<FieldReference> accessPath;
                SSAInstruction instr = (SSAInstruction)instrIter.next();
                if (instr instanceof SSAGetInstruction) {
                    SSAGetInstruction get = (SSAGetInstruction)instr;
                    accessPath = variable.getAccessPath();
                    if (accessPath == null || accessPath.size() <= 0 || !Variable.areFieldReferencesCompatible(accessPath.get(0), get.getDeclaredField(), this.cha)) continue;
                    accessPathSuffix = Variable.getAccessPathSegment(accessPath, 1);
                    Variable defVar = Variable.failOrCreate(m, get.getDef(), (List<FieldReference>)accessPathSuffix, this.fastLangServices);
                    this.recordFlow(variable, defVar, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                    continue;
                }
                if (instr instanceof SSAPutInstruction) {
                    SSAPutInstruction put = (SSAPutInstruction)instr;
                    if (put.isStatic()) {
                        Set<Variable> getVars = this.getStaticGetFieldVars(put.getDeclaredField(), variable.getAccessPath());
                        for (Variable getVar : getVars) {
                            this.recordFlow(variable, getVar, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                        }
                        continue;
                    }
                    accessPath = variable.getAccessPath();
                    accessPathSuffix = this.getUseIndices(instr, variable.getVarID()).iterator();
                    while (accessPathSuffix.hasNext()) {
                        int useIndex = (Integer)accessPathSuffix.next();
                        if (useIndex == 1) {
                            this.accountForRecursiveDataStructure(variable, put);
                            ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(accessPath == null ? 1 : accessPath.size() + 1);
                            effectAccessPath.add(put.getDeclaredField());
                            if (accessPath != null) {
                                effectAccessPath.addAll(accessPath);
                            }
                            int refVarID = put.getRef();
                            Variable refVar = Variable.failOrCreate(m, refVarID, effectAccessPath, this.fastLangServices);
                            BasicPropagationWitness witness = new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr);
                            this.recordFlow(variable, refVar, witness);
                            this.summarizeConstraintsForSideEffect(variable, refVar);
                            continue;
                        }
                        assert (useIndex == 0);
                    }
                    continue;
                }
                if (this.canEnforceArrayLoadSemantics(instr)) {
                    if (instr instanceof SSAArrayLoadInstruction) {
                        this.handleArrayLoadPropagation(variable, (SSAArrayLoadInstruction)instr);
                        continue;
                    }
                    this.handleFakeArrayLoadPropagation(variable, (SSAAbstractInvokeInstruction)instr);
                    continue;
                }
                if (this.canEnforceArrayStoreSemantics(instr)) {
                    if (instr instanceof SSAArrayStoreInstruction) {
                        this.handleArrayStorePropagation(variable, (SSAArrayStoreInstruction)instr);
                        continue;
                    }
                    this.handleFakeArrayStorePropagation(variable, (SSAAbstractInvokeInstruction)instr);
                    continue;
                }
                if (instr instanceof SSAAbstractInvokeInstruction) {
                    SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instr;
                    MethodReference mr = invoke.getDeclaredTarget();
                    if (this.isSource(mr)) continue;
                    if (this.isSink(mr)) {
                        MethodReference sinkMR = invoke.getDeclaredTarget();
                        IClass sinkClass = this.cha.lookupClass(sinkMR.getDeclaringClass());
                        IMethod sinkMethod = sinkClass.getMethod(sinkMR.getSelector());
                        for (int useIndex : this.getUseIndices((SSAInstruction)invoke, variable.getVarID())) {
                            this.recordFlow(variable, ViolationVariable.failOrCreate(invoke.getCallSite(), sinkMethod, null, useIndex + 1, variable.getAccessPath()), new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                        }
                        continue;
                    }
                    if (this.shortCircuitFilter.accepts((Object)Pair.make((Object)variable, (Object)invoke))) continue;
                    IMethod declaredTarget = this.cha.resolveMethod(invoke.getCallSite().getDeclaredTarget());
                    Collection<IMethod> possibleTargets = this.getPossibleTargets(variable.getMethod(), invoke.getCallSite());
                    if (declaredTarget != null && this.spec.hasSpecForMethod(declaredTarget)) {
                        this.actualToFormals(variable, invoke, declaredTarget);
                        continue;
                    }
                    for (IMethod possibleTarget : possibleTargets) {
                        if (possibleTarget == null) continue;
                        this.actualToFormals(variable, invoke, possibleTarget);
                    }
                    continue;
                }
                if (instr instanceof SSAAbstractUnaryInstruction) {
                    this.recordFlow(variable, Variable.failOrCreate(variable.getMethod(), instr.getDef(), variable.getAccessPath(), this.fastLangServices), new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                    continue;
                }
                if (instr instanceof SSAAbstractThrowInstruction || instr instanceof SSAArrayLengthInstruction || instr instanceof ReflectiveMemberAccess) continue;
                if (instr instanceof SSABinaryOpInstruction) {
                    this.recordFlow(variable, Variable.failOrCreate(variable.getMethod(), instr.getDef(), variable.getAccessPath(), this.fastLangServices), new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                    continue;
                }
                if (instr instanceof SSACheckCastInstruction) {
                    this.recordFlow(variable, Variable.failOrCreate(variable.getMethod(), instr.getDef(), variable.getAccessPath(), this.fastLangServices), new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                    continue;
                }
                if (instr instanceof SSAComparisonInstruction || instr instanceof SSAConditionalBranchInstruction) continue;
                if (instr instanceof SSAConversionInstruction) {
                    this.recordFlow(variable, Variable.failOrCreate(variable.getMethod(), instr.getDef(), variable.getAccessPath(), this.fastLangServices), new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                    continue;
                }
                if (instr instanceof SSAGetCaughtExceptionInstruction || instr instanceof SSAGotoInstruction || instr instanceof SSAInstanceofInstruction || instr instanceof SSALoadMetadataInstruction || instr instanceof SSAMonitorInstruction || instr instanceof SSANewInstruction) continue;
                if (instr instanceof SSAPhiInstruction) {
                    this.recordFlow(variable, Variable.failOrCreate(variable.getMethod(), instr.getDef(), variable.getAccessPath(), this.fastLangServices), new BasicPropagationWitness(variable.getMethod(), variable.getContext(), instr));
                    continue;
                }
                if (instr instanceof SSAReturnInstruction) {
                    this.summarizeConstraintsForReturn(variable);
                    continue;
                }
                if (!(instr instanceof SSASwitchInstruction)) continue;
            }
        }
    }

    private Set<Variable> getReturnedVariables(IMethod m, List<FieldReference> accessPath) {
        IR ir = TaintAnalysisCache.soleInstance().getIR(m);
        if (ir == null) {
            return null;
        }
        HashSet result = HashSetFactory.make();
        for (SSAInstruction i : ir.getInstructions()) {
            if (!(i instanceof SSAReturnInstruction)) continue;
            result.add(Variable.failOrCreate(m, i.getUse(0), accessPath, this.fastLangServices));
        }
        return result;
    }

    private void actualToFormals(Variable variable, SSAAbstractInvokeInstruction invoke, IMethod target) {
        Map imageOfTarget = MapUtil.findOrCreateMap(this.formalToActualParameters, (Object)target);
        for (int useIndex : this.getUseIndices((SSAInstruction)invoke, variable.getVarID())) {
            Variable effect = Variable.failOrCreate(target, useIndex + 1, variable.getAccessPath(), this.fastLangServices);
            Set imageOfFormalParameter = MapUtil.findOrCreateSet((Map)imageOfTarget, (Object)effect);
            imageOfFormalParameter.add(variable);
            this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
        }
    }

    private void applyOfflineSummary(Variable variable) {
        Set<Variable> summarizedEffects = this.spec.getSummary(variable, this.fastLangServices);
        if (summarizedEffects != null) {
            IMethod m = variable.getMethod();
            assert (this.fastLangServices.isParameter(variable));
            HashSet summarizedConditionalEffects = HashSetFactory.make();
            for (Variable effect : summarizedEffects) {
                if (this.areMethodsCompatible(variable.getMethod(), effect.getMethod())) {
                    summarizedConditionalEffects.add(effect);
                    continue;
                }
                assert (effect instanceof ViolationVariable) : "ERROR: expected unconditional effect to be a violation variable!";
                if (!this.sinkFilter.accepts((Object)effect.getMethodRef())) continue;
                this.recordFlow(variable, effect, new SummaryPropagationWitness(variable.getMethod(), variable.getContext(), effect.getMethod()));
            }
            this.recordSummaryConstraintsOnCallSites(m, variable, summarizedConditionalEffects);
            for (Variable effect : summarizedConditionalEffects) {
                if (!this.spec.createsSideEffectsOnTarget(variable, effect)) continue;
                this.summarizeConstraintsForSideEffect(variable, effect);
            }
        }
    }

    private void accountForRecursiveDataStructure(Variable variable, SSAPutInstruction put) {
        TypeReference fieldDeclarerType = Variable.getVariableType(Variable.failOrCreate(variable.getMethod(), put.getUse(0), variable.getAccessPath(), this.fastLangServices), this.fastLangServices);
        if (fieldDeclarerType != null) {
            FieldReference declaredField = put.getDeclaredField();
            if (fieldDeclarerType.getName().equals((Object)declaredField.getFieldType().getName())) {
                List<FieldReference> varAccessPath = variable.getAccessPath();
                ArrayList<FieldReference> newAccessPath = new ArrayList<FieldReference>(varAccessPath == null ? 1 : varAccessPath.size() + 1);
                newAccessPath.add(declaredField);
                if (varAccessPath != null) {
                    newAccessPath.addAll(varAccessPath);
                }
                Variable effect = Variable.failOrCreate(variable.getMethod(), put.getUse(0), newAccessPath, this.fastLangServices);
                BasicPropagationWitness witness = new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)put);
                this.recordFlow(variable, effect, witness);
                this.summarizeConstraintsForSideEffect(variable, effect);
            }
        }
    }

    private void summarizeConstraintsForSideEffect(Variable cause, Variable effect) {
        Timing.i().startedSection(TimedSection.SideEffectPropagation);
        Set witnesses = this.propagationGraph.getEdgeLabels((Object)cause, (Object)effect);
        IPropagationWitness witness = witnesses.size() > 0 ? (IPropagationWitness)witnesses.iterator().next() : new PartialPropagationWitness(cause.getMethod(), cause.getContext());
        Set<Variable> taintAncestors = this.findTaintAncestors(cause);
        Set<Variable> ancestors = this.findAncestors(effect);
        HashSet worklist = HashSetFactory.make();
        HashSet handled = HashSetFactory.make();
        for (Variable taintAncestor : taintAncestors) {
            for (Variable ancestor : ancestors) {
                this.supportGraph.addSupport(new ISupportGraph.BinaryFact(cause, effect), new ISupportGraph.BinaryFact(taintAncestor, ancestor));
                worklist.add(Pair.make((Object)taintAncestor, (Object)ancestor));
            }
        }
        while (!worklist.isEmpty()) {
            Iterator iter = worklist.iterator();
            worklist = HashSetFactory.make();
            while (iter.hasNext()) {
                Pair newPair;
                Variable callSiteCause;
                boolean newlyExamined;
                Variable ancestor;
                Pair current = (Pair)iter.next();
                handled.add(current);
                Variable taintAncestor = (Variable)current.fst;
                ancestor = (Variable)current.snd;
                if (taintAncestor == null || ancestor == null || !(newlyExamined = this.history.add((Pair<Variable, Variable>)Pair.make((Object)taintAncestor, (Object)ancestor)))) continue;
                boolean isTaintAncestorParameter = this.fastLangServices.isParameter(taintAncestor);
                boolean isAncestorParameter = this.fastLangServices.isParameter(ancestor);
                if (isAncestorParameter && isTaintAncestorParameter) {
                    assert (this.areMethodsCompatible(ancestor.getMethod(), taintAncestor.getMethod()));
                    SummaryCache.soleInstance().summarizeConditionalConstraintForSideEffect(ancestor.getMethod(), taintAncestor.getVarID(), taintAncestor.getAccessPath(), ancestor.getVarID(), ancestor.getAccessPath(), this.fastLangServices);
                    for (Pair<IMethod, SSAAbstractInvokeInstruction> call : this.getCalls(ancestor.getMethod())) {
                        callSiteCause = Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getUse(taintAncestor.getVarID() - 1), taintAncestor.getAccessPath(), this.fastLangServices);
                        Variable callSiteEffect = Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getUse(ancestor.getVarID() - 1), ancestor.getAccessPath(), this.fastLangServices);
                        this.recordFlow(callSiteCause, callSiteEffect, new BasicPropagationWitness(callSiteCause.getMethod(), callSiteCause.getContext(), (SSAInstruction)call.snd));
                        this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(callSiteCause, callSiteEffect));
                        Set<Variable> callSiteCauseTaintAncestors = this.findTaintAncestors(callSiteCause);
                        Set<Variable> callSiteEffectAncestors = this.findAncestors(callSiteEffect);
                        for (Variable callSiteCauseTaintAncestor : callSiteCauseTaintAncestors) {
                            for (Variable callSiteEffectAncestor : callSiteEffectAncestors) {
                                Pair newPair2 = Pair.make((Object)callSiteCauseTaintAncestor, (Object)callSiteEffectAncestor);
                                if (handled.contains(newPair2)) continue;
                                worklist.add(newPair2);
                            }
                        }
                    }
                    continue;
                }
                if (isAncestorParameter && !isTaintAncestorParameter) {
                    for (Pair<IMethod, SSAAbstractInvokeInstruction> call : this.getCalls(ancestor.getMethod())) {
                        Variable callSiteEffect = Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getUse(ancestor.getVarID() - 1), ancestor.getAccessPath(), this.fastLangServices);
                        this.recordFlow(taintAncestor, callSiteEffect, new TransitivePropagationWitness(witness));
                        this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(taintAncestor, callSiteEffect));
                        SummaryCache.soleInstance().summarizeUnconditionalConstraintForSideEffect(taintAncestor, ancestor.getMethod(), ancestor.getVarID(), ancestor.getAccessPath(), this.fastLangServices);
                        Set<Variable> callSiteEffectAncestors = this.findAncestors(callSiteEffect);
                        for (Variable callSiteEffectAncestor : callSiteEffectAncestors) {
                            newPair = Pair.make((Object)taintAncestor, (Object)callSiteEffectAncestor);
                            if (handled.contains(newPair)) continue;
                            worklist.add(newPair);
                        }
                    }
                    continue;
                }
                if (!isAncestorParameter && isTaintAncestorParameter) {
                    for (Pair<IMethod, SSAAbstractInvokeInstruction> call : this.getCalls(taintAncestor.getMethod())) {
                        callSiteCause = Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getUse(taintAncestor.getVarID() - 1), taintAncestor.getAccessPath(), this.fastLangServices);
                        this.recordFlow(callSiteCause, ancestor, new BasicPropagationWitness(callSiteCause.getMethod(), callSiteCause.getContext(), (SSAInstruction)call.snd));
                        this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(callSiteCause, ancestor));
                        Set<Variable> callSiteCauseTaintAncestors = this.findTaintAncestors(callSiteCause);
                        for (Variable callSiteCauseTaintAncestor : callSiteCauseTaintAncestors) {
                            newPair = Pair.make((Object)callSiteCauseTaintAncestor, (Object)ancestor);
                            if (handled.contains(newPair)) continue;
                            worklist.add(newPair);
                        }
                        this.accountForTaintOnStaticField(callSiteCause, ancestor);
                    }
                    continue;
                }
                this.recordFlow(taintAncestor, ancestor, new TransitivePropagationWitness(witness));
                this.accountForTaintOnStaticField(taintAncestor, ancestor);
            }
        }
        Timing.i().finishedSection(TimedSection.SideEffectPropagation);
    }

    private boolean areMethodsCompatible(IMethod method1, IMethod method2) {
        if (method1.getSelector().equals((Object)method2.getSelector())) {
            IClass c2;
            IClass c1 = method1.getDeclaringClass();
            if (this.cha.isAssignableFrom(c1, c2 = method2.getDeclaringClass())) {
                return true;
            }
            if (this.cha.isAssignableFrom(c2, c1)) {
                return true;
            }
        }
        return false;
    }

    private void summarizeConstraintsForReturn(Variable variable) {
        IMethod varMethod = variable.getMethod();
        List<FieldReference> varAccessPath = variable.getAccessPath();
        Set<Variable> taintAncestors = this.findTaintAncestors(variable);
        Set<Pair<IMethod, SSAAbstractInvokeInstruction>> calls = this.getCalls(variable.getMethod());
        for (Variable taintAncestor : taintAncestors) {
            boolean isTaintAncestorParameter = this.fastLangServices.isParameter(taintAncestor);
            if (isTaintAncestorParameter) {
                SummaryCache.soleInstance().summarizeConditionalConstraintForReturn(varMethod, taintAncestor.getVarID(), taintAncestor.getAccessPath(), varAccessPath, this.fastLangServices);
            } else {
                SummaryCache.soleInstance().summarizeUnconditionalConstraintForReturn(taintAncestor, varMethod, varAccessPath, this.fastLangServices);
            }
            for (Pair<IMethod, SSAAbstractInvokeInstruction> call : calls) {
                Variable effect = Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getDef(), variable.getAccessPath(), this.fastLangServices);
                Variable cause = isTaintAncestorParameter ? Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getUse(taintAncestor.getVarID() - 1), taintAncestor.getAccessPath(), this.fastLangServices) : taintAncestor;
                this.recordFlow(cause, effect, new BasicPropagationWitness(cause.getMethod(), cause.getContext(), (SSAInstruction)call.snd));
                this.supportGraph.addSupport(new ISupportGraph.UnaryFact(variable), new ISupportGraph.BinaryFact(cause, effect));
            }
        }
    }

    private void accountForTaintOnStaticField(Variable taintAncestor, Variable ancestor) {
        if (Variable.isStaticField(ancestor) && taintAncestor != null && ancestor != null) {
            DefUse du = TaintAnalysisCache.soleInstance().getDefUse(ancestor.getMethod(), ancestor.getContext());
            SSAGetInstruction getInstr = (SSAGetInstruction)du.getDef(ancestor.getVarID());
            for (Variable otherStaticGet : this.getStaticGetFieldVars(getInstr.getDeclaredField(), ancestor.getAccessPath())) {
                Set labels = this.propagationGraph.getEdgeLabels((Object)taintAncestor, (Object)ancestor);
                if (labels.size() > 0) {
                    this.recordFlow(taintAncestor, otherStaticGet, (IPropagationWitness)labels.iterator().next());
                } else {
                    this.recordFlow(taintAncestor, otherStaticGet, NullPropagationWitness.soleInstance());
                }
                this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(taintAncestor, otherStaticGet));
            }
        }
    }

    private Set<Variable> findTaintAncestors(Variable variable) {
        final IMethod varMethod = variable.getMethod();
        Filter<Variable> filter = new Filter<Variable>(){

            public boolean accepts(Variable v) {
                SSAGetInstruction getInstr;
                SSAAbstractInvokeInstruction invoke;
                SSAInstruction defInstr;
                IMethod m = v.getMethod();
                if (FlowAnalyzer.this.fastLangServices.isParameter(v) && m.equals(varMethod)) {
                    return true;
                }
                DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, v.getContext());
                int vID = v.getVarID();
                return du != null && ((defInstr = du.getDef(vID)) instanceof SSAAbstractInvokeInstruction ? FlowAnalyzer.this.isSource((invoke = (SSAAbstractInvokeInstruction)defInstr).getDeclaredTarget()) : defInstr instanceof SSAGetInstruction && (getInstr = (SSAGetInstruction)defInstr).isStatic());
            }
        };
        if (filter.accepts((Object)variable)) {
            HashSet result = HashSetFactory.make();
            result.add(variable);
            return result;
        }
        Graph<Variable> inverseGraph = new Graph<Variable>(){

            public void removeNodeAndEdges(Variable N) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void addNode(Variable n) {
                Assertions.UNREACHABLE();
            }

            public boolean containsNode(Variable N) {
                return FlowAnalyzer.this.propagationGraph.containsNode((Object)N);
            }

            public int getNumberOfNodes() {
                return FlowAnalyzer.this.propagationGraph.getNumberOfNodes();
            }

            public Iterator<Variable> iterator() {
                return FlowAnalyzer.this.propagationGraph.iterator();
            }

            public void removeNode(Variable n) {
                Assertions.UNREACHABLE();
            }

            public void addEdge(Variable src, Variable dst) {
                Assertions.UNREACHABLE();
            }

            public int getPredNodeCount(Variable N) {
                return FlowAnalyzer.this.propagationGraph.getSuccNodeCount((Object)N);
            }

            public Iterator<Variable> getPredNodes(Variable N) {
                return FlowAnalyzer.this.propagationGraph.getSuccNodes((Object)N);
            }

            public int getSuccNodeCount(Variable N) {
                return FlowAnalyzer.this.propagationGraph.getPredNodeCount((Object)N);
            }

            public Iterator<Variable> getSuccNodes(Variable N) {
                return FlowAnalyzer.this.propagationGraph.getPredNodes((Object)N);
            }

            public boolean hasEdge(Variable src, Variable dst) {
                return FlowAnalyzer.this.propagationGraph.hasEdge((Object)dst, (Object)src);
            }

            public void removeAllIncidentEdges(Variable node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeEdge(Variable src, Variable dst) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeIncomingEdges(Variable node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeOutgoingEdges(Variable node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }
        };
        return BFSPathsFinder.findPathsFromMultipleSources(inverseGraph, Collections.singleton(variable), filter, true).keySet();
    }

    private Set<Variable> findAncestors(Variable variable) {
        HashSet result = HashSetFactory.make();
        if (this.fastLangServices.isParameter(variable)) {
            result.add(variable);
        } else {
            HashSet worklist = HashSetFactory.make();
            HashSet handled = HashSetFactory.make();
            HashSet visitedMethods = HashSetFactory.make();
            worklist.add(variable);
            visitedMethods.add(variable.getMethod());
            while (!worklist.isEmpty()) {
                Iterator iter = worklist.iterator();
                worklist = HashSetFactory.make();
                while (iter.hasNext()) {
                    Variable newVar;
                    Variable current = (Variable)iter.next();
                    handled.add(current);
                    IMethod curMethod = current.getMethod();
                    DefUse du = TaintAnalysisCache.soleInstance().getDefUse(curMethod);
                    if (du == null) continue;
                    SymbolTable sb = TaintAnalysisCache.soleInstance().getIR(curMethod).getSymbolTable();
                    SSAInstruction defInstr = du.getDef(current.getVarID());
                    if (defInstr == null) {
                        if (!this.fastLangServices.isParameter(current)) continue;
                        if (curMethod.equals(variable.getMethod())) {
                            result.add(current);
                            continue;
                        }
                        Set<Pair<IMethod, SSAAbstractInvokeInstruction>> calls = this.getCalls(curMethod);
                        for (Pair<IMethod, SSAAbstractInvokeInstruction> call : calls) {
                            if (!visitedMethods.contains(call.fst) || (newVar = Variable.failOrCreate((IMethod)call.fst, ((SSAAbstractInvokeInstruction)call.snd).getUse(current.getVarID() - 1), current.getAccessPath(), this.fastLangServices)) == null || handled.contains(newVar)) continue;
                            worklist.add(newVar);
                        }
                        continue;
                    }
                    if (defInstr instanceof SSACheckCastInstruction) {
                        Variable newVar2 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this.fastLangServices);
                        if (newVar2 == null || handled.contains(newVar2)) continue;
                        worklist.add(newVar2);
                        continue;
                    }
                    if (defInstr instanceof SSAPhiInstruction) {
                        for (int index = 0; index < defInstr.getNumberOfUses(); ++index) {
                            Variable newVar3 = Variable.failOrCreate(curMethod, defInstr.getUse(index), current.getAccessPath(), this.fastLangServices);
                            if (newVar3 == null || handled.contains(newVar3)) continue;
                            worklist.add(newVar3);
                        }
                        continue;
                    }
                    if (defInstr instanceof SSAGetInstruction) {
                        Variable newVar4;
                        SSAGetInstruction getInstr = (SSAGetInstruction)defInstr;
                        if (getInstr.isStatic()) {
                            result.add(current);
                            continue;
                        }
                        FieldReference fr = getInstr.getDeclaredField();
                        List<FieldReference> currentAccessPath = current.getAccessPath();
                        ArrayList<FieldReference> newAccessPath = new ArrayList<FieldReference>(currentAccessPath == null ? 1 : currentAccessPath.size() + 1);
                        newAccessPath.add(fr);
                        if (currentAccessPath != null) {
                            newAccessPath.addAll(currentAccessPath);
                        }
                        if ((newVar4 = Variable.failOrCreate(curMethod, defInstr.getUse(0), newAccessPath, this.fastLangServices)) == null || handled.contains(newVar4)) continue;
                        worklist.add(newVar4);
                        continue;
                    }
                    if (defInstr instanceof SSAAbstractUnaryInstruction) {
                        Variable newVar5 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this.fastLangServices);
                        if (newVar5 == null || handled.contains(newVar5)) continue;
                        worklist.add(newVar5);
                        continue;
                    }
                    if (defInstr instanceof SSAArrayLoadInstruction) {
                        FieldReference arrayAccessQualifier;
                        if (sb.isConstant(defInstr.getUse(1))) {
                            int constantIndex = sb.getIntValue(defInstr.getUse(1));
                            arrayAccessQualifier = Variable.getArrayAccessQualifier(constantIndex);
                        } else {
                            arrayAccessQualifier = Variable.ANONYMOUS;
                        }
                        List<FieldReference> currentAccessPath = current.getAccessPath();
                        ArrayList<FieldReference> newAccessPath = new ArrayList<FieldReference>(currentAccessPath == null ? 1 : currentAccessPath.size() + 1);
                        newAccessPath.add(arrayAccessQualifier);
                        if (currentAccessPath != null) {
                            newAccessPath.addAll(currentAccessPath);
                        }
                        if ((newVar = Variable.failOrCreate(curMethod, defInstr.getUse(0), newAccessPath, this.fastLangServices)) == null || handled.contains(newVar)) continue;
                        worklist.add(newVar);
                        continue;
                    }
                    if (defInstr instanceof SSABinaryOpInstruction) {
                        Variable newVar2;
                        Variable newVar1 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this.fastLangServices);
                        if (newVar1 != null && !handled.contains(newVar1)) {
                            worklist.add(newVar1);
                        }
                        if ((newVar2 = Variable.failOrCreate(curMethod, defInstr.getUse(1), current.getAccessPath(), this.fastLangServices)) == null || handled.contains(newVar2)) continue;
                        worklist.add(newVar2);
                        continue;
                    }
                    if (defInstr instanceof SSAConversionInstruction) {
                        Variable newVar6 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this.fastLangServices);
                        if (newVar6 == null || handled.contains(newVar6)) continue;
                        worklist.add(newVar6);
                        continue;
                    }
                    if (defInstr instanceof SSAGetCaughtExceptionInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSALoadMetadataInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSAAddressOfInstruction) continue;
                    if (defInstr instanceof SSAArrayLengthInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSANewInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSAInstanceofInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSAAbstractInvokeInstruction) {
                        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)defInstr;
                        MethodReference declaredTarget = invoke.getDeclaredTarget();
                        if (this.langServices.getLanguage().equals(Language.JAVA) && declaredTarget.equals((Object)CTOR_NEW_INSTANCE)) {
                            result.add(current);
                            continue;
                        }
                        if (this.langServices.getLanguage().equals(CLRLanguage.lang) && declaredTarget.getName().toString().equals("Invoke") && declaredTarget.getDeclaringClass().getName().toString().equals("LSystem/Reflection/ConstructorInfo")) {
                            result.add(current);
                            continue;
                        }
                        Set<Variable> targetReturnVars = this.computeTargetReturnVars(curMethod, invoke.getCallSite(), current.getAccessPath());
                        for (Variable returnVar : targetReturnVars) {
                            if (returnVar == null || handled.contains(returnVar)) continue;
                            visitedMethods.add(returnVar.getMethod());
                            worklist.add(returnVar);
                        }
                        continue;
                    }
                    Assertions.UNREACHABLE((String)("ERROR: did not expect def instruction to be " + defInstr));
                }
            }
        }
        return result;
    }

    private boolean isWellKnownImmutableType(TypeReference t) {
        return this.isPrimitiveOrString(t);
    }

    private boolean isPrimitiveOrString(TypeReference t) {
        if (t.isPrimitiveType()) {
            return true;
        }
        Language l = this.langServices.getLanguage();
        if (l.isStringType(t)) {
            return true;
        }
        if (l.isCharType(t)) {
            return true;
        }
        return l.isBooleanType(t);
    }

    private void handleFakeArrayStorePropagation(Variable variable, SSAAbstractInvokeInstruction invoke) throws InvalidClassFileException {
        int useIndex = this.getUseIndex((SSAInstruction)invoke, variable.getVarID());
        if (useIndex == 0) {
            IR ir = TaintAnalysisCache.soleInstance().getIR(variable.getMethod());
            SymbolTable sb = ir.getSymbolTable();
            if (!this.isWellKnownImmutableType(invoke.getDeclaredTarget().getParameterType(1)) && !sb.isConstant(invoke.getUse(1))) {
                List<FieldReference> accessPath = variable.getAccessPath();
                if (accessPath == null || !Variable.isMapAccessQualifier(accessPath.get(0))) {
                    ErrorLog.i().register("Variable " + variable + " is of type Map, but doesn't have an appropriate access path.");
                    Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getUse(2), accessPath, this.fastLangServices);
                    BasicPropagationWitness witness = new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke);
                    this.recordFlow(variable, effect, witness);
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (accessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(accessPath, 1);
                    Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getUse(2), effectAccessPath, this.fastLangServices);
                    BasicPropagationWitness witness = new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke);
                    this.recordFlow(variable, effect, witness);
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (sb.isConstant(invoke.getUse(1))) {
                    String accessQualifier;
                    String keyName = sb.getStringValue(invoke.getUse(1));
                    if (keyName.equals(accessQualifier = accessPath.get(0).getName().toString())) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(accessPath, 1);
                        Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getUse(2), effectAccessPath, this.fastLangServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
                        this.summarizeConstraintsForSideEffect(variable, effect);
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(accessPath, 1);
                    Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getUse(2), effectAccessPath, this.fastLangServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                }
            }
        } else if (useIndex != 1) {
            assert (useIndex == 2);
            List<FieldReference> accessPath = variable.getAccessPath();
            IR ir = TaintAnalysisCache.soleInstance().getIR(variable.getMethod());
            ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(accessPath == null ? 1 : accessPath.size() + 1);
            SymbolTable sb = ir.getSymbolTable();
            if (sb.isConstant(invoke.getUse(1))) {
                String keyName = sb.getStringValue(invoke.getUse(1));
                effectAccessPath.add(Variable.getMapAccessQualifier(keyName));
            } else {
                effectAccessPath.add(Variable.ANONYMOUS);
            }
            if (accessPath != null) {
                effectAccessPath.addAll(accessPath);
            }
            Variable fakeArrayVar = Variable.failOrCreate(variable.getMethod(), invoke.getUse(0), effectAccessPath, this.fastLangServices);
            this.recordFlow(variable, fakeArrayVar, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
            this.summarizeConstraintsForSideEffect(variable, fakeArrayVar);
        }
    }

    private void handleArrayStorePropagation(Variable variable, SSAArrayStoreInstruction instr) throws InvalidClassFileException {
        int useIndex = this.getUseIndex((SSAInstruction)instr, variable.getVarID());
        IMethod varMethod = variable.getMethod();
        Context varContext = variable.getContext();
        if (useIndex == 0) {
            IR ir = TaintAnalysisCache.soleInstance().getIR(varMethod, varContext);
            SymbolTable sb = ir.getSymbolTable();
            if (!this.isWellKnownImmutableType(instr.getElementType()) && !sb.isConstant(instr.getUse(2))) {
                List<FieldReference> varAccessPath = variable.getAccessPath();
                if (varAccessPath == null || !Variable.isArrayAccessQualifier(varAccessPath.get(0))) {
                    ErrorLog.i().register("Variable " + variable + " is an array, but doesn't have an appropriate access path.");
                    Variable effect = Variable.failOrCreate(varMethod, instr.getUse(2), varAccessPath, this.fastLangServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (varAccessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(varMethod, instr.getUse(2), effectAccessPath, this.fastLangServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (sb.isConstant(instr.getUse(1))) {
                    int accessQualifier;
                    int arrayIndex = sb.getIntValue(instr.getUse(1));
                    if (arrayIndex == (accessQualifier = Integer.parseInt(varAccessPath.get(0).getName().toString()))) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                        Variable effect = Variable.failOrCreate(varMethod, instr.getUse(2), effectAccessPath, this.fastLangServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
                        this.summarizeConstraintsForSideEffect(variable, effect);
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(varMethod, instr.getUse(2), effectAccessPath, this.fastLangServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                }
            }
        } else if (useIndex != 1) {
            assert (useIndex == 2);
            IR ir = TaintAnalysisCache.soleInstance().getIR(varMethod);
            SymbolTable sb = ir.getSymbolTable();
            List<FieldReference> varAccessPath = variable.getAccessPath();
            ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(varAccessPath == null ? 1 : varAccessPath.size() + 1);
            if (sb.isConstant(instr.getUse(1))) {
                int arrayIndex = sb.getIntValue(instr.getUse(1));
                effectAccessPath.add(Variable.getArrayAccessQualifier(arrayIndex));
            } else {
                effectAccessPath.add(Variable.ANONYMOUS);
            }
            if (varAccessPath != null) {
                effectAccessPath.addAll(varAccessPath);
            }
            Variable arrayVar = Variable.failOrCreate(varMethod, instr.getUse(0), effectAccessPath, this.fastLangServices);
            this.recordFlow(variable, arrayVar, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
            this.summarizeConstraintsForSideEffect(variable, arrayVar);
        }
    }

    private void handleFakeArrayLoadPropagation(Variable variable, SSAAbstractInvokeInstruction invoke) {
        int useIndex = this.getUseIndex((SSAInstruction)invoke, variable.getVarID());
        if (useIndex == 0) {
            List<FieldReference> varAccessPath = variable.getAccessPath();
            if (varAccessPath == null || !Variable.isMapAccessQualifier(varAccessPath.get(0))) {
                ErrorLog.i().register("Variable " + variable + " is of type Map, but doesn't have an appropriate access path.");
                Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getDef(), varAccessPath, this.fastLangServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
            } else if (varAccessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getDef(), effectAccessPath, this.fastLangServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
            } else {
                IR ir = TaintAnalysisCache.soleInstance().getIR(variable.getMethod());
                SymbolTable sb = ir.getSymbolTable();
                if (sb.isConstant(invoke.getUse(1))) {
                    String accessQualifier;
                    String keyName = sb.getStringValue(invoke.getUse(1));
                    if (keyName.equals(accessQualifier = varAccessPath.get(0).getName().toString())) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                        Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getDef(), effectAccessPath, this.fastLangServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(variable.getMethod(), invoke.getDef(), effectAccessPath, this.fastLangServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)invoke));
                }
            }
        } else assert (useIndex == 1);
    }

    private void handleArrayLoadPropagation(Variable variable, SSAArrayLoadInstruction instr) {
        int useIndex = this.getUseIndex((SSAInstruction)instr, variable.getVarID());
        if (useIndex == 0) {
            List<FieldReference> varAccessPath = variable.getAccessPath();
            IMethod varMethod = variable.getMethod();
            Context varContext = variable.getContext();
            if (varAccessPath == null || !Variable.isArrayAccessQualifier(varAccessPath.get(0))) {
                ErrorLog.i().register("Variable " + variable + " is an array, but doesn't have an appropriate access path.");
                Variable effect = Variable.failOrCreate(varMethod, instr.getDef(), varAccessPath, this.fastLangServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
            } else if (varAccessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                Variable effect = Variable.failOrCreate(varMethod, instr.getDef(), effectAccessPath, this.fastLangServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
            } else {
                IR ir = TaintAnalysisCache.soleInstance().getIR(varMethod, varContext);
                SymbolTable sb = ir.getSymbolTable();
                if (sb.isConstant(instr.getUse(1))) {
                    int accessQualifier;
                    int arrayIndex = sb.getIntValue(instr.getUse(1));
                    if (arrayIndex == (accessQualifier = Integer.parseInt(varAccessPath.get(0).getName().toString()))) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                        Variable effect = Variable.failOrCreate(varMethod, instr.getDef(), effectAccessPath, this.fastLangServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(varMethod, instr.getDef(), effectAccessPath, this.fastLangServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(varMethod, varContext, (SSAInstruction)instr));
                }
            }
        } else assert (useIndex == 1);
    }

    private boolean canEnforceArrayStoreSemantics(SSAInstruction instr) {
        SSAAbstractInvokeInstruction invoke;
        MethodReference target;
        TypeReference declaringClassTypeRef;
        IClass c;
        if (instr instanceof SSAArrayStoreInstruction) {
            return true;
        }
        if (instr instanceof SSAAbstractInvokeInstruction && (c = this.cha.lookupClass(declaringClassTypeRef = (target = (invoke = (SSAAbstractInvokeInstruction)instr).getDeclaredTarget()).getDeclaringClass())) != null) {
            if (this.langServices.getLanguage().equals(CLRLanguage.lang)) {
                if (target.getName().equals((Object)SET_ITEM_ATOM)) {
                    if (this.systemCollectionsIDictionary == null) {
                        this.systemCollectionsIDictionary = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)SYSTEM_COLLECTIONS_IDICTIONARY));
                    }
                    if (this.systemCollectionsIDictionary != null && this.cha.isAssignableFrom(this.systemCollectionsIDictionary, c)) {
                        return true;
                    }
                    if (this.systemWebSessionState == null) {
                        this.systemWebSessionState = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)SYSTEM_WEB_SESSION_STATE_HTTP_SESSION_STATE));
                    }
                    if (this.systemWebSessionState != null && this.cha.isAssignableFrom(this.systemWebSessionState, c)) {
                        return true;
                    }
                }
            } else {
                assert (this.langServices.getLanguage().equals(Language.JAVA));
                if (target.getSelector().equals((Object)PUT_SELECTOR) && this.cha.getLeastCommonSuperclass(TypeReference.JavaUtilMap, declaringClassTypeRef).equals((Object)TypeReference.JavaUtilMap)) {
                    return true;
                }
                if (target.getSelector().equals((Object)SET_ATTRIBUTE_SELECTOR) && this.cha.getLeastCommonSuperclass(HTTP_SESSION_TYPE_REF, declaringClassTypeRef).equals((Object)HTTP_SESSION_TYPE_REF)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canEnforceArrayLoadSemantics(SSAInstruction instr) {
        SSAAbstractInvokeInstruction invoke;
        MethodReference target;
        TypeReference declaringClassTypeRef;
        IClass c;
        if (instr instanceof SSAArrayLoadInstruction) {
            return true;
        }
        if (instr instanceof SSAAbstractInvokeInstruction && (c = this.cha.lookupClass(declaringClassTypeRef = (target = (invoke = (SSAAbstractInvokeInstruction)instr).getDeclaredTarget()).getDeclaringClass())) != null) {
            if (this.langServices.getLanguage().equals(CLRLanguage.lang)) {
                if (target.getName().equals((Object)GET_ITEM_ATOM)) {
                    if (this.systemCollectionsIDictionary == null) {
                        this.systemCollectionsIDictionary = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)SYSTEM_COLLECTIONS_IDICTIONARY));
                    }
                    if (this.systemCollectionsIDictionary != null && this.cha.isAssignableFrom(this.systemCollectionsIDictionary, c)) {
                        return true;
                    }
                    if (this.systemWebSessionState == null) {
                        this.systemWebSessionState = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)SYSTEM_WEB_SESSION_STATE_HTTP_SESSION_STATE));
                    }
                    if (this.systemWebSessionState != null && this.cha.isAssignableFrom(this.systemWebSessionState, c)) {
                        return true;
                    }
                }
            } else {
                assert (this.langServices.getLanguage().equals(Language.JAVA));
                if (target.getSelector().equals((Object)GET_SELECTOR) && this.cha.getLeastCommonSuperclass(TypeReference.JavaUtilMap, declaringClassTypeRef).equals((Object)TypeReference.JavaUtilMap)) {
                    return true;
                }
            }
            if (target.getSelector().equals((Object)GET_ATTRIBUTE_SELECTOR) && this.cha.getLeastCommonSuperclass(HTTP_SESSION_TYPE_REF, declaringClassTypeRef).equals((Object)HTTP_SESSION_TYPE_REF)) {
                return true;
            }
        }
        return false;
    }

    private Set<Pair<IMethod, SSAAbstractInvokeInstruction>> getCalls(IMethod m) {
        HashSet result = HashSetFactory.make();
        Set<CallSite> callSites = this.cg.scanForCalls((Collection<IMethod>)Collections.singleton(m));
        for (CallSite site : callSites) {
            CGNode caller = site.getNode();
            IMethod callingMethod = caller.getMethod();
            for (SSAAbstractInvokeInstruction invoke : caller.getIR().getCalls(site.getSite())) {
                result.add(Pair.make((Object)callingMethod, (Object)invoke));
            }
        }
        return result;
    }

    private void recordSummaryConstraintsOnCallSites(IMethod m, Variable variable, Set<Variable> summarizedEffects) {
        for (Pair<IMethod, SSAAbstractInvokeInstruction> invoke : this.getCalls(m)) {
            Variable cause = Variable.failOrCreate((IMethod)invoke.fst, ((SSAAbstractInvokeInstruction)invoke.snd).getUse(variable.getVarID() - 1), variable.getAccessPath(), this.fastLangServices);
            for (Variable varInSummary : summarizedEffects) {
                Variable effect = varInSummary.getVarID() == -1 ? Variable.failOrCreate((IMethod)invoke.fst, ((SSAAbstractInvokeInstruction)invoke.snd).getDef(), varInSummary.getAccessPath(), this.fastLangServices) : Variable.failOrCreate((IMethod)invoke.fst, ((SSAAbstractInvokeInstruction)invoke.snd).getUse(varInSummary.getVarID() - 1), varInSummary.getAccessPath(), this.fastLangServices);
                this.recordFlow(cause, effect, new BasicPropagationWitness(cause.getMethod(), cause.getContext(), (SSAInstruction)invoke.snd));
                this.supportGraph.addSupport(new ISupportGraph.BinaryFact(variable, varInSummary), new ISupportGraph.BinaryFact(cause, effect));
            }
        }
    }

    private Set<Variable> getStaticGetFieldVars(FieldReference declaredField, List<FieldReference> accessPath) {
        HashSet result = HashSetFactory.make();
        Set<IMethod> range = this.allStaticGetFields.get(declaredField);
        if (range != null) {
            for (IMethod m : range) {
                IR ir = TaintAnalysisCache.soleInstance().getIR(m);
                for (SSAInstruction instr : ir.getInstructions()) {
                    SSAGetInstruction get;
                    if (!(instr instanceof SSAGetInstruction) || !(get = (SSAGetInstruction)instr).getDeclaredField().equals((Object)declaredField)) continue;
                    result.add(Variable.failOrCreate(m, instr.getDef(), accessPath, this.fastLangServices));
                }
            }
        }
        return result;
    }

    private int getUseIndex(SSAInstruction instr, int varID) {
        Set<Integer> useIndices = this.getUseIndices(instr, varID);
        assert (useIndices.size() == 1);
        return useIndices.iterator().next();
    }

    private Set<Integer> getUseIndices(SSAInstruction instr, int varID) {
        HashSet result = HashSetFactory.make();
        for (int index = 0; index < instr.getNumberOfUses(); ++index) {
            int currentUse = instr.getUse(index);
            if (currentUse != varID) continue;
            result.add(index);
        }
        return result;
    }

    private void accountForSideEffectsBetweenParameters(Variable v, Variable w) {
        Set<Variable> taintAncestors = this.findTaintAncestors(v);
        if (taintAncestors != null && taintAncestors.size() > 0) {
            HashSet taintParams = HashSetFactory.make();
            for (Variable t : taintAncestors) {
                if (!this.fastLangServices.isParameter(t)) continue;
                taintParams.add(t);
            }
            if (taintParams.size() > 0) {
                Set<Variable> ancestors = this.findAncestors(w);
                for (Variable ancestor : ancestors) {
                    if (!this.fastLangServices.isParameter(ancestor)) continue;
                    for (Variable taintParam : taintParams) {
                        if (!this.areMethodsCompatible(taintParam.getMethod(), ancestor.getMethod())) continue;
                        this.summarizeConstraintsForSideEffect(taintParam, ancestor);
                    }
                }
            }
        }
    }

    private void recordFlow(Variable cause, Variable effect, IPropagationWitness witness) {
        assert (witness != null);
        if (cause != null && effect != null && !(cause instanceof DeadEndVariable) && this.supportGraph.addSupport(new ISupportGraph.UnaryFact(cause), new ISupportGraph.UnaryFact(effect))) {
            this.propagationGraph.addNode((Object)cause);
            this.propagationGraph.addNode((Object)effect);
            this.propagationGraph.addEdge((Object)cause, (Object)effect, (Object)witness);
            if (cause.getMethod().equals(effect.getMethod())) {
                this.accountForSideEffectsBetweenParameters(cause, effect);
            }
            if (Variable.isStaticField(effect)) {
                SSAGetInstruction get = (SSAGetInstruction)TaintAnalysisCache.soleInstance().getDefUse(effect.getMethod(), effect.getContext()).getDef(effect.getVarID());
                assert (get.isStatic());
                FieldReference staticFieldRef = get.getDeclaredField();
                Set correspondingVars = MapUtil.findOrCreateSet(this.taintedStaticGetFields, (Object)staticFieldRef);
                correspondingVars.add(effect);
            }
            if (!this.explored.contains(effect)) {
                if (this.explored.contains(cause)) {
                    this.discovered.add(effect);
                } else {
                    Set effects = MapUtil.findOrCreateSet(this.waitingList, (Object)cause);
                    effects.add(effect);
                }
            }
        }
    }

    private Set<Variable> computeTargetReturnVars(IMethod caller, CallSiteReference site, List<FieldReference> accessPath) {
        HashSet result = HashSetFactory.make();
        Collection<IMethod> targetIMethods = this.getLiveTargets(caller, site);
        for (IMethod targetIMethod : targetIMethods) {
            SSAInstruction[] targetInstructions;
            IR targetIR;
            if (targetIMethod == null || (targetIR = TaintAnalysisCache.soleInstance().getIR(targetIMethod)) == null) continue;
            for (SSAInstruction targetInstr : targetInstructions = targetIR.getInstructions()) {
                if (!(targetInstr instanceof SSAReturnInstruction)) continue;
                Variable returnVar = Variable.failOrCreate(targetIMethod, targetInstr.getUse(0), accessPath, this.fastLangServices);
                result.add(returnVar);
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException, ClassHierarchyException, InvalidClassFileException {
        String candidatesPath;
        String language = args[0];
        String scopePath = args[1];
        String string = candidatesPath = args.length >= 3 ? args[2] : null;
        if (language.equals("JAVA")) {
            if (candidatesPath.equalsIgnoreCase("ALL")) {
                FlowAnalyzer.summarizeJavaScopeByPackage(scopePath, JavaServicesForFastanalysis.JAVA);
            } else {
                FlowAnalyzer.summarizeJavaScope(scopePath, candidatesPath, JavaServicesForFastanalysis.JAVA);
            }
        } else if (language.equals("DOTNET")) {
            FlowAnalyzer.summarizeDotNetScope(scopePath, candidatesPath, DotNetServicesForFastanalysis.DOTNET);
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public static void summarizeDotNetScope(String analysisScopePath, String candidatesPath, ILanguageSpecificServicesForFastanalysis fast_lang_services) throws IOException, ClassHierarchyException, InvalidClassFileException {
        CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> scope = ScopeUtil.getDotNetAnalysisScope(analysisScopePath);
        ClassHierarchy cha = ClassHierarchy.make(scope, scope, (Language)CLRLanguage.lang);
        FlowAnalyzer[] analyzers = new FlowAnalyzer[]{FlowAnalyzer.createAnalyzerForUnbalancedDotNetAnalysis((IClassHierarchy)cha), FlowAnalyzer.createAnalyzerForBalancedAnalysis((IClassHierarchy)cha, ILangServices.DOTNET, DotNetServicesForFastanalysis.DOTNET)};
        for (int index = 0; index < analyzers.length; ++index) {
            ConcreteResolutionEnumerator enumerator = new ConcreteResolutionEnumerator((IClassHierarchy)cha);
            Collection<IMethod> candidates = candidatesPath == null ? FlowAnalyzer.computeCandidates((IClassHierarchy)cha) : FlowAnalyzer.parseMethods((IClassHierarchy)cha, candidatesPath, CLRLanguage.lang);
            FlowAnalyzer.summarizeCandidates((IClassHierarchy)cha, analyzers[index], enumerator, candidates, HashMapFactory.make(), fast_lang_services);
        }
    }

    public static void summarizeJavaScope(String javaScopePath, String candidatesPath, ILanguageSpecificServicesForFastanalysis fast_lang_services) throws IOException, ClassHierarchyException, InvalidClassFileException {
        AnalysisScope scope = com.ibm.wala.andromeda.util.scopes.ScopeUtil.substituteAndCreateJavaAnalysisScope((String)javaScopePath, (File)TaintFileProvider.getFile((String)"dat/exclusions.java.dat"), (ClassLoader)AbstractAnalysisEngine.class.getClassLoader());
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope);
        FlowAnalyzer[] analyzers = new FlowAnalyzer[]{FlowAnalyzer.createAnalyzerForUnbalancedJavaAnalysis((IClassHierarchy)cha), FlowAnalyzer.createAnalyzerForBalancedAnalysis((IClassHierarchy)cha, ILangServices.JAVA, JavaServicesForFastanalysis.JAVA)};
        for (int index = 0; index < analyzers.length; ++index) {
            ConcreteResolutionEnumerator enumerator = new ConcreteResolutionEnumerator((IClassHierarchy)cha);
            Collection<IMethod> candidates = candidatesPath == null ? FlowAnalyzer.computeClientInducedCandidates((IClassHierarchy)cha) : FlowAnalyzer.parseMethods((IClassHierarchy)cha, candidatesPath, CLRLanguage.lang);
            FlowAnalyzer.summarizeCandidates((IClassHierarchy)cha, analyzers[index], enumerator, candidates, HashMapFactory.make(), fast_lang_services);
        }
    }

    private static void summarizeJavaScopeByPackage(String javaScopePath, ILanguageSpecificServicesForFastanalysis fast_lang_services) throws IOException, ClassHierarchyException, InvalidClassFileException {
        AnalysisScope scope = AnalysisScopeReader.readJavaScope((String)javaScopePath, (File)TaintFileProvider.getFile((String)"dat/exclusions.java.dat"), (ClassLoader)AbstractAnalysisEngine.class.getClassLoader());
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope);
        FlowAnalyzer[] analyzers = new FlowAnalyzer[]{FlowAnalyzer.createAnalyzerForUnbalancedJavaAnalysis((IClassHierarchy)cha), FlowAnalyzer.createAnalyzerForBalancedAnalysis((IClassHierarchy)cha, ILangServices.JAVA, JavaServicesForFastanalysis.JAVA)};
        for (int index = 0; index < analyzers.length; ++index) {
            ConcreteResolutionEnumerator enumerator = new ConcreteResolutionEnumerator((IClassHierarchy)cha);
            Map<String, Map<String, Set<IMethod>>> groupCandidates = FlowAnalyzer.groupCandidates(scope, (IClassHierarchy)cha);
            for (Map.Entry<String, Map<String, Set<IMethod>>> e1 : groupCandidates.entrySet()) {
                String jarFileName = e1.getKey();
                System.out.println("Now analyzing JAR file " + jarFileName);
                BufferedWriter bw = new BufferedWriter(new FileWriter(AUTO_SUMMARIES_FILE_NAME, true));
                bw.write("# " + jarFileName + "\n");
                bw.close();
                Map<String, Set<IMethod>> pkgs2methods = e1.getValue();
                for (Map.Entry<String, Set<IMethod>> e2 : pkgs2methods.entrySet()) {
                    String pkg = e2.getKey();
                    System.out.println("   Now analyzing package " + pkg);
                    bw = new BufferedWriter(new FileWriter(AUTO_SUMMARIES_FILE_NAME, true));
                    bw.write("#   " + pkg + "\n");
                    bw.close();
                    Set<IMethod> candidates = e2.getValue();
                    FlowAnalyzer.summarizeCandidates((IClassHierarchy)cha, analyzers[index], enumerator, candidates, HashMapFactory.make(), fast_lang_services);
                    bw = new BufferedWriter(new FileWriter(AUTO_SUMMARIES_FILE_NAME, true));
                    bw.write("#\n");
                    bw.close();
                }
                bw = new BufferedWriter(new FileWriter(AUTO_SUMMARIES_FILE_NAME, true));
                bw.write("#\n#\n");
                bw.close();
            }
        }
    }

    private static Map<String, Map<String, Set<IMethod>>> groupCandidates(AnalysisScope scope, IClassHierarchy cha) throws ClassHierarchyException, IOException, InvalidClassFileException {
        HashMap ret = HashMapFactory.make();
        for (ClassLoaderReference clr : scope.getLoaders()) {
            for (Module module : scope.getModules(clr)) {
                if (!(module instanceof JarFileModule)) continue;
                JarFileModule jfm = (JarFileModule)module;
                String jarFileName = jfm.getJarFile().getName().intern();
                System.out.println("Now reading " + jarFileName);
                if (jarFileName.endsWith("primordial.jar.model")) continue;
                Map pkgs2methods = MapUtil.findOrCreateMap((Map)ret, (Object)jarFileName);
                Iterator moduleEntries = jfm.getEntries();
                while (moduleEntries.hasNext()) {
                    IClass k;
                    ModuleEntry me = (ModuleEntry)moduleEntries.next();
                    if (!me.isClassFile() || (k = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)clr, (String)StringStuff.deployment2CanonicalTypeString((String)me.getClassName())))) == null) continue;
                    String pkg = k.getName().getPackage().toString().intern();
                    Set methods = MapUtil.findOrCreateSet((Map)pkgs2methods, (Object)pkg);
                    for (IMethod m : k.getDeclaredMethods()) {
                        methods.add(m);
                        System.out.println("   Added method " + m.getSignature());
                    }
                }
            }
        }
        return ret;
    }

    private static FlowAnalyzer createAnalyzerForUnbalancedDotNetAnalysis(IClassHierarchy cha) {
        Map<Selector, Set<IClass>> sources = FlowAnalyzer.computeTaintAPIs(cha, FlowAnalyzer.getDefaultDotNetRules(), EnumSet.of(TaintAPIs.SOURCE));
        Map<Selector, Set<IClass>> sinks = FlowAnalyzer.computeTaintAPIs(cha, FlowAnalyzer.getDefaultDotNetRules(), EnumSet.of(TaintAPIs.SINK));
        FlowAnalyzer analyzer = FlowAnalyzer.createAnalyzerForUnbalancedAnalysis(cha, ILangServices.DOTNET, DotNetServicesForFastanalysis.DOTNET, sources, sinks);
        return analyzer;
    }

    private static FlowAnalyzer createAnalyzerForUnbalancedJavaAnalysis(IClassHierarchy cha) {
        Map<Selector, Set<IClass>> sources = FlowAnalyzer.computeTaintAPIs(cha, FlowAnalyzer.getDefaultJavaRules(), EnumSet.of(TaintAPIs.SOURCE));
        Map<Selector, Set<IClass>> sinks = FlowAnalyzer.computeTaintAPIs(cha, FlowAnalyzer.getDefaultJavaRules(), EnumSet.of(TaintAPIs.SINK));
        FlowAnalyzer analyzer = FlowAnalyzer.createAnalyzerForUnbalancedAnalysis(cha, ILangServices.JAVA, JavaServicesForFastanalysis.JAVA, sources, sinks);
        return analyzer;
    }

    private static FlowAnalyzer createAnalyzerForBalancedAnalysis(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services) {
        return new FlowAnalyzer(cha, langServices, fast_lang_services);
    }

    private static FlowAnalyzer createAnalyzerForUnbalancedAnalysis(final IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services, final Map<Selector, Set<IClass>> sources, final Map<Selector, Set<IClass>> sinks) {
        FlowAnalyzer analyzer = new FlowAnalyzer(cha, langServices, fast_lang_services, new Filter<MethodReference>(){

            public boolean accepts(MethodReference o) {
                IMethod m = cha.resolveMethod(o);
                Set S = (Set)sources.get(o.getSelector());
                if (S != null) {
                    for (IClass c : S) {
                        if (!c.getMethod(o.getSelector()).equals(m)) continue;
                        return true;
                    }
                }
                return false;
            }
        }, new Filter<MethodReference>(){

            public boolean accepts(MethodReference o) {
                IMethod m = cha.resolveMethod(o);
                Set S = (Set)sinks.get(o.getSelector());
                if (S != null) {
                    for (IClass c : S) {
                        if (!c.getMethod(o.getSelector()).equals(m)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        return analyzer;
    }

    private static Map<Selector, Set<IClass>> computeTaintAPIsForJava(IClassHierarchy cha) {
        Set<IRawTaintRule> rules = FlowAnalyzer.getDefaultJavaRules();
        return FlowAnalyzer.computeTaintAPIs(cha, rules);
    }

    private static void summarizeCandidates(IClassHierarchy cha, FlowAnalyzer analyzer, ConcreteResolutionEnumerator enumerator, Collection<IMethod> candidates, Map<Selector, Set<IClass>> taintAPIs, ILanguageSpecificServicesForFastanalysis fast_lang_services) throws IOException, InvalidClassFileException, ClassHierarchyException {
        for (IMethod candidate : candidates) {
            if (candidate == null || analyzer.isSummarized(candidate) || candidate.isNative()) continue;
            HashSet result = HashSetFactory.make();
            Iterator<List<TypeReference>> iterator = enumerator.getBoundedIterator(candidate, 3);
            while (iterator.hasNext()) {
                List<TypeReference> rawPA = iterator.next();
                List<IClass> pa = FlowAnalyzer.resolveClasses(rawPA, cha);
                IMethod concreteCandidate = candidate.isStatic() ? candidate : ((IClass)pa.get(0)).getMethod(candidate.getSelector());
                if (concreteCandidate == null || concreteCandidate.isNative()) continue;
                Set<SummaryCache.TaintRelation> s = analyzer.summarizeTaintPropagation(concreteCandidate, pa);
                result.add(new ContextualSummary(candidate, s, pa));
            }
            SummaryCache.TaintRelationSet ss = new SummaryCache.TaintRelationSet(cha, fast_lang_services);
            for (ContextualSummary cs : result) {
                ss.addAll(cs.getSummary());
            }
            ExhaustiveSummary summary = new ExhaustiveSummary(candidate, ss);
            FlowAnalyzer.documentSummary(summary, cha, fast_lang_services);
        }
    }

    private static void documentSummary(ExhaustiveSummary summary, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis fast_lang_services) throws IOException {
        if (!FlowAnalyzer.hasSummary(summary.getMethod())) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(AUTO_SUMMARIES_FILE_NAME, true));
            if (summary.getSummary() != null && summary.getSummary().size() > 0) {
                ExhaustiveSummary collapsedSummary = FlowAnalyzer.collapseSummary(summary, cha, fast_lang_services);
                for (SummaryCache.TaintRelation relation : collapsedSummary.getSummary()) {
                    Pair<Variable, Variable> p = relation.instantiate(summary.getMethod());
                    String r = collapsedSummary.getMethod().getSignature() + "\t" + (relation.getPrecondition() == null ? "[" + FlowAnalyzer.getCalledSourceSignature((Variable)p.fst) + ":" + SummaryCache.TaintFact.extractReturnFact(((Variable)p.fst).getMethod(), ((Variable)p.fst).getAccessPath()) + "]" : relation.getPrecondition()) + "\t" + (relation.getPostcondition() == null ? "[" + FlowAnalyzer.getCalledSinkSignature((Variable)p.snd, fast_lang_services) + ":" + SummaryCache.TaintFact.extractTaintFact((Variable)p.snd) + "]" : relation.getPostcondition());
                    System.err.println("\t" + r);
                    bw.write(r + "\r\n");
                }
            } else {
                String r = summary.getMethod().getSignature() + "\tnone\tnone";
                System.err.println("\t" + r);
                bw.write(r + "\r\n");
            }
            bw.close();
        }
    }

    private static String getCalledSinkSignature(Variable sinkFormal, ILanguageSpecificServicesForFastanalysis fast_lang_services) {
        assert (fast_lang_services.isParameter(sinkFormal)) : "ERROR: expected variable reaching sink to be a formal parameter!";
        return sinkFormal.getMethod().getSignature();
    }

    private static String getCalledSourceSignature(Variable seed) {
        IMethod seedMethod = seed.getMethod();
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(seedMethod, seed.getContext());
        SSAInstruction def = du.getDef(seed.getVarID());
        if (def instanceof SSAGetInstruction) {
            SSAGetInstruction get = (SSAGetInstruction)def;
            assert (get.isStatic());
            return seedMethod.getSignature();
        }
        assert (def instanceof SSAAbstractInvokeInstruction) : "ERROR: expected source variable to be the result of a source-method call!";
        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)def;
        return invoke.getDeclaredTarget().getSignature();
    }

    private static Collection<IMethod> computeClientInducedCandidates(IClassHierarchy cha) throws InvalidClassFileException {
        HashSet result = HashSetFactory.make();
        AnalysisScope scope = cha.getScope();
        for (IClass c : cha) {
            if (!scope.isApplicationLoader(c.getClassLoader())) continue;
            for (IMethod m : c.getDeclaredMethods()) {
                for (CallSiteReference csr : CodeScanner.getCallSites((IMethod)m)) {
                    IMethod declaredTarget = cha.resolveMethod(csr.getDeclaredTarget());
                    if (declaredTarget == null || scope.isApplicationLoader(declaredTarget.getDeclaringClass().getClassLoader()) || declaredTarget.isNative()) continue;
                    result.add(declaredTarget);
                }
            }
        }
        return result;
    }

    private static Collection<IMethod> computeCandidates(IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        AnalysisScope scope = cha.getScope();
        for (IClass c : cha) {
            if (scope.isApplicationLoader(c.getClassLoader())) continue;
            for (IMethod m : c.getDeclaredMethods()) {
                if (!m.isPublic() && !m.isProtected()) continue;
                result.add(m);
            }
        }
        return result;
    }

    private static Map<Selector, Set<IClass>> computeTaintAPIsForDotNet(IClassHierarchy cha) {
        Set<IRawTaintRule> rules = FlowAnalyzer.getDefaultDotNetRules();
        return FlowAnalyzer.computeTaintAPIs(cha, rules);
    }

    private static Map<Selector, Set<IClass>> computeTaintAPIs(IClassHierarchy cha, Set<IRawTaintRule> rules) {
        return FlowAnalyzer.computeTaintAPIs(cha, rules, EnumSet.of(TaintAPIs.SOURCE, TaintAPIs.SINK));
    }

    private static Map<Selector, Set<IClass>> computeTaintAPIs(IClassHierarchy cha, Set<IRawTaintRule> rules, EnumSet<TaintAPIs> which) {
        HashMap result = HashMapFactory.make();
        HashSet sigs = HashSetFactory.make();
        for (IRawTaintRule r : rules) {
            if (which.contains((Object)TaintAPIs.SOURCE)) {
                sigs.addAll(r.getSourceSignatures());
            }
            if (which.contains((Object)TaintAPIs.SANITIZER)) {
                sigs.addAll(r.getSanitizerSignatures());
            }
            if (!which.contains((Object)TaintAPIs.SINK)) continue;
            sigs.addAll(r.getSinkSignatures());
        }
        Set mm = SignatureUtil.findMatchingMethods((IClassHierarchy)cha, (Collection)sigs, (Language)CLRLanguage.lang);
        for (IMethod m : mm) {
            Set ss = MapUtil.findOrCreateSet((Map)result, (Object)m.getSelector());
            ss.add(m.getDeclaringClass());
        }
        return result;
    }

    protected static List<IClass> resolveClasses(List<TypeReference> rawPA, IClassHierarchy cha) {
        ArrayList<IClass> result = new ArrayList<IClass>(rawPA.size());
        for (TypeReference tr : rawPA) {
            result.add(cha.lookupClass(tr));
        }
        return result;
    }

    public static Collection<IMethod> parseMethods(IClassHierarchy cha, String candidatesPath, Language l) throws IOException {
        String line;
        HashSet result = HashSetFactory.make();
        BufferedReader in = new BufferedReader(new FileReader(candidatesPath));
        while ((line = in.readLine()) != null) {
            result.add(SignatureUtil.sig2Method((String)line, (IClassHierarchy)cha, (Language)l));
        }
        return result;
    }

    public static void documentSummary(ContextualSummary cs, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis fast_lang_services) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(AUTO_SUMMARIES_FILE_NAME, true));
        if (cs.getPointerAnalysis() != null) {
            String s = FlowAnalyzer.prettyPrint(cs.getPointerAnalysis());
            System.err.println(s);
        }
        if (cs.getSummary() != null && cs.getSummary().size() > 0) {
            ContextualSummary collapsedSummary = FlowAnalyzer.collapseSummary(cs, cha, fast_lang_services);
            for (SummaryCache.TaintRelation relation : collapsedSummary.getSummary()) {
                String r = collapsedSummary.getMethod().getSignature() + "\t" + relation.getPrecondition() + "\t" + relation.getPostcondition();
                System.err.println("\t" + r);
                bw.write(r + "\r\n");
            }
        } else {
            String r = cs.getMethod().getSignature() + "\tnone\tnone";
            System.err.println("\t" + r);
            bw.write(r + "\r\n");
        }
        bw.close();
    }

    private static ExhaustiveSummary collapseSummary(ExhaustiveSummary cs, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis fast_lang_services) {
        int WIDENING_BOUND = 3;
        HashMap relationsBetweenRoots = HashMapFactory.make();
        for (SummaryCache.TaintRelation taintRelation : cs.getSummary()) {
            Pair key;
            if (taintRelation.getKind() == SummaryCache.TaintRelation.Kind.CONDITIONAL) {
                key = Pair.make((Object)taintRelation.getPrecondition().getParameterIndex(), (Object)taintRelation.getPostcondition().getParameterIndex());
            } else if (taintRelation.getKind() == SummaryCache.TaintRelation.Kind.UNCONDITIONAL_EFFECT) {
                key = Pair.make((Object)taintRelation.getPrecondition().getParameterIndex(), (Object)0);
            } else {
                assert (taintRelation.getKind() == SummaryCache.TaintRelation.Kind.UNCONDITIONAL_CAUSE);
                key = Pair.make((Object)0, (Object)taintRelation.getPostcondition().getParameterIndex());
            }
            Integer hitCount = (Integer)relationsBetweenRoots.get(key);
            relationsBetweenRoots.put(key, hitCount == null ? 1 : hitCount + 1);
        }
        HashSet collapsedRelations = HashSetFactory.make();
        for (SummaryCache.TaintRelation r : cs.getSummary()) {
            Pair<Variable, Variable> p;
            IMethod m;
            Integer hitCount;
            Pair key;
            if (r.getKind() == SummaryCache.TaintRelation.Kind.CONDITIONAL) {
                key = Pair.make((Object)r.getPrecondition().getParameterIndex(), (Object)r.getPostcondition().getParameterIndex());
                hitCount = (Integer)relationsBetweenRoots.get(key);
                if (hitCount > 3) {
                    m = cs.getMethod();
                    collapsedRelations.add(SummaryCache.ConditionalTaintRelation.create(SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPrecondition().getParameterIndex(), Variable.dotStarAccessPath(), fast_lang_services)), SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPostcondition().getParameterIndex(), Variable.dotStarAccessPath(), fast_lang_services)), cha, fast_lang_services));
                    continue;
                }
                collapsedRelations.add(r);
                continue;
            }
            if (r.getKind() == SummaryCache.TaintRelation.Kind.UNCONDITIONAL_EFFECT) {
                key = Pair.make((Object)r.getPrecondition().getParameterIndex(), (Object)0);
                hitCount = (Integer)relationsBetweenRoots.get(key);
                m = cs.getMethod();
                p = r.instantiate(m);
                if (!fast_lang_services.isParameter((Variable)p.fst)) continue;
                assert (p.snd != null) : "ERROR: expected non-null postcondition in the case of an unconditional-effect relation!";
                if (hitCount > 3) {
                    collapsedRelations.add(SummaryCache.UnconditionalEffectRelation.create(SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPrecondition().getParameterIndex(), Variable.dotStarAccessPath(), fast_lang_services)), Variable.failOrCreate(((Variable)p.snd).getMethod(), ((Variable)p.snd).getVarID(), Variable.dotStarAccessPath(), fast_lang_services), fast_lang_services));
                    continue;
                }
                collapsedRelations.add(SummaryCache.UnconditionalEffectRelation.create(SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPrecondition().getParameterIndex(), r.getPrecondition().getAccessPath(), fast_lang_services)), (Variable)p.snd, fast_lang_services));
                continue;
            }
            assert (r.getKind() == SummaryCache.TaintRelation.Kind.UNCONDITIONAL_CAUSE);
            key = Pair.make((Object)0, (Object)r.getPostcondition().getParameterIndex());
            hitCount = (Integer)relationsBetweenRoots.get(key);
            m = cs.getMethod();
            p = r.instantiate(m);
            if (!fast_lang_services.isParameter((Variable)p.snd)) continue;
            if (hitCount > 3) {
                collapsedRelations.add(SummaryCache.UnconditionalCauseRelation.create(Variable.failOrCreate(((Variable)p.fst).getMethod(), ((Variable)p.fst).getVarID(), Variable.dotStarAccessPath(), fast_lang_services), SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPostcondition().getParameterIndex(), Variable.dotStarAccessPath(), fast_lang_services)), fast_lang_services));
                continue;
            }
            collapsedRelations.add(SummaryCache.UnconditionalCauseRelation.create((Variable)p.fst, SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPostcondition().getParameterIndex(), r.getPostcondition().getAccessPath(), fast_lang_services)), fast_lang_services));
        }
        ExhaustiveSummary exhaustiveSummary = new ExhaustiveSummary(cs.getMethod(), collapsedRelations);
        return exhaustiveSummary;
    }

    private static ContextualSummary collapseSummary(ContextualSummary cs, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis fast_lang_services) {
        int WIDENING_BOUND = 3;
        HashMap relationsBetweenRoots = HashMapFactory.make();
        for (SummaryCache.TaintRelation taintRelation : cs.getSummary()) {
            Pair key;
            Integer hitCount = (Integer)relationsBetweenRoots.get(key = Pair.make((Object)taintRelation.getPrecondition().getParameterIndex(), (Object)taintRelation.getPostcondition().getParameterIndex()));
            relationsBetweenRoots.put(key, hitCount == null ? 1 : hitCount + 1);
        }
        HashSet collapsedRelations = HashSetFactory.make();
        for (SummaryCache.TaintRelation r : cs.getSummary()) {
            Pair key = Pair.make((Object)r.getPrecondition().getParameterIndex(), (Object)r.getPostcondition().getParameterIndex());
            Integer hitCount = (Integer)relationsBetweenRoots.get(key);
            if (hitCount > 3) {
                assert (r.getKind() == SummaryCache.TaintRelation.Kind.CONDITIONAL);
                IMethod m = cs.getMethod();
                collapsedRelations.add(SummaryCache.ConditionalTaintRelation.create(SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPrecondition().getParameterIndex(), Variable.dotStarAccessPath(), fast_lang_services)), SummaryCache.TaintFact.extractTaintFact(Variable.failOrCreate(m, r.getPostcondition().getParameterIndex(), Variable.dotStarAccessPath(), fast_lang_services)), cha, fast_lang_services));
                continue;
            }
            collapsedRelations.add(r);
        }
        ContextualSummary contextualSummary = new ContextualSummary(cs.getMethod(), collapsedRelations, cs.getPointerAnalysis());
        return contextualSummary;
    }

    private static String prettyPrint(List<IClass> pointerAnalysis) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int index = 0; index < pointerAnalysis.size(); ++index) {
            String current = pointerAnalysis.get(index) == null ? "---" : pointerAnalysis.get(index).getName().toString();
            sb.append(current);
            if (index >= pointerAnalysis.size() - 1) continue;
            sb.append(',');
        }
        sb.append('>');
        return sb.toString();
    }

    private boolean isNativeAbstractOrSummarized(IMethod m) throws IOException {
        if (m == null) {
            return true;
        }
        if (m.isNative() || m.isAbstract()) {
            return true;
        }
        if (this.spec.hasSpecForMethod(m)) {
            return true;
        }
        return FlowAnalyzer.hasSummary(m);
    }

    public boolean isEligibleForSummary(IMethod m) throws IOException {
        if (this.isNativeAbstractOrSummarized(m)) {
            return false;
        }
        Language l = m.getDeclaringClass().getClassLoader().getLanguage();
        assert (l.equals(CLRLanguage.lang) || l.equals(Language.JAVA));
        String returnTypeName = m.getReturnType().getName().toString();
        if (m.getNumberOfParameters() <= 1) {
            if (l.equals(CLRLanguage.lang) && returnTypeName.equals("Pvoid")) {
                return false;
            }
            if (l.equals(Language.JAVA) && returnTypeName.equals("V")) {
                return false;
            }
        }
        for (int index = 0; index < m.getNumberOfParameters(); ++index) {
            TypeReference t = m.getParameterType(index);
            if (l.equals(CLRLanguage.lang)) {
                if (t.equals((Object)CLRTypeReference.SystemObject)) {
                    return false;
                }
                if (t.equals((Object)TypeReference.findOrCreateArrayOf((TypeReference)CLRTypeReference.SystemObject))) {
                    return false;
                }
            }
            if (!l.equals(Language.JAVA)) continue;
            if (t.equals((Object)TypeReference.JavaLangObject)) {
                return false;
            }
            if (!t.equals((Object)TypeReference.findOrCreateArrayOf((TypeReference)TypeReference.JavaLangObject))) continue;
            return false;
        }
        return true;
    }

    private boolean isEligibleForConditionalSummary(IMethod m, Map<Selector, Set<IClass>> taintAPIs) throws IOException, InvalidClassFileException {
        return this.isEligibleForSummary(m);
    }

    private static boolean hasTaintSideEffects(IMethod m, Map<Selector, Set<IClass>> taintAPIs) {
        int MAX_DEPTH = 5;
        HashSet visited = HashSetFactory.make();
        HashSet worklist = Collections.singleton(Pair.make((Object)m, (Object)0));
        visited.add(m);
        while (!worklist.isEmpty()) {
            Iterator<Pair> iter = worklist.iterator();
            worklist = HashSetFactory.make();
            while (iter.hasNext()) {
                Collection callSites;
                Pair current = iter.next();
                if ((Integer)current.snd >= 5) continue;
                if (FlowAnalyzer.isTaintAPI((IMethod)current.fst, taintAPIs)) {
                    return true;
                }
                try {
                    callSites = CodeScanner.getCallSites((IMethod)m);
                }
                catch (InvalidClassFileException e) {
                    callSites = null;
                }
                catch (RuntimeException e) {
                    callSites = null;
                }
                if (callSites == null) continue;
                for (CallSiteReference callSite : callSites) {
                    Set targets = m.getClassHierarchy().getPossibleTargets(callSite.getDeclaredTarget());
                    for (IMethod target : targets) {
                        if (visited.contains(target)) continue;
                        worklist.add(Pair.make((Object)target, (Object)((Integer)current.snd + 1)));
                        visited.add(target);
                    }
                }
            }
        }
        return false;
    }

    private static boolean isTaintAPI(IMethod m, Map<Selector, Set<IClass>> taintAPIs) {
        IClassHierarchy cha = m.getClassHierarchy();
        IClass c = m.getDeclaringClass();
        Set<IClass> ss = taintAPIs.get(m.getSelector());
        if (ss != null) {
            for (IClass s : ss) {
                if (!cha.isAssignableFrom(s, c)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getJavaRulesPath() {
        return "resources/rules_java.xml";
    }

    private static String getDotNetRulesPath() {
        return "../com.ibm.wala.taint.test/resources/actual_rules_dotnet.xml";
    }

    private static synchronized Set<IRawTaintRule> getDefaultJavaRules() {
        RuleManager ruleManager = RuleManager.getRuleManager(FlowAnalyzer.getJavaRulesPath());
        return FlowAnalyzer.getDefaultRules(ruleManager);
    }

    private static synchronized Set<IRawTaintRule> getDefaultDotNetRules() {
        RuleManager ruleManager = RuleManager.getRuleManager(FlowAnalyzer.getDotNetRulesPath());
        return FlowAnalyzer.getDefaultRules(ruleManager);
    }

    public static synchronized Set<IRawTaintRule> getDefaultRules(RuleManager ruleManager) {
        HashSet result = HashSetFactory.make();
        for (IRawTaintRule rule : ruleManager.getRules()) {
            Issue issue = ruleManager.getIssue(rule.getIssueID());
            int exploitability = rule.getExploitabilityLevel();
            int severity = issue.getSeverity();
            if (exploitability != 0 || severity >= 4) continue;
            result.add(rule);
        }
        return result;
    }

    private boolean isSummarized(IMethod m) throws IOException {
        return this.spec.hasSpecForMethod(m) || FlowAnalyzer.hasSummary(m);
    }

    private static boolean hasSummary(IMethod m) throws IOException {
        boolean result = false;
        String autoSummariesFile = System.getProperty("localDir") + File.separator + "autoSummaries.txt";
        try {
            String f;
            BufferedReader in = new BufferedReader(new FileReader(autoSummariesFile));
            while ((f = in.readLine()) != null) {
                if (f.trim().length() == 0 || !f.contains(m.getSignature())) continue;
                result = true;
                break;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            FileWriter fw = new FileWriter(autoSummariesFile);
            fw.close();
        }
        return result;
    }

    private static enum TaintAPIs {
        SOURCE,
        SINK,
        SANITIZER;

    }
}

