/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.modular;

import com.ibm.wala.andromeda.incremental.SummaryCache;
import com.ibm.wala.andromeda.modular.ISummaryProvider;
import com.ibm.wala.andromeda.modular.SummaryProvider;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;

public final class SummaryGenerator {
    public void startModularAnalysis(Language l) throws ClassHierarchyException, IOException, InvalidClassFileException {
        AnalysisScope scope = this.createScope();
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope);
        ISummaryProvider summary = this.createSummaryProvider(l, scope);
        for (ClassLoaderReference clr : scope.getLoaders()) {
            for (Module module : scope.getModules(clr)) {
                if (!(module instanceof JarFileModule)) continue;
                JarFileModule jfm = (JarFileModule)module;
                HashSet visitedPkgs = HashSetFactory.make();
                ModuleEntry me = (ModuleEntry)jfm.getEntries().next();
                while (jfm.getEntries().hasNext()) {
                    IClass k;
                    String pkg;
                    if (!me.isClassFile() || !visitedPkgs.add(pkg = (k = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)clr, (String)me.getClassName()))).getName().getPackage().toString().intern())) continue;
                    Map<IMethod, Set<SummaryCache.TaintRelation>> summaries = summary.summarize(scope, new Filter<IMethod>(){

                        public boolean accepts(IMethod m) {
                            return m.getDeclaringClass().getName().getPackage().toString().intern() == pkg;
                        }
                    });
                    for (Map.Entry<IMethod, Set<SummaryCache.TaintRelation>> entry : summaries.entrySet()) {
                        IMethod m = entry.getKey();
                        Set<SummaryCache.TaintRelation> set = entry.getValue();
                    }
                }
            }
        }
    }

    private ISummaryProvider createSummaryProvider(Language l, AnalysisScope scope) throws ClassHierarchyException {
        ISummaryProvider summary = SummaryProvider.make(l, scope);
        summary.setDoEagerSummarization(true);
        return summary;
    }

    private AnalysisScope createScope() throws IOException {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        String sunJava6Path = System.getProperty("taintResourcesDir") + File.separator + "rasde" + File.separator + "SunJava6" + File.separator;
        scope.addToScope(ClassLoaderReference.Primordial, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "charsets.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "deploy.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "javaws.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "jce.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "jsse.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "management-agent.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "plugin.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "resources.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "lib" + File.separator + "dt.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "lib" + File.separator + "htmlconverter.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "lib" + File.separator + "jconsole.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "lib" + File.separator + "tools.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "ext" + File.separator + "dnsns.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "ext" + File.separator + "localedata.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "ext" + File.separator + "sunjce_provider.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "ext" + File.separator + "sunmscapi.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "ext" + File.separator + "sunpkcs11.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "im" + File.separator + "indicim.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile(sunJava6Path + "jre" + File.separator + "lib" + File.separator + "im" + File.separator + "thaiim.jar"));
        return scope;
    }

    public static void main(String[] args) throws Exception {
        SummaryGenerator sg = new SummaryGenerator();
        if (args.length == 0) {
            System.err.println("Error: Expected language on the command line.");
            System.exit(0);
        }
        JavaLanguage l = null;
        if (args[0].equalsIgnoreCase("JAVA")) {
            l = Language.JAVA;
        } else if (args[0].equalsIgnoreCase("DOTNET")) {
            l = CLRLanguage.lang;
        } else {
            System.err.println("Error: language " + args[0] + " unsupported.");
            System.exit(0);
        }
        sg.startModularAnalysis((Language)l);
    }
}

