/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.modular;

import com.ibm.wala.andromeda.cg.util.ScopeUtil;
import com.ibm.wala.andromeda.incremental.SummaryCache;
import com.ibm.wala.andromeda.lang.DotNetServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServicesForFastanalysis;
import com.ibm.wala.andromeda.modular.ConcreteResolutionEnumerator;
import com.ibm.wala.andromeda.modular.ContextualSummary;
import com.ibm.wala.andromeda.modular.ExhaustiveSummary;
import com.ibm.wala.andromeda.modular.FlowAnalyzer;
import com.ibm.wala.andromeda.modular.ISummaryProvider;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.Rules;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.rules.management.Method;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SummaryProvider
implements ISummaryProvider {
    private final Filter<IMethod> DEFAULT_METHOD_FILTER = new Filter<IMethod>(){

        public boolean accepts(IMethod o) {
            return (o.isProtected() || o.isPublic()) && !o.isNative() && !o.isAbstract();
        }
    };
    private final Map<AnalysisScope, Map<IMethod, Set<SummaryCache.TaintRelation>>> scopewiseSummaries = HashMapFactory.make();
    private Integer polymorphism = null;
    private boolean doEagerSummarization = false;
    private final Map<AnalysisScope, Filter<IMethod>> scope2candidatesFilter = HashMapFactory.make();
    private Map<AnalysisScope, IClassHierarchy> scope2cha = HashMapFactory.make();
    private final ILangServices langServices;
    private final ILanguageSpecificServicesForFastanalysis fastLangServices;
    private final Filter<MethodReference> sourceFilter;
    private final Filter<MethodReference> sinkFilter;
    private boolean detectSanitizers = false;

    public SummaryProvider(Language l, AnalysisScope scope) throws ClassHierarchyException {
        Set compatibleMethods;
        Set<IRawTaintRule> rules;
        if (l.equals(Language.JAVA)) {
            rules = Rules.getAllJavaRules("../com.ibm.wala.andromeda/");
            this.langServices = ILangServices.JAVA;
            this.fastLangServices = JavaServicesForFastanalysis.JAVA;
        } else if (l.equals(CLRLanguage.lang)) {
            rules = Rules.getAllDotNetRules();
            this.langServices = ILangServices.DOTNET;
            this.fastLangServices = DotNetServicesForFastanalysis.DOTNET;
        } else {
            Assertions.UNREACHABLE();
            rules = null;
            this.langServices = null;
            this.fastLangServices = null;
        }
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope);
        HashSet sourcePatterns = HashSetFactory.make();
        HashSet sinkPatterns = HashSetFactory.make();
        Rules.getSourceAndSinkMembers(rules, sourcePatterns, sinkPatterns);
        final HashSet sourceSigs = HashSetFactory.make();
        final HashSet sinkSigs = HashSetFactory.make();
        for (IMember sourcePattern : sourcePatterns) {
            if (!(sourcePattern instanceof Method)) continue;
            Method sourceMethod = (Method)sourcePattern;
            compatibleMethods = SignatureUtil.findMatchingMethods((IClassHierarchy)cha, (String)sourceMethod.getSignature(), (Language)l);
            for (IMethod compatibleMethod : compatibleMethods) {
                sourceSigs.add(compatibleMethod.getSignature());
            }
        }
        for (IMember sinkPattern : sinkPatterns) {
            if (!(sinkPattern instanceof Method)) continue;
            Method sinkMethod = (Method)sinkPattern;
            compatibleMethods = SignatureUtil.findMatchingMethods((IClassHierarchy)cha, (String)sinkMethod.getSignature(), (Language)l);
            for (IMethod compatibleMethod : compatibleMethods) {
                sinkSigs.add(compatibleMethod.getSignature());
            }
        }
        this.sourceFilter = new Filter<MethodReference>(){

            public boolean accepts(MethodReference mf) {
                return sourceSigs.contains(mf.getSignature());
            }
        };
        this.sinkFilter = new Filter<MethodReference>(){

            public boolean accepts(MethodReference mf) {
                return sinkSigs.contains(mf.getSignature());
            }
        };
    }

    @Override
    public void setPolymorphismBound(int polymorphism) {
        this.polymorphism = polymorphism;
    }

    @Override
    public Integer getPolymorphismBound() {
        return this.polymorphism;
    }

    @Override
    public void setDetectSanitizers(boolean detectSanitizers) {
        this.detectSanitizers = detectSanitizers;
    }

    private Set<SummaryCache.TaintRelation> summarizeMethodIfNeeded(IMethod m) throws ClassHierarchyException, IOException, InvalidClassFileException {
        if (this.isDoEagerSummarization()) {
            Map<IMethod, Set<SummaryCache.TaintRelation>> M = this.scopewiseSummaries.get(m.getClassHierarchy().getScope());
            if (M == null) {
                return null;
            }
            return M.get(m);
        }
        SummaryCache.soleInstance().clear();
        Filter<IMethod> candidatesFilter = this.scope2candidatesFilter.get(m.getClassHierarchy().getScope());
        if (candidatesFilter != null && candidatesFilter.accepts((Object)m)) {
            IClassHierarchy cha = this.findOrCreateCHA(m.getClassHierarchy().getScope());
            ConcreteResolutionEnumerator resolutionEnum = new ConcreteResolutionEnumerator(cha);
            FlowAnalyzer analyzer = new FlowAnalyzer(cha, this.langServices, this.fastLangServices, this.sourceFilter, this.sinkFilter);
            return this.summarizeMethod(analyzer, resolutionEnum, m);
        }
        return null;
    }

    private IClassHierarchy findOrCreateCHA(AnalysisScope scope) throws ClassHierarchyException {
        IClassHierarchy cha = this.scope2cha.get(scope);
        if (cha == null) {
            cha = ClassHierarchy.make((AnalysisScope)scope);
            this.scope2cha.put(scope, cha);
        }
        return cha;
    }

    private Set<SummaryCache.TaintRelation> summarizeMethod(FlowAnalyzer analyzer, ConcreteResolutionEnumerator resolutionEnum, IMethod m) throws ClassHierarchyException, IOException, InvalidClassFileException {
        if (analyzer.isEligibleForSummary(m)) {
            Iterator<List<TypeReference>> iterator = this.polymorphism == null ? resolutionEnum.getIterator(m) : resolutionEnum.getBoundedIterator(m, this.polymorphism);
            IClassHierarchy cha = m.getClassHierarchy();
            HashSet S = HashSetFactory.make();
            while (iterator.hasNext()) {
                List<TypeReference> L = iterator.next();
                List<IClass> pa = SummaryProvider.resolveClasses(L, cha);
                Set<SummaryCache.TaintRelation> particularSummary = analyzer.summarizeTaintPropagation(m, pa);
                S.add(new ContextualSummary(m, particularSummary, pa));
            }
            SummaryCache.TaintRelationSet ss = new SummaryCache.TaintRelationSet(cha, this.fastLangServices);
            for (ContextualSummary cs : S) {
                ss.addAll(cs.getSummary());
            }
            ExhaustiveSummary summary = new ExhaustiveSummary(m, ss);
            Set<SummaryCache.TaintRelation> TRs = summary.getSummary();
            if (this.isDoEagerSummarization()) {
                Map M = MapUtil.findOrCreateMap(this.scopewiseSummaries, (Object)cha.getScope());
                M.put(m, TRs);
            }
            return TRs;
        }
        return null;
    }

    @Override
    public Set<SummaryCache.TaintRelation> getSummary(IMethod m) throws ClassHierarchyException, InvalidClassFileException, IOException {
        return this.summarizeMethodIfNeeded(m);
    }

    protected static List<IClass> resolveClasses(List<TypeReference> rawPA, IClassHierarchy cha) {
        ArrayList<IClass> result = new ArrayList<IClass>(rawPA.size());
        for (TypeReference tr : rawPA) {
            result.add(cha.lookupClass(tr));
        }
        return result;
    }

    @Override
    public IMethod lookupMethod(AnalysisScope scope, String qualifiedMethodName) throws ClassHierarchyException {
        IClassHierarchy cha = this.findOrCreateCHA(scope);
        IClass declaringClass = SignatureUtil.getDeclaringClass((String)qualifiedMethodName, (IClassHierarchy)cha);
        return SignatureUtil.sig2Method((String)qualifiedMethodName, (IClassHierarchy)cha, (Language)declaringClass.getClassLoader().getLanguage());
    }

    @Override
    public Map<IMethod, Set<SummaryCache.TaintRelation>> summarizeJavaScope(String analysisScopePath) throws IOException, ClassHierarchyException, InvalidClassFileException {
        return this.summarizeJavaScope(analysisScopePath, this.DEFAULT_METHOD_FILTER);
    }

    @Override
    public Map<IMethod, Set<SummaryCache.TaintRelation>> summarizeDotNetScope(String analysisScopePath) throws IOException, ClassHierarchyException, InvalidClassFileException {
        return this.summarizeDotNetScope(analysisScopePath, this.DEFAULT_METHOD_FILTER);
    }

    @Override
    public Map<IMethod, Set<SummaryCache.TaintRelation>> summarizeDotNetScope(String analysisScopePath, Filter<IMethod> candidateSelector) throws IOException, ClassHierarchyException, InvalidClassFileException {
        CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> dotNetScope = ScopeUtil.getDotNetAnalysisScope(analysisScopePath);
        return this.summarize((AnalysisScope)dotNetScope, this.DEFAULT_METHOD_FILTER);
    }

    @Override
    public Map<IMethod, Set<SummaryCache.TaintRelation>> summarizeJavaScope(String analysisScopePath, Filter<IMethod> candidateSelector) throws IOException, ClassHierarchyException, InvalidClassFileException {
        AnalysisScope javaScope = ScopeUtil.getJavaScope(analysisScopePath);
        return this.summarize(javaScope, this.DEFAULT_METHOD_FILTER);
    }

    @Override
    public Map<IMethod, Set<SummaryCache.TaintRelation>> summarize(AnalysisScope scope) throws ClassHierarchyException, IOException, InvalidClassFileException {
        return this.summarize(scope, this.DEFAULT_METHOD_FILTER);
    }

    @Override
    public Map<IMethod, Set<SummaryCache.TaintRelation>> summarize(AnalysisScope scope, Filter<IMethod> candidateSelector) throws ClassHierarchyException, IOException, InvalidClassFileException {
        if (this.isDoEagerSummarization()) {
            ILangServices langServices;
            IClassHierarchy cha = this.findOrCreateCHA(scope);
            Language l = cha.getRootClass().getClassLoader().getLanguage();
            if (l.equals(Language.JAVA)) {
                langServices = ILangServices.JAVA;
            } else if (l.equals(CLRLanguage.lang)) {
                langServices = ILangServices.DOTNET;
            } else {
                Assertions.UNREACHABLE();
                langServices = null;
            }
            FlowAnalyzer analyzer = new FlowAnalyzer(cha, langServices, this.fastLangServices);
            ConcreteResolutionEnumerator resolutionEnum = new ConcreteResolutionEnumerator(cha);
            for (IClass c : cha) {
                for (IMethod m : c.getDeclaredMethods()) {
                    if (!candidateSelector.accepts((Object)m)) continue;
                    this.summarizeMethod(analyzer, resolutionEnum, m);
                }
            }
            return this.scopewiseSummaries.get(scope);
        }
        this.scope2candidatesFilter.put(scope, candidateSelector);
        return null;
    }

    @Override
    public void setDoEagerSummarization(boolean doPersistSummaries) {
        this.doEagerSummarization = doPersistSummaries;
    }

    @Override
    public boolean isDoEagerSummarization() {
        return this.doEagerSummarization;
    }

    public static ISummaryProvider make(Language l, AnalysisScope scope) throws ClassHierarchyException {
        return new SummaryProvider(l, scope);
    }

    public static enum Languages {
        JAVA,
        DOTNET;

    }
}

