/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules.management;

import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.andromeda.diagnostics.DebugUtil;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.RawTaintRule;
import com.ibm.wala.andromeda.rules.management.CodePatternGroup;
import com.ibm.wala.andromeda.rules.management.Field;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.rules.management.IllegalPattern;
import com.ibm.wala.andromeda.rules.management.Issue;
import com.ibm.wala.andromeda.rules.management.Method;
import com.ibm.wala.andromeda.rules.management.RuleContext;
import com.ibm.wala.andromeda.rules.management.RuleLoader;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RuleManager {
    private static final Logger logger = SALogger.logger;
    private static boolean DO_PROFILING = false;
    private String rulesXml;
    private Set<IRawTaintRule> rules;
    private Map<String, IRawTaintRule> rulesByID = HashMapFactory.make();
    private Map<String, IllegalPattern> illegalPatternsByID = HashMapFactory.make();
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final String RULES_SCOPE = "rules/*";
    private final Collection<CodePatternGroup> rootSourceGroups = HashSetFactory.make();
    protected final Map<String, Issue> issues = new HashMap<String, Issue>();
    private final Collection<CodePatternGroup> rootSinkGroups = HashSetFactory.make();
    private final Collection<CodePatternGroup> rootSanitizerGroups = HashSetFactory.make();
    private final Map<String, Element> elementsByID = HashMapFactory.make();
    private final UserMethodsHook userMethodsHook;
    private static RuleManager lastRuleManager = null;

    public static RuleManager getRuleManager(String rulesPath) {
        try {
            return RuleManager.getRuleManager(rulesPath, null);
        }
        catch (IOException e) {
            System.err.println("Failed trying to load: " + rulesPath);
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public static RuleManager getRuleManager(File rulesFile) {
        return RuleManager.getRuleManager(rulesFile, null);
    }

    public static RuleManager getRuleManager(File rulesFile, UserMethodsHook userMethodsHook) {
        String rulesPath = rulesFile.getAbsolutePath();
        if (lastRuleManager == null || !RuleManager.lastRuleManager.rulesXml.equals(rulesPath)) {
            try {
                lastRuleManager = new RuleManager(rulesFile, userMethodsHook);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Failed to initialize with rules from file " + rulesPath + ".");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize with rules from file " + rulesPath + ".");
            }
        }
        return lastRuleManager;
    }

    public static RuleManager getRuleManager(String rulesPath, UserMethodsHook userMethodsHook) throws IOException {
        FileProvider fp = new FileProvider();
        File rulesFile = fp.getFile(rulesPath);
        return RuleManager.getRuleManager(rulesFile, userMethodsHook);
    }

    protected RuleManager(String rulesXml, UserMethodsHook userMethodsHook) throws XPathExpressionException, IOException {
        this(new FileProvider().getFile(rulesXml), userMethodsHook);
    }

    protected RuleManager(File rulesFile, UserMethodsHook userMethodsHook) throws XPathExpressionException, IOException {
        this.rulesXml = rulesFile.getAbsolutePath();
        this.userMethodsHook = userMethodsHook;
        this.rules = HashSetFactory.make();
        long start = System.currentTimeMillis();
        this.loadRules(rulesFile);
        long end = System.currentTimeMillis();
        if (DO_PROFILING) {
            logger.info((Object)("Rules loading time (in MS): " + (end - start)));
            logger.info((Object)("The number of rules is: " + this.rules.size()));
        }
    }

    private NodeList getNodesByProperty(String scope, String propName, String propValue, Object context) {
        String expression = scope + "[@" + propName + "='" + propValue + "']";
        NodeList matchingNodes = null;
        try {
            matchingNodes = context != null && context instanceof InputSource ? (NodeList)xpath.evaluate(expression, (InputSource)context, XPathConstants.NODESET) : (NodeList)xpath.evaluate(expression, context, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return matchingNodes;
    }

    private Element getElementByID(String id) {
        return this.elementsByID.get(id);
    }

    private void loadRules(Document xml, Element element, RuleLoader loader, Set<String> alreadyVisited) {
        if (!alreadyVisited.contains(element.getAttribute("id"))) {
            alreadyVisited.add(element.getAttribute("id"));
            String elementType = element.getTagName();
            if (elementType.equals("group")) {
                assert (loader.getSupportedRuleTypes().contains(element.getAttribute("type")));
                Collection<Element> refs = this.getReferences(xml, element);
                for (Element ref : refs) {
                    this.loadRules(xml, ref, loader, alreadyVisited);
                }
            } else if (elementType.equals("atom")) {
                assert (loader.getSupportedRuleTypes().contains(element.getAttribute("type")));
                loader.loadRule(xml, element);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private Collection<Element> getReferences(Document xml, Element element) {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        if (xml != null && element != null) {
            NodeList children = element.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                if (!(children.item(index) instanceof Element)) continue;
                String childId = ((Element)children.item(index)).getAttribute("id");
                result.add(this.getElementByID(childId));
            }
        }
        return result;
    }

    private Collection<String> loadBlackBoxIssueMappings(Document xml, String bbMapID) {
        Element bbMap = this.getElementByID(bbMapID);
        Collection<Element> references = this.getReferences(xml, bbMap);
        HashSet<String> result = new HashSet<String>();
        if (references != null) {
            for (Element ref : references) {
                if (ref.getTagName().equals("atom")) {
                    assert (ref.getAttribute("type").equals("bbmethod"));
                    assert (ref.hasAttribute("bb_attack_title"));
                    result.add(ref.getAttribute("bb_attack_title"));
                    continue;
                }
                if (ref.getTagName().equals("group")) {
                    assert (ref.getAttribute("type").equals("bbwbmap"));
                    assert (ref.hasAttribute("id"));
                    result.addAll(this.loadBlackBoxIssueMappings(xml, ref.getAttribute("id")));
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    private Issue loadIssue(Document xml, String issueID) {
        Element refIssue = this.getElementByID(issueID);
        String issueName = refIssue.getAttribute("name");
        String nameTextID = refIssue.getAttribute("name_text_id");
        String descTextID = refIssue.getAttribute("desc_text_id");
        String issueTypeID = refIssue.getAttribute("advisory");
        String remediationID = refIssue.getAttribute("remediation_name");
        int severity = Integer.parseInt(refIssue.getAttribute("severity"));
        Collection<String> bbMappings = refIssue.hasAttribute("bbwb_map_id") ? this.loadBlackBoxIssueMappings(xml, refIssue.getAttribute("bbwb_map_id")) : null;
        return this.createTaintIssue(issueID, issueName, nameTextID, descTextID, issueTypeID, severity, remediationID, bbMappings);
    }

    private IllegalPattern getIllegalPattern(String saIllegalPatternId) {
        IllegalPattern ret = this.illegalPatternsByID.get(saIllegalPatternId);
        if (ret == null) {
            Element illegalPatternElem = this.getElementByID(saIllegalPatternId);
            assert ("sapattern".equals(illegalPatternElem.getAttribute("type")));
            String name = illegalPatternElem.getAttribute("sa_pattern_name");
            String pattern = illegalPatternElem.getAttribute("sa_pattern_data");
            ret = new IllegalPattern(name, pattern);
            this.illegalPatternsByID.put(saIllegalPatternId, ret);
        }
        return ret;
    }

    private static boolean isMethodGroupElement(Element elem) {
        assert (elem != null);
        return elem.getTagName().equals("group") && elem.hasAttribute("type") && (elem.getAttribute("type").equals("source") || elem.getAttribute("type").equals("sink") || elem.getAttribute("type").equals("passthrough"));
    }

    private CodePatternGroup createCodePatternsGroup(Element elem, String requisiteType, Collection<IMember> codePatterns, Collection<CodePatternGroup> subGroups) {
        assert (elem.getTagName().equals("group"));
        assert (elem.hasAttribute("type"));
        assert (elem.getAttribute("type").equals(requisiteType));
        assert (elem.hasAttribute("id"));
        assert (elem.hasAttribute("name"));
        assert (elem.hasAttribute("name_text_id"));
        assert (elem.hasAttribute("desc_text_id"));
        CodePatternGroup ret = new CodePatternGroup(elem.getAttribute("id"), elem.getAttribute("name"), elem.getAttribute("name_text_id"), elem.getAttribute("desc_text_id"), codePatterns, subGroups);
        if (this.userMethodsHook != null) {
            this.userMethodsHook.apply(ret);
        }
        return ret;
    }

    private void loadContext(Document xml, Element ctxElement, RuleContext ctx) {
        assert (ctxElement.getAttribute("type").equals("context"));
        String elementType = ctxElement.getTagName();
        if (elementType.equals("group")) {
            Collection<Element> refs = this.getReferences(xml, ctxElement);
            for (Element ref : refs) {
                this.loadContext(xml, ref, ctx);
            }
        } else if (elementType.equals("atom")) {
            ctx.addAttribute(ctxElement.getAttribute("value"), true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private CodePatternGroup loadMethodGroup(Document xml, Element element, String requisiteType) {
        HashSet subGroups = HashSetFactory.make();
        HashSet codePatterns = HashSetFactory.make();
        String elementType = element.getTagName();
        if (elementType.equals("group")) {
            assert (element.getAttribute("type").equals(requisiteType));
            Collection<Element> refs = this.getReferences(xml, element);
            for (Element ref : refs) {
                if (ref == null) continue;
                if (RuleManager.isMethodGroupElement(ref)) {
                    subGroups.add(this.loadMethodGroup(xml, ref, requisiteType));
                    continue;
                }
                try {
                    codePatterns.add(this.loadCodePattern(xml, ref, requisiteType));
                }
                catch (UnsupportedOperationException e) {
                    logger.warn((Object)e.getMessage());
                }
            }
            CodePatternGroup result = this.createCodePatternsGroup(element, requisiteType, codePatterns, subGroups);
            return result;
        }
        throw new IllegalArgumentException();
    }

    private IMember loadCodePattern(Document xml, Element element, String requisiteType) {
        String elementType = element.getTagName();
        if (elementType.equals("atom")) {
            Pair<Set<String>, Set<Integer>> params;
            IMember codePattern = null;
            Pair<Set<String>, Set<Integer>> pair = params = element.hasAttribute("params") ? this.loadParams(this.getElementByID(element.getAttribute("params")), xml) : null;
            if (element.getAttribute("type").equals("method")) {
                codePattern = new Method(element.getAttribute("id"), element.getAttribute("value"), params);
            } else if (element.getAttribute("type").equals("jsmethod")) {
                codePattern = new Method(element.getAttribute("id"), element.getAttribute("value"), params);
            } else if (element.getAttribute("type").equals("fieldAccess")) {
                codePattern = new Field(element.getAttribute("value"), params == null ? null : (Set)params.fst);
            } else {
                throw new IllegalArgumentException("Expecting attribute of either type method, jsmethod or fieldAccess " + element);
            }
            return codePattern;
        }
        throw new IllegalArgumentException("Expecting atom " + element);
    }

    private static Element getRootElement(Document doc) {
        NodeList children = doc.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (!(children.item(index) instanceof Element)) continue;
            Element result = (Element)children.item(index);
            assert (result.getTagName().equals("rules"));
            return result;
        }
        return null;
    }

    private Pair<Set<String>, Set<Integer>> loadParams(Element paramsElement, Document xml) {
        HashSet params = HashSetFactory.make();
        HashSet untaintedFields = HashSetFactory.make();
        for (Element child : this.getReferences(xml, paramsElement)) {
            if (child.getTagName().equals("group")) {
                Pair<Set<String>, Set<Integer>> loadParams = this.loadParams(child, xml);
                Set fst = (Set)loadParams.fst;
                untaintedFields.addAll(fst);
                Set snd = (Set)loadParams.snd;
                params.addAll(snd);
                continue;
            }
            if (child.getTagName().equals("atom")) {
                String[] split;
                String untaintedFieldsString;
                String val = child.getAttribute("value");
                if (!val.equals("")) {
                    params.add(Integer.parseInt(val));
                }
                if ((untaintedFieldsString = child.getAttribute("untainted_params")).equals("")) continue;
                for (String s : split = untaintedFieldsString.split(",")) {
                    untaintedFields.add(s.trim());
                }
                continue;
            }
            throw new IllegalArgumentException("Expected tag name to be either 'group' or 'atom'.");
        }
        Pair ret = Pair.make((Object)untaintedFields, (Object)params);
        return ret;
    }

    private void loadRules(File rulesXmlFile) throws XPathExpressionException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.warn((Object)DebugUtil.getStackTrace(e));
        }
        try {
            FileInputStream f = new FileInputStream(rulesXmlFile);
            doc = docBuilder.parse(f);
            f.close();
            doc.getDocumentElement().normalize();
        }
        catch (SAXException e) {
            logger.warn((Object)DebugUtil.getStackTrace(e));
        }
        catch (IOException e) {
            logger.warn((Object)DebugUtil.getStackTrace(e));
        }
        Element root = RuleManager.getRootElement(doc);
        NodeList childNodes = root.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node current = childNodes.item(index);
            if (!(current instanceof Element)) continue;
            Element currentElem = (Element)current;
            assert (currentElem.hasAttribute("id"));
            this.elementsByID.put(currentElem.getAttribute("id"), currentElem);
        }
        InputSource context = new InputSource(rulesXmlFile.toURI().toString());
        NodeList ruleNodes = this.getNodesByProperty(RULES_SCOPE, "type", "rule", context);
        for (int index = 0; index < ruleNodes.getLength(); ++index) {
            Node n = ruleNodes.item(index);
            assert (n instanceof Element);
            Element ruleElement = (Element)n;
            if (!ruleElement.getTagName().equals("group")) continue;
            this.loadRules(doc, ruleElement, new RuleLoader(){

                @Override
                public Collection<String> getSupportedRuleTypes() {
                    return Collections.singleton("rule");
                }

                @Override
                public void loadRule(Document xml, Element currentRule) {
                    Set<String> illegalPatterns;
                    assert (currentRule.getTagName().equals("atom"));
                    assert (currentRule.getAttribute("type").equals("rule"));
                    assert (currentRule.hasAttribute("issue_id"));
                    assert (currentRule.hasAttribute("exploitability"));
                    String issueID = currentRule.getAttribute("issue_id");
                    Issue issue = RuleManager.this.loadIssue(xml, issueID);
                    RuleManager.this.issues.put(issueID, issue);
                    int exploitability = Integer.parseInt(currentRule.getAttribute("exploitability"));
                    RuleContext ruleContext = new RuleContext();
                    if (currentRule.hasAttribute("context")) {
                        String contextId = currentRule.getAttribute("context");
                        RuleManager.this.loadContext(xml, RuleManager.this.getElementByID(contextId), ruleContext);
                    }
                    HashSet sourceMethodGroups = HashSetFactory.make();
                    HashSet sinkMethodGroups = HashSetFactory.make();
                    HashSet sanitizerMethodGroups = HashSetFactory.make();
                    NodeList nodeList = currentRule.getChildNodes();
                    for (int index = 0; index < nodeList.getLength(); ++index) {
                        Node currentNode = nodeList.item(index);
                        if (!(currentNode instanceof Element)) continue;
                        Element currentElement = (Element)currentNode;
                        if (currentElement.getTagName().equals("source")) {
                            Element actualSource = RuleManager.this.getElementByID(currentElement.getAttribute("id"));
                            if (actualSource == null) continue;
                            CodePatternGroup sourceMethodGroup = RuleManager.this.loadMethodGroup(xml, actualSource, "source");
                            sourceMethodGroups.add(sourceMethodGroup);
                            RuleManager.this.rootSourceGroups.add(sourceMethodGroup);
                            continue;
                        }
                        if (currentElement.getTagName().equals("passthrough")) {
                            Element actualSanitizer = RuleManager.this.getElementByID(currentElement.getAttribute("id"));
                            if (actualSanitizer == null) continue;
                            CodePatternGroup sanitizerMethodGroup = RuleManager.this.loadMethodGroup(xml, actualSanitizer, "passthrough");
                            sanitizerMethodGroups.add(sanitizerMethodGroup);
                            RuleManager.this.rootSanitizerGroups.add(sanitizerMethodGroup);
                            continue;
                        }
                        if (currentElement.getTagName().equals("sink")) {
                            Element actualSink = RuleManager.this.getElementByID(currentElement.getAttribute("id"));
                            if (actualSink == null) continue;
                            CodePatternGroup sinkMethodGroup = RuleManager.this.loadMethodGroup(xml, actualSink, "sink");
                            sinkMethodGroups.add(sinkMethodGroup);
                            RuleManager.this.rootSinkGroups.add(sinkMethodGroup);
                            continue;
                        }
                        throw new IllegalArgumentException();
                    }
                    String ruleID = currentRule.getAttribute("id");
                    String descriptionID = null;
                    if (currentRule.hasAttribute("desc_text_id")) {
                        descriptionID = currentRule.getAttribute("desc_text_id");
                    }
                    if (currentRule.hasAttribute("sa_illegal_pattern_id")) {
                        String saIllegalPatternId = currentRule.getAttribute("sa_illegal_pattern_id");
                        IllegalPattern illegalPattern = RuleManager.this.getIllegalPattern(saIllegalPatternId);
                        illegalPatterns = Collections.singleton(illegalPattern.getPattern());
                    } else {
                        illegalPatterns = Collections.emptySet();
                    }
                    int severity = currentRule.hasAttribute("rule_severity") ? Integer.parseInt(currentRule.getAttribute("rule_severity")) : -1;
                    String advisory = issue.getIssueTypeID();
                    IRawTaintRule r = RuleManager.this.createTaintRule(ruleID, ruleContext, issue.getName(), descriptionID, advisory, sourceMethodGroups, sinkMethodGroups, sanitizerMethodGroups, exploitability, issueID, illegalPatterns, severity);
                    RuleManager.this.rules.add(r);
                    RuleManager.this.rulesByID.put(ruleID, r);
                }
            }, HashSetFactory.make());
        }
    }

    public IRawTaintRule createTaintRule(String ruleID, RuleContext ruleContext, String issueName, String descriptionID, String advisory, Collection<CodePatternGroup> sourceMethodGroups, Collection<CodePatternGroup> sinkMethodGroups, Collection<CodePatternGroup> sanitizerMethodGroups, int exploitability, String issueID, Set<String> illegalPatterns, int severity) {
        RawTaintRule r = new RawTaintRule(ruleID, ruleContext, issueName, descriptionID, advisory, sourceMethodGroups, sinkMethodGroups, sanitizerMethodGroups, exploitability, issueID, illegalPatterns, severity);
        return r;
    }

    public Issue createTaintIssue(String issueID, String issueName, String nameTextID, String descTextID, String issueTypeID, int severity, String remediationID, Collection<String> bbMappings) {
        return new Issue(issueID, issueName, nameTextID, descTextID, issueTypeID, severity, remediationID, bbMappings);
    }

    public Collection<CodePatternGroup> getRootSourceGroups() {
        return this.rootSourceGroups;
    }

    public Collection<CodePatternGroup> getRootSinkGroups() {
        return this.rootSinkGroups;
    }

    public Collection<CodePatternGroup> getRootSanitizerGroups() {
        return this.rootSanitizerGroups;
    }

    public IRawTaintRule getRule(String id) {
        if (this.rulesByID.containsKey(id)) {
            return this.rulesByID.get(id);
        }
        return null;
    }

    public Issue getIssue(String id) {
        if (this.issues.containsKey(id)) {
            return this.issues.get(id);
        }
        return null;
    }

    public Set<IRawTaintRule> getRules() {
        return this.rules;
    }

    public static interface UserMethodsHook {
        public void apply(CodePatternGroup var1);
    }
}

