/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.jstaint.util.FixedSizeCache;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Map;
import java.util.Set;

public class DelayedFixedSizeCache<K, V>
extends FixedSizeCache<K, V> {
    private final int DELAY;
    private Map<K, Integer> delays;
    private Set<K> allowed;

    public DelayedFixedSizeCache(int size, int delay) {
        super(size);
        this.DELAY = delay;
        this.delays = HashMapFactory.make();
        this.allowed = HashSetFactory.make();
    }

    @Override
    public void put(K key, V value) {
        if (this.allowed.contains(key)) {
            super.put(key, value);
        } else {
            int d = this.delays.containsKey(key) ? this.delays.get(key) + 1 : 1;
            if (d > this.DELAY) {
                this.delays.remove(key);
                this.allowed.add(key);
            } else {
                this.delays.put(key, d);
            }
        }
    }
}

