/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class LocalNameTable {
    IR ir;
    HashMap<String, List<Integer>> localName2valueNumber;
    HashMap<Integer, List<String>> valueNumber2localName;
    HashMap<SSAInstruction, Integer> instructionNumber;

    public LocalNameTable(IR ir) {
        this.init(ir);
    }

    private void init(IR ir) {
        if (ir != null) {
            this.ir = ir;
            this.localName2valueNumber = new HashMap();
            this.valueNumber2localName = new HashMap();
            this.instructionNumber = new HashMap();
            SSAInstruction[] instructions = ir.getInstructions();
            for (int index = 0; index < instructions.length; ++index) {
                SSAInstruction instruction = instructions[index];
                if (instruction == null) continue;
                this.instructionNumber.put(instruction, new Integer(index));
                int numDefs = instruction.getNumberOfDefs();
                for (int i = 0; i < numDefs; ++i) {
                    int v = instruction.getDef(i);
                    String[] names = ir.getLocalNames(index, v);
                    if (names == null) continue;
                    for (int j = 0; j < names.length; ++j) {
                        String name = names[j];
                        this.store(v, name);
                    }
                }
                int numUses = instruction.getNumberOfUses();
                for (int i = 0; i < numUses; ++i) {
                    int v = instruction.getUse(i);
                    String[] names = ir.getLocalNames(index, v);
                    if (names == null) continue;
                    for (int j = 0; j < names.length; ++j) {
                        String name = names[j];
                        this.store(v, name);
                    }
                }
            }
        }
    }

    public IR getIR() {
        return this.ir;
    }

    private void store(int valueNumber, String localName) {
        List<String> names;
        Integer v = new Integer(valueNumber);
        List<Integer> numbers = this.localName2valueNumber.get(v);
        if (numbers == null) {
            numbers = new ArrayList<Integer>();
            this.localName2valueNumber.put(localName, numbers);
        }
        if ((names = this.valueNumber2localName.get(localName)) == null) {
            names = new ArrayList<String>();
            this.valueNumber2localName.put(v, names);
        }
        numbers.add(v);
        names.add(localName);
    }

    public String[] getLocalNames(int valueNumber) {
        List<String> l = this.valueNumber2localName.get(new Integer(valueNumber));
        if (l == null) {
            return new String[0];
        }
        String[] names = new String[l.size()];
        l.toArray(names);
        return names;
    }

    public String[] getLocalNames(SSAInstruction instruction, int valueNumber) {
        if (instruction == null) {
            return this.getLocalNames(valueNumber);
        }
        Integer index = this.instructionNumber.get(instruction);
        if (index == null) {
            return new String[0];
        }
        return this.getIR().getLocalNames(index.intValue(), valueNumber);
    }

    public String[] getLocalNames(int index, int valueNumber) {
        if (index < 0) {
            return this.getLocalNames(valueNumber);
        }
        return this.getIR().getLocalNames(index, valueNumber);
    }

    public int[] getValueNumbers(String localName) {
        List<Integer> l = this.localName2valueNumber.get(localName);
        if (l == null) {
            return new int[0];
        }
        int[] numbers = new int[l.size()];
        ListIterator<Integer> i = l.listIterator();
        while (i.hasNext()) {
            int idx = i.nextIndex();
            Integer n = i.next();
            numbers[idx] = n;
        }
        return numbers;
    }
}

