/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.common.thirdpartylib.license;

import com.hcl.appscan.common.thirdpartylib.license.ILicense;
import com.ibm.appscan.common.utils.XMLUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public final class LicensesFileWriter {
    private File m_file;
    private LinkedHashMap<String, Integer> m_dictionary;
    private List<ILicense> m_licenses;
    private int m_highRiskLicenses;
    private int m_libraryCount;

    public LicensesFileWriter(File licensesFile, List<ILicense> licenses, int libraryCount) {
        this.m_file = licensesFile;
        this.m_licenses = licenses;
        this.m_highRiskLicenses = 0;
        this.m_libraryCount = libraryCount;
    }

    protected String toDictionary(String key) {
        Integer val = this.m_dictionary.get(key);
        if (val == null) {
            val = this.m_dictionary.keySet().size() + 1;
            this.m_dictionary.put(key, val);
        }
        return val.toString();
    }

    private void buildDictionary() {
        this.m_dictionary = new LinkedHashMap();
        this.toDictionary("");
        for (ILicense license : this.m_licenses) {
            if (license.getRiskLevel().equalsIgnoreCase("high")) {
                ++this.m_highRiskLicenses;
            }
            HashMap<String, String> properties = license.getProperties();
            for (String key : properties.keySet()) {
                String val = this.toDictionary((String)properties.get(key));
                properties.replace(key, val);
            }
        }
    }

    public void write() throws IOException {
        try {
            this.buildDictionary();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMWriter writer = new DOMWriter(this.m_file, builder);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            writer.beginElement("LicenseResult");
            writer.setAttribute("libraries", Integer.toString(this.m_libraryCount));
            writer.setAttribute("total_licenses", Integer.toString(this.m_licenses.size()));
            writer.setAttribute("high_risk_licenses", Integer.toString(this.m_highRiskLicenses));
            writer.beginElement("dictionary");
            for (String key : this.m_dictionary.keySet()) {
                writer.beginElement("item");
                writer.setAttribute("id", Integer.toString(this.m_dictionary.get(key)));
                writer.setAttribute("value", XMLUtil.removeInvalidChars(key));
                writer.endElement();
            }
            writer.endElement();
            writer.beginElement("licenses");
            for (ILicense license : this.m_licenses) {
                HashMap<String, String> properties = license.getProperties();
                writer.beginElement("license");
                for (String property : properties.keySet()) {
                    writer.setAttribute(property, (String)properties.get(property));
                }
                writer.endElement();
            }
            writer.endElement();
            writer.endElement();
            writer.write(transformer);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException(e);
        }
    }
}

