/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.xml.ConfigReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;

public class Configuration {
    private HashMap<String, String> m_config;

    public synchronized HashMap<String, String> getConfiguration() {
        if (this.m_config == null) {
            this.m_config = new HashMap();
            File config = new File(CommonCore.getDirectoryLocator().getConfig());
            if (config.exists()) {
                for (File f : config.listFiles()) {
                    if (!f.getPath().endsWith("apsettings")) continue;
                    ConfigReader r = new ConfigReader(f, this.m_config);
                    try {
                        r.read();
                    }
                    catch (FileNotFoundException e) {
                        CommonCore.getLogManager().log(new Message(4, Messages.getMessage("err.load.config.file.not.found", f.getPath())));
                    }
                    catch (XMLStreamException e) {
                        CommonCore.getLogManager().log(new Message(4, Messages.getMessage("err.load.config.stream.exception", f.getPath(), e.getLocalizedMessage())));
                    }
                }
            }
        }
        return this.m_config;
    }

    public String getSettingValue(String name) {
        return this.getConfiguration().get(name);
    }

    public String getSettingValue(String name, String default_value) {
        if (this.getConfiguration().containsKey(name)) {
            return this.getConfiguration().get(name);
        }
        return default_value;
    }

    public long getSettingValueLong(String name, long default_value) {
        try {
            return Long.parseLong(this.getConfiguration().get(name));
        }
        catch (NumberFormatException nme) {
            return default_value;
        }
    }

    public double getSettingValueDouble(String name, double default_value) {
        try {
            return Double.parseDouble(this.getConfiguration().get(name));
        }
        catch (Exception nme) {
            return default_value;
        }
    }

    public int getSettingValueInt(String name, int default_value) {
        try {
            return Integer.parseInt(this.getConfiguration().get(name));
        }
        catch (Exception nme) {
            return default_value;
        }
    }

    public boolean getSettingValueBooleanDefaultFalse(String name) {
        return "true".equalsIgnoreCase(this.getConfiguration().get(name));
    }

    public boolean getSettingValueBooleanDefaultTrue(String name) {
        return !"false".equalsIgnoreCase(this.getConfiguration().get(name));
    }
}

