/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.VersionInfo;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;

public final class DirectoryLocator {
    public static final String INSTALL_PROP = "appscan.install.dir";
    public static final String INSTALL_VAR = "APPSCAN_INSTALL_DIR";
    public static final String SOURCE_DATA_PROP = "source.data.dir";
    private static final String SOURCE_DATA_VAR = "SOURCE_DATA_DIR";
    private static final String DEFAULT_ANNOTATION = "annotation/";
    private static final String DEFAULT_BIN = "bin/";
    private static final String DEFAULT_LIB = "lib/";
    private static final String DEFAULT_CFG = "config/";
    private static final String DEFAULT_LOG = "logs/";
    private static final String DEFAULT_VDB = "vdb/";
    private static final String DEFAULT_TMP = "temp/";
    private static final String DEFAULT_KBA = "kbarticles/";
    private static final String DEFAULT_JRE = "jre/";
    private static final String DEFAULT_ML = "ml/";
    private static final String DEFAULT_FIPS = "fips/";
    private String m_root;
    private String m_annotation;
    private String m_bin;
    private String m_lib;
    private String m_cfg;
    private String m_log;
    private String m_vdb;
    private String m_tmp;
    private String m_kba;
    private String m_ml;
    private String m_jre;
    private String m_fips;
    private String m_dotAppscan;

    DirectoryLocator() {
        String productRoot = System.getProperty(INSTALL_PROP);
        if (productRoot == null || productRoot.trim().equals("")) {
            productRoot = System.getenv(INSTALL_VAR);
        }
        if (productRoot == null || productRoot.trim().equals("")) {
            this.setProductRoot("./");
        } else {
            this.setProductRoot(productRoot);
        }
    }

    private String ensureTrailingSeparator(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + '/';
        }
        return path;
    }

    public void setProductRoot(String path) {
        if (path != null) {
            path.replaceAll("\\\\", "/");
            String DOT_APPSCAN = System.getProperty("user.home") + "/.appscan/";
            this.m_root = this.ensureTrailingSeparator(path.trim());
            this.m_annotation = this.m_root + DEFAULT_ANNOTATION;
            this.m_bin = this.m_root + DEFAULT_BIN;
            this.m_lib = this.m_root + DEFAULT_LIB;
            this.m_cfg = this.m_root + DEFAULT_CFG;
            this.m_vdb = this.m_root + DEFAULT_VDB;
            this.m_kba = this.m_root + DEFAULT_KBA;
            this.m_jre = this.m_root + DEFAULT_JRE;
            this.m_ml = this.m_root + DEFAULT_ML;
            this.m_fips = this.m_root + DEFAULT_FIPS;
            this.m_dotAppscan = DOT_APPSCAN;
            if (SystemUtil.isMac()) {
                this.m_log = DOT_APPSCAN + DEFAULT_LOG;
                this.m_tmp = DOT_APPSCAN + DEFAULT_TMP;
            } else {
                this.m_log = this.m_root + DEFAULT_LOG;
                this.m_tmp = this.m_root + DEFAULT_TMP;
            }
            CommonCore.setVersionInfo(new VersionInfo(path));
            String dataDir = System.getProperty(SOURCE_DATA_PROP);
            if (dataDir == null || dataDir.trim().equals("")) {
                dataDir = System.getenv(SOURCE_DATA_VAR);
            }
            if (dataDir != null && !dataDir.trim().equals("")) {
                String source_dir = this.ensureTrailingSeparator(dataDir.trim());
                this.m_log = source_dir + DEFAULT_LOG;
                this.m_tmp = source_dir + DEFAULT_TMP;
                this.m_ml = source_dir + DEFAULT_ML;
            }
        }
    }

    public String getProductRoot() {
        return this.m_root;
    }

    public Boolean isProductBundle() {
        File rootFile;
        if (SystemUtil.isMac() && (rootFile = new File(this.m_root)).getAbsolutePath().endsWith("/Contents/Home")) {
            return true;
        }
        return false;
    }

    public String getProductTemp() {
        return new File(this.m_tmp).getAbsolutePath();
    }

    public void setBin(String path) {
        if (path != null) {
            this.m_bin = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getBin() {
        return this.m_bin;
    }

    public void setLib(String path) {
        if (path != null) {
            this.m_lib = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getLib() {
        return this.m_lib;
    }

    public void setConfig(String path) {
        if (path != null) {
            this.m_cfg = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getConfig() {
        return this.m_cfg;
    }

    public void setLogs(String path) {
        if (path != null) {
            this.m_log = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getLogs() {
        return this.m_log;
    }

    public void setVdb(String path) {
        if (path != null) {
            this.m_vdb = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getVdb() {
        return this.m_vdb;
    }

    public File getVdbLanguageDirectory(Language.LANGUAGE lang) {
        return new File(this.getVdb() + "factory" + File.separator + lang.toVdbString());
    }

    public void setTemp(String path) {
        if (path != null) {
            this.m_tmp = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getTemp() {
        return this.m_tmp;
    }

    public void setKBArticles(String path) {
        if (path != null) {
            this.m_kba = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getKBArticles() {
        return this.m_kba;
    }

    public void setMl(String path) {
        if (path != null) {
            this.m_ml = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getMl() {
        return this.m_ml;
    }

    public String getAnnotation() {
        return this.m_annotation;
    }

    public void setJRE(String path) {
        if (path != null) {
            this.m_jre = this.ensureTrailingSeparator(path.trim());
        }
    }

    public String getJRE() {
        return this.m_jre;
    }

    public String getFIPS() {
        return this.m_fips;
    }

    public String getDotAppscan() {
        return this.m_dotAppscan;
    }
}

