/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.logging;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.StringUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class LogManager
implements ILogManager {
    private List<Message> m_messages = new ArrayList<Message>();
    private PrintWriter m_out = null;
    private List<Message> m_backlog = new ArrayList<Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void init() {
        if (this.m_out != null) {
            return;
        }
        File log = this.getLogFile();
        if (log == null) {
            return;
        }
        log.getParentFile().mkdirs();
        try {
            this.m_out = new PrintWriter(new BufferedWriter(new FileWriter(log, true)));
            this.m_out.println("--------------------------------------------------");
            if (this.m_backlog != null) {
                for (Message message : this.m_backlog) {
                    message.printTo(this.m_out);
                }
            }
        }
        catch (IOException e) {
            this.fallbackLog(new Message(e));
        }
        finally {
            this.m_backlog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressSecurityTrace
    public final void log(Message message) {
        String text = message.getText();
        if (text.startsWith("<ozscan>") || text.startsWith("<ozipva>")) {
            return;
        }
        int severity = message.getSeverity();
        Message logmsg = new Message(severity, StringUtil.untagMessage(text));
        text = logmsg.getText();
        if (text != null && !text.trim().isEmpty()) {
            LogManager logManager = this;
            synchronized (logManager) {
                this.m_messages.add(logmsg);
                if (this.m_out != null) {
                    logmsg.printTo(this.m_out);
                } else if (this.m_backlog != null) {
                    this.m_backlog.add(logmsg);
                } else {
                    this.fallbackLog(logmsg);
                }
            }
        }
    }

    @Override
    public void log(Exception e) {
        this.log(new Message(e));
    }

    @Override
    public final List<Message> getMessages() {
        return this.m_messages;
    }

    public final synchronized void flush() {
        if (this.m_out != null) {
            this.m_out.flush();
        }
    }

    @Override
    public final synchronized void close() {
        IOUtil.close(this.m_out);
        this.m_out = null;
        this.m_backlog = new ArrayList<Message>();
    }

    public abstract File getLogFile();

    protected abstract void fallbackLog(Message var1);
}

