/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public abstract class Metric
implements Comparable<Metric> {
    private String m_metric_name;
    private ArrayList<String> m_values;

    public Metric(String metric_name) {
        this.m_metric_name = metric_name;
        this.m_values = new ArrayList();
    }

    public void addMetricValue(String value) {
        if (value != null && value.length() > 0) {
            this.m_values.add(value);
            this.sortValues(this.m_values);
        }
    }

    protected void sortValues(ArrayList<String> values) {
        Collections.sort(values);
    }

    public String getMetricName() {
        return this.m_metric_name;
    }

    public abstract String getMetricValue();

    protected ArrayList<String> getLoadedValues() {
        return this.m_values;
    }

    public Map<String, String> getMetaData() {
        return Collections.emptyMap();
    }

    @Override
    public int compareTo(Metric o) {
        return this.getMetricName().compareTo(o.getMetricName());
    }
}

