/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import com.ibm.appscan.common.model.EngineMessage;
import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.common.xml.XMLStreamReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class EngineMessageReader
extends XMLFileReader {
    public static final String E_MESSAGES = "Messages";
    public static final String E_MESSAGE = "Message";
    public static final String A_DATE_TIME = "date_time";
    public static final String A_SEVERITY = "message_severity";
    public static final String A_TYPE = "message_type";
    public static final String A_SRCFILE = "source_file";
    public static final String A_LINENUMBER = "line_number";
    public static final String A_THROW_SRCFILE = "throw_source_file";
    public static final String A_THROW_LINENUMBER = "throw_line_number";
    public static final String A_MISSING_CLASSNAME = "missing_classname";
    public static final String A_CURRENT_CLASSNAME = "current_classname";
    public static final String A_FILENAME = "filename";
    public static final String A_FILE_SKIPPED = "file_skipped";
    private List<EngineMessage> m_messages = new ArrayList<EngineMessage>();

    public EngineMessageReader(File file) {
        super(file);
    }

    private boolean processMessages(StartElement element) {
        return true;
    }

    private void processMessage(StartElement element, XMLStreamReader.ElementValue value) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator<Attribute> iter = element.getAttributes();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            attributes.put(attr.getName().getLocalPart(), attr.getValue());
        }
        String text = null;
        try {
            text = value.getText();
        }
        catch (XMLStreamException e) {
            System.out.println(e);
        }
        this.m_messages.add(new EngineMessage(attributes, text));
    }

    @Override
    protected boolean process(StartElement element, XMLStreamReader.ElementValue value) {
        String name = element.getName().getLocalPart();
        if (E_MESSAGES.equals(name)) {
            return this.processMessages(element);
        }
        if (E_MESSAGE.equals(name)) {
            this.processMessage(element, value);
        }
        return true;
    }

    public List<EngineMessage> getMessages() {
        return this.m_messages;
    }
}

