/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetBase;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.IStagingProvider;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.util.Set;

public abstract class ScanTargetStrategy
implements IScanTargetBase {
    private IStagingProvider m_provider;
    private ScanTargetStrategy m_parent = null;

    public void setStagingProvider(IStagingProvider provider) {
        this.m_provider = provider;
    }

    @Override
    public final File getStagingDirectory(boolean create) {
        return this.m_provider.getStagingDirectory(create);
    }

    @Override
    public final File getStagingDirectory(boolean create, String dir) {
        return this.m_provider.getStagingDirectory(create, dir);
    }

    @Override
    public String getLanguageType() {
        return null;
    }

    public void setParent(ScanTargetStrategy parent) {
        this.m_parent = parent;
    }

    public ScanTargetStrategy getParent() {
        return this.m_parent;
    }

    public boolean handlesIncludesExcludes() {
        return false;
    }

    public StringPattern getAdjustedPattern(StringPattern pattern) {
        return pattern;
    }

    public abstract void findScanTargets(IScanTargetProxy var1, IProgress var2);

    protected boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        return true;
    }

    protected boolean buildScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        return true;
    }

    protected void validateScanTarget(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
    }

    protected void getNameSpaces(IScanTargetMinProxy proxy, Set<IScanFile> files) {
    }

    protected abstract Set<IScanFile> findScanFiles(IScanTargetMinProxy var1, IProgress var2);

    public final Set<IScanFile> getScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        if (this.stageScanTarget(proxy, progress) && this.buildScanTarget(proxy, progress)) {
            Set<IScanFile> files = this.findScanFiles(proxy, progress);
            if (SystemUtil.isDryRun() && !proxy.isExcludedTarget()) {
                this.validateScanTarget(proxy, progress, files);
            }
            this.getNameSpaces(proxy, files);
            return files;
        }
        return null;
    }

    public boolean collectsScanFiles() {
        return false;
    }

    @Override
    public String getStrategyClass() {
        return this.getClass().getName();
    }

    protected boolean shouldAddFile(String path, Set<StringPattern> includes, Set<StringPattern> excludes) {
        boolean addFile = true;
        addFile = includes.isEmpty() && excludes.isEmpty() ? true : (includes.isEmpty() ? !this.matchFound(path, excludes) : this.matchFound(path, includes) && !this.matchFound(path, excludes));
        return addFile;
    }

    private boolean matchFound(String path, Set<StringPattern> set) {
        for (StringPattern pattern : set) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }
}

