/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model.validation;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.validation.IScanTargetValidator;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class ThreadedTargetValidator
implements IScanTargetValidator {
    private static final int NUM_WORKER_THREADS = 10;
    private static final int TIMEOUT_SECONDS = 180;
    private static final int RECOVERY_SECONDS = 60;
    private Collection<File> m_files;
    private IScanTargetMinProxy m_proxy;
    private Map<File, Collection<IValidationIssue>> m_issuesMap;

    public ThreadedTargetValidator(Set<IScanFile> scan_files, IScanTargetMinProxy proxy) {
        this(ThreadedTargetValidator.getFilesFromScanFiles(scan_files), proxy);
    }

    public ThreadedTargetValidator(Collection<File> files, IScanTargetMinProxy proxy) {
        this.m_files = files;
        this.m_proxy = proxy;
        this.m_issuesMap = new HashMap<File, Collection<IValidationIssue>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IValidationIssue> validate(IProgress progress) {
        this.setup();
        HashSet<IValidationIssue> issues = new HashSet<IValidationIssue>();
        try {
            ExecutorService pool = Executors.newFixedThreadPool(10);
            for (File scanFile : this.m_files) {
                Runnable worker = this.getWorkerThread(scanFile);
                pool.execute(worker);
            }
            pool.shutdown();
            try {
                if (!pool.awaitTermination(180L, TimeUnit.SECONDS)) {
                    this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("validation.timeout", 180)));
                    pool.shutdownNow();
                    if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        this.m_proxy.getLogManager().log(new Message(4, Messages.getMessage("error.threads.terminate", new Object[0])));
                    }
                }
            }
            catch (InterruptedException e) {
                this.m_proxy.getLogManager().log(new Message(Messages.getMessage("error.threads.terminate", new Object[0]), e));
                pool.shutdownNow();
            }
            for (File scanFile : this.m_issuesMap.keySet()) {
                for (IValidationIssue issue : this.m_issuesMap.get(scanFile)) {
                    this.m_proxy.getLogManager().log(new Message(1, issue.getIssueText()));
                    issues.add(issue);
                }
            }
        }
        finally {
            this.cleanup();
        }
        return issues;
    }

    protected abstract void setup();

    protected abstract void cleanup();

    protected abstract Runnable getWorkerThread(File var1);

    protected IScanTargetMinProxy getProxy() {
        return this.m_proxy;
    }

    protected synchronized void logMessage(Message message) {
        this.m_proxy.getLogManager().log(message);
    }

    protected synchronized void addValidationIssues(File file, Collection<IValidationIssue> issues) {
        this.m_issuesMap.put(file, issues);
    }

    private static Collection<File> getFilesFromScanFiles(Collection<IScanFile> scan_files) {
        HashSet<File> files = new HashSet<File>();
        for (IScanFile sf : scan_files) {
            files.add(sf.getFile());
        }
        return files;
    }
}

