/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ConnectionHelper;
import com.ibm.appscan.common.utils.CryptoUtils;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.WebServiceUtil;
import com.ibm.appscan.common.utils.XMLUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.net.ssl.SSLHandshakeException;
import org.w3c.dom.Document;

public class KeyUtil {
    private static final String PUBLIC_KEY = "PublicKey";
    private static final String MESSAGE = "Message";
    private static final String E_MODULUS = "Modulus";
    private static final String E_EXPONENT = "Exponent";

    public static boolean updatePublicKey() {
        boolean success = false;
        try {
            String url;
            HttpClient httpClient;
            HttpResponse response;
            if (SystemUtil.shouldAcceptSSL() || SystemUtil.isDevelopment()) {
                ConnectionHelper.bypassSSL();
            }
            if ((response = (httpClient = new HttpClient()).get(url = WebServiceUtil.getServer() + "/api/v4/Tools/PublicKey", null, null)).isSuccess()) {
                String body = response.getResponseBodyAsString();
                Document doc = XMLUtil.parse(body);
                String modString = doc.getElementsByTagName(E_MODULUS).item(0).getTextContent();
                String expString = doc.getElementsByTagName(E_EXPONENT).item(0).getTextContent();
                String saveLocation = CommonCore.getDirectoryLocator().getConfig() + "rsa.pub";
                KeyUtil.saveKeyToFile(saveLocation, modString, expString);
                success = true;
                CommonCore.getLogManager().log(new Message(1, Messages.getMessage("pub.key.save.location", saveLocation)));
            } else {
                CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.server.publickey.update", new Object[0])));
            }
        }
        catch (SSLHandshakeException e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("err.ssl", WebServiceUtil.getServer())));
            CommonCore.getIOConsole().println(Messages.getMessage("err.ssl", WebServiceUtil.getServer()));
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.server.publickey.update", new Object[0])));
        }
        return success;
    }

    public static Key getPublicKey() throws IOException, GeneralSecurityException {
        if (!KeyUtil.updatePublicKey() && !new File(CommonCore.getDirectoryLocator().getConfig() + "rsa.pub").exists()) {
            CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.publickey.unavailable", new Object[0])));
            return null;
        }
        return CryptoUtils.readPublicKey(CommonCore.getDirectoryLocator().getConfig() + "rsa.pub");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressSecurityTrace
    public static void saveKeyToFile(String path, String mod, String exp) throws IOException {
        try (BufferedWriter bf = new BufferedWriter(new FileWriter(path));){
            bf.write(mod);
            bf.newLine();
            bf.write(exp);
            bf.newLine();
        }
    }
}

