/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ServerUtil {
    private static final String SERVICE_URL = "service_url";
    private static final String DEFAULT = "default";
    private static String CURRENT_SERVER = ServerUtil.getConfiguredServer();
    private static Map<String, String> m_servers = null;

    public static boolean isHcl() {
        return true;
    }

    public static String getServerUrl() {
        String server = SystemUtil.getExternalServer();
        if (server == null || server.equalsIgnoreCase("https://cloud.appscan.com")) {
            server = CommonCore.getConfiguration().getSettingValue(SERVICE_URL);
        }
        if (server == null) {
            return CURRENT_SERVER;
        }
        return server.endsWith("/") ? server.substring(0, server.length() - 1) : server;
    }

    public static String getSettingServerUrl() {
        String server = CommonCore.getConfiguration().getSettingValue(SERVICE_URL);
        if (server == null) {
            return CURRENT_SERVER;
        }
        return server.endsWith("/") ? server.substring(0, server.length() - 1) : server;
    }

    public static String getServerUrl(String region) {
        if (region != null && region.equalsIgnoreCase("Local")) {
            return ServerUtil.getServerUrl();
        }
        if (m_servers == null) {
            ServerUtil.initServerMap();
        }
        CURRENT_SERVER = region != null && m_servers.containsKey(region) ? m_servers.get(region) : m_servers.get(DEFAULT);
        return CURRENT_SERVER.endsWith("/") ? CURRENT_SERVER.substring(0, CURRENT_SERVER.length() - 1) : CURRENT_SERVER;
    }

    private static void initServerMap() {
        m_servers = new HashMap<String, String>();
        m_servers.put(DEFAULT, ServerUtil.getConfiguredServer());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = ServerUtil.getConfiguredServer() + "/api/v4/Utils/Regions";
        HttpClient client = new HttpClient();
        HttpResponse response = null;
        try {
            response = client.get(url, headers, null);
            if (response.isSuccess() && response.hasResponseBody()) {
                JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
                JSONArray regions = obj.getJSONArray("Regions");
                for (int i = 0; i < regions.size(); ++i) {
                    JSONObject region = (JSONObject)regions.get(i);
                    m_servers.put(region.getString("Id"), region.getString("Url"));
                }
                String defaultRegion = obj.getString("DefaultRegion");
                m_servers.put(DEFAULT, m_servers.get(defaultRegion));
            }
        }
        catch (IOException | JSONException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
    }

    private static String getConfiguredServer() {
        String server = null;
        server = SystemUtil.isDevelopment() ? SystemUtil.getInternalServer() : (SystemUtil.getExternalServer() == null ? "https://cloud.appscan.com" : SystemUtil.getExternalServer());
        return server.endsWith("/") ? server.substring(0, server.length() - 1) : server;
    }
}

