/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static final String INVALID_CHAR_REGEX = "[\\x00-\\x1F]";

    public static Document parse(String xml) throws Exception {
        Object doc = null;
        DocumentBuilder safeBuilder = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String FEATURE = null;
        FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        dbf.setFeature(FEATURE, true);
        FEATURE = "http://xml.org/sax/features/external-general-entities";
        dbf.setFeature(FEATURE, false);
        FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        dbf.setFeature(FEATURE, false);
        FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        dbf.setFeature(FEATURE, false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        safeBuilder = dbf.newDocumentBuilder();
        InputSource insrc = new InputSource(new StringReader(xml));
        return safeBuilder.parse(insrc);
    }

    public static String removeInvalidChars(String input) {
        return input.replaceAll(INVALID_CHAR_REGEX, "");
    }

    public static boolean validateXmlContent(String path) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.newDocumentBuilder().parse(new InputSource(path));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            CommonCore.getLogManager().log(new Message(4, e.getMessage()));
            return false;
        }
        return true;
    }
}

