/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.xml;

import com.ibm.appscan.common.xml.DOMWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public abstract class XmlFileWriter {
    private File m_xml_file;
    private Path m_base_path;
    private File m_output_dir;

    public XmlFileWriter() {
    }

    public XmlFileWriter(File output_dir) {
        this.m_output_dir = output_dir;
        this.m_base_path = Paths.get(output_dir.getAbsolutePath(), new String[0]);
    }

    protected abstract String getFileName();

    protected String getRelativePathToBasePath(File dir) {
        return this.m_base_path.relativize(Paths.get(dir.getAbsolutePath(), new String[0])).toString();
    }

    protected File getBasePathForOutput() {
        return this.m_output_dir;
    }

    public File getOutputXml() {
        if (this.m_xml_file == null) {
            this.m_xml_file = new File(this.m_output_dir, this.getFileName());
        }
        return this.m_xml_file;
    }

    public void saveXml() throws IOException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        TransformerFactory transform_factory = TransformerFactory.newInstance();
        Transformer transformer = transform_factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("standalone", "yes");
        DOMWriter writer = new DOMWriter(this.getOutputXml().getParentFile(), this.getOutputXml().getName(), builder);
        this.writeXml(writer);
        writer.write(transformer);
    }

    protected abstract void writeXml(DOMWriter var1);
}

