/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.maven;

import com.hcl.appscan.discovery.maven.Messages;
import com.hcl.appscan.internal.discovery.maven.MavenRunner;
import com.hcl.appscan.internal.discovery.maven.MavenStrategy;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MavenStrategyFactory
implements IStrategyFactory {
    private static boolean m_reportedWarning = false;
    private static final String POM_XML = "pom.xml";

    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        File pomFile = new File(fileOrDirectory, POM_XML);
        if (!DiscoveryCore.isTopLevelTarget((File)fileOrDirectory) || SystemUtil.isCommonEngine() || SystemUtil.isCloudIRGen()) {
            return null;
        }
        if (pomFile.exists() || fileOrDirectory.isFile() && fileOrDirectory.getName().equalsIgnoreCase(POM_XML) && this.isMavenInstalled(fileOrDirectory)) {
            DiscoveryCore.getThirdPartyLibTarget().inject(pomFile.toString());
            return new MavenStrategy(fileOrDirectory, registry);
        }
        return null;
    }

    public boolean isBuildOutput() {
        return false;
    }

    public void loadUniqueTarget(IScan scan) {
    }

    private boolean isMavenInstalled(File fileOrDirectory) {
        if (fileOrDirectory.isFile()) {
            fileOrDirectory = fileOrDirectory.getParentFile();
        }
        int rc = 1;
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-v");
            rc = new MavenRunner(fileOrDirectory, false).run(args);
        }
        catch (IOException e) {
            CommonCore.getLogManager().log(new Message(1, Messages.getMessage("maven.run.error", e.getMessage())));
        }
        if (rc != 0 && !m_reportedWarning) {
            Message message = new Message(1, Messages.getMessage("no.maven.found", new Object[0]));
            CommonCore.getLogManager().log(message);
            CommonCore.getIOConsole().println(message);
            m_reportedWarning = true;
        }
        return rc == 0;
    }
}

