/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.dotnet.translator;

import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.SSA2RuleEffectFilter;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class DotnetSSA2RuleEffectFilter<T>
extends SSA2RuleEffectFilter<T> {
    public static Pattern RETURN_NONE_PATTERN;
    public static Pattern RETURN_SELF_PATTERN;
    public static Pattern RETURN_OTHER_PATTERN;
    public static Map<String, int[]> AFFECTING_PARAMS;

    private static Pattern createPattern(String[] strs) {
        if (strs.length > 0) {
            StringBuffer patStr = new StringBuffer();
            for (String s : strs) {
                patStr.append("(" + s + ")");
                patStr.append("|");
            }
            patStr.deleteCharAt(patStr.length() - 1);
            return Pattern.compile(patStr.toString());
        }
        return null;
    }

    public DotnetSSA2RuleEffectFilter(ISSA2Rule<T> ssa2rule) {
        super(ssa2rule);
    }

    protected boolean isUpdateChain(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        String signature = invoke.getDeclaredTarget().getSignature();
        return RETURN_SELF_PATTERN != null && RETURN_SELF_PATTERN.matcher(signature).matches();
    }

    protected boolean isUpdator(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        String signature = invoke.getDeclaredTarget().getSignature();
        if (RETURN_SELF_PATTERN != null && RETURN_SELF_PATTERN.matcher(signature).matches()) {
            IR ir = ctx.getIR();
            DefUse du = new DefUse(ir);
            if (invoke.getNumberOfReturnValues() > 0) {
                Iterator uses = du.getUses(invoke.getReturnValue(0));
                return !uses.hasNext();
            }
            return true;
        }
        if (RETURN_NONE_PATTERN != null && RETURN_NONE_PATTERN.matcher(signature).matches()) {
            return true;
        }
        return RETURN_OTHER_PATTERN != null && RETURN_OTHER_PATTERN.matcher(signature).matches();
    }

    protected int[] getAffectedParameters(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        String signature = invoke.getDeclaredTarget().getSignature();
        return AFFECTING_PARAMS.get(signature);
    }

    protected boolean hasAffectedParameters(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        String signature = invoke.getDeclaredTarget().getSignature();
        return AFFECTING_PARAMS.containsKey(signature);
    }

    static {
        AFFECTING_PARAMS = new HashMap<String, int[]>();
        String[] returnSelfSigs = new String[]{};
        String[] returnOtherSigs = new String[]{"java\\.util\\.Map\\.put\\(Ljava/lang/Object;Ljava/lang/Object;\\)Ljava/lang/Object;", "java\\.util\\.HashMap\\.put\\(Ljava/lang/Object;Ljava/lang/Object;\\)Ljava/lang/Object;", "java\\.util\\.TreeMap\\.put\\(Ljava/lang/Object;Ljava/lang/Object;\\)Ljava/lang/Object;"};
        String[] returnNoneSigs = new String[]{};
        RETURN_NONE_PATTERN = DotnetSSA2RuleEffectFilter.createPattern(returnNoneSigs);
        RETURN_SELF_PATTERN = DotnetSSA2RuleEffectFilter.createPattern(returnSelfSigs);
        RETURN_OTHER_PATTERN = DotnetSSA2RuleEffectFilter.createPattern(returnOtherSigs);
    }

    protected static enum MethodKind {
        RETURN_NONE,
        RETURN_SELF,
        RETURN_OTHER;

    }
}

