/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.targets;

import com.hcl.appscan.sdk.scanners.sast.targets.CppTarget;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.targets.IDotNetTargetAdapter;
import com.ibm.appscan.internal.discovery.vs.CppProjectStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CppTargetAdapter
extends CppTarget
implements IDotNetTargetAdapter {
    private File m_projectFile;
    private Properties m_props;

    public CppTargetAdapter(File projectFile, Properties props) throws AppScanException {
        this.m_projectFile = projectFile;
        this.m_props = props;
        this.initialize();
    }

    public String getCompilerOptions() {
        return this.m_props.getProperty("compiler_opts");
    }

    public String getMacros() {
        return this.m_props.getProperty("macros");
    }

    public String getIncludeDirs() {
        return this.m_props.getProperty("include_paths");
    }

    public File getTargetFile() {
        return this.m_projectFile;
    }

    public String getSourceFiles() {
        return this.m_props.getProperty("sources");
    }

    public String getVersion() {
        return this.m_props.getProperty("vs_version");
    }

    public String getPlatformArch() {
        return this.m_props.getProperty("platform_architecture");
    }

    public String getIntermediateOutputPath() {
        return this.m_props.getProperty("intermediate_output_path");
    }

    @Override
    public Collection<ISASTTarget> toTargets() {
        ArrayList<ISASTTarget> targets = new ArrayList<ISASTTarget>();
        targets.add((ISASTTarget)this);
        return targets;
    }

    @Override
    public Map<Strategy, Properties> toStrategies() {
        HashMap<Strategy, Properties> strategies = new HashMap<Strategy, Properties>();
        strategies.put(new CppProjectStrategy(this.m_projectFile, this.m_props), this.m_props);
        return strategies;
    }

    private void initialize() throws AppScanException {
        String version = this.m_props.getProperty("vs_version");
        String sources = this.m_props.getProperty("sources");
        String error = null;
        try {
            if (version != null && Double.parseDouble(version) > 14.2) {
                error = Messages.getMessage("cpp.project.not.supported", this.m_projectFile.getPath());
            } else if (sources == null || sources.trim().equals("")) {
                error = Messages.getMessage("project.missing.sources", this.m_projectFile.getPath());
            }
        }
        catch (NumberFormatException e) {
            error = version == null || version.trim().equals("") ? Messages.getMessage("toolset.unknown", this.m_projectFile.getPath()) : Messages.getMessage("toolset.not.supported", version, this.m_projectFile.getPath());
        }
        if (error != null) {
            throw new AppScanException(error);
        }
    }
}

