/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.targets;

import com.hcl.appscan.sdk.scanners.sast.targets.DotNetTarget;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.targets.IDotNetTargetAdapter;
import com.ibm.appscan.discovery.vs.utils.DepsJsonReader;
import com.ibm.appscan.discovery.vs.utils.XamarinTargetUtil;
import com.ibm.appscan.internal.discovery.vs.AssemblyStrategy;
import com.ibm.appscan.internal.discovery.vs.DotNetPublishDirectoryStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.json.JSONException;

public class PublishedCoreTargetAdapter
extends DotNetTarget
implements IDotNetTargetAdapter {
    private File m_directory;
    private Properties m_props;
    private Collection<File> m_filesToScan;

    public PublishedCoreTargetAdapter(File directory, Properties props) {
        this.m_directory = directory;
        this.m_props = props;
        this.m_filesToScan = new HashSet<File>();
        this.initializeTarget();
    }

    public String getReferences() {
        return this.m_props.getProperty("references");
    }

    public String getFrameworkVersion() {
        return this.m_props.getProperty("framework_version");
    }

    public File getTargetFile() {
        return this.m_directory;
    }

    @Override
    public Collection<ISASTTarget> toTargets() {
        ArrayList<ISASTTarget> targets = new ArrayList<ISASTTarget>();
        targets.add((ISASTTarget)this);
        targets.addAll(XamarinTargetUtil.getXamarinTargets(this.m_props));
        return targets;
    }

    @Override
    public Map<Strategy, Properties> toStrategies() {
        HashMap<Strategy, Properties> strategies = new HashMap<Strategy, Properties>();
        for (File assembly : this.m_filesToScan) {
            strategies.put(new AssemblyStrategy(assembly, this.m_props), this.m_props);
        }
        strategies.put((Strategy)new DotNetPublishDirectoryStrategy(this.m_directory), this.m_props);
        strategies.putAll(XamarinTargetUtil.getXamarinStrategies(this.m_props));
        return strategies;
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTarget() {
        void var5_9;
        File[] depsJsons;
        File[] references;
        ArrayList<String> referenceNames = new ArrayList<String>();
        if (this.m_props != null) {
            String refs = this.m_props.getProperty("references", "");
            references = Arrays.asList(refs.split(";"));
            for (String string : references) {
                referenceNames.add(new File(string).getName());
            }
        }
        if ((depsJsons = this.m_directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".deps.json");
            }
        })) == null || depsJsons.length == 0) {
            return;
        }
        references = depsJsons;
        int n = references.length;
        boolean bl = false;
        while (var5_9 < n) {
            File depsJson = references[var5_9];
            try {
                DepsJsonReader reader = new DepsJsonReader(depsJson);
                for (String assembly : reader.getProjectAssemblies()) {
                    String name = new File(assembly).getName();
                    if (referenceNames.contains(name)) continue;
                    this.getInclusionPatterns().add(name);
                    this.m_filesToScan.add(new File(assembly));
                }
            }
            catch (IOException | JSONException throwable) {
                // empty catch block
            }
            ++var5_9;
        }
        File[] files = this.m_directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".PrecompiledViews.dll") || name.endsWith(".Views.dll");
            }
        });
        IScanTarget thirdPartyLibTarget = DiscoveryCore.getThirdPartyLibTarget();
        if (thirdPartyLibTarget != null) {
            for (File file : this.m_directory.listFiles()) {
                thirdPartyLibTarget.inject(file.getAbsolutePath());
            }
        }
        if (files != null && files.length > 0) {
            for (File f : files) {
                this.getInclusionPatterns().add(f.getName());
                this.m_filesToScan.add(f);
            }
        }
    }
}

