/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.utils;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.validation.IScanTargetValidator;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.model.validation.MissingDependency;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VsDiscoveryRunner;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class DotNetReferenceChecker
implements IScanTargetValidator {
    private File m_assembly;
    private IScanTargetMinProxy m_proxy;

    public DotNetReferenceChecker(File assembly, IScanTargetMinProxy proxy) {
        this.m_assembly = assembly;
        this.m_proxy = proxy;
    }

    public Collection<IValidationIssue> validate(IProgress progress) {
        return this.getMissingReferences(progress);
    }

    private Collection<IValidationIssue> getMissingReferences(IProgress progress) {
        HashSet<IValidationIssue> missingRefs = new HashSet<IValidationIssue>();
        String references = this.m_proxy.inheritedGetBuidInfo("references");
        try {
            Map<String, Properties> ret = new VsDiscoveryRunner(new String[]{this.m_assembly.getAbsolutePath()}).run();
            for (Properties props : ret.values()) {
                for (String missingRef : props.getProperty("missing_references", "").split(";")) {
                    if (missingRef.trim().equals("")) continue;
                    boolean found = false;
                    if (references != null) {
                        for (String ref : references.split(";")) {
                            File assemblyFile = new File(ref);
                            if (!assemblyFile.isFile() || !assemblyFile.getName().equalsIgnoreCase(missingRef)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    String message = Messages.getMessage("missing.reference", this.m_assembly.getName(), missingRef);
                    this.m_proxy.getLogManager().log(new Message(1, message));
                    missingRefs.add((IValidationIssue)new MissingDependency(this.m_assembly, new File(missingRef), IValidationIssue.SEVERITY.MAJOR));
                }
            }
        }
        catch (AppScanException e) {
            this.m_proxy.getLogManager().log(new Message(2, Messages.getMessage("error.checking.refs", this.m_assembly.getName(), e.getLocalizedMessage())));
        }
        return missingRefs;
    }
}

