/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VsDiscoveryRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class VSUtil {
    public static boolean isDotNetAssembly(File file) {
        Properties props = VSUtil.getAssemblyProperties(file);
        return props != null && props.getProperty("assembly").trim().equalsIgnoreCase("true");
    }

    public static Properties getAssemblyProperties(File file) {
        Properties properties = null;
        try {
            Map<String, Properties> props = new VsDiscoveryRunner(file).run();
            if (props != null && !props.isEmpty()) {
                properties = props.values().iterator().next();
            }
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("check.assembly.error", file.getAbsolutePath())));
        }
        return properties;
    }

    public static boolean isVSInstalled() {
        File discoveryManager = VSUtil.getDiscoveryManager();
        if (discoveryManager.isFile()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(discoveryManager.getAbsolutePath());
            params.add("-s");
            ProcessRunner builder = new ProcessRunner(params.toArray(new String[params.size()]));
            try {
                int exitCode = builder.run(new ProcessRunner.StreamHandler(){

                    protected void handle(String line) {
                        System.out.println(line);
                    }
                }, new ProcessRunner.StreamHandler(){

                    protected void handle(String line) {
                        System.out.println(line);
                    }
                });
                return exitCode == 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public static File getDiscoveryManager() {
        File directory = new File(CommonCore.getDirectoryLocator().getBin(), "DotNetDiscovery");
        return new File(directory, "DiscoveryManager.exe");
    }
}

