/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VSUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VsDiscoveryRunner {
    private ProcessRunner m_builder;
    private String m_target = null;
    private Properties m_properties = null;
    private final String WARNING_PREFIX = "WARNING: ";
    private final String ERROR_PREFIX = "ERROR: ";

    public VsDiscoveryRunner(File file) {
        this(new String[]{file.getAbsolutePath()});
    }

    public VsDiscoveryRunner(String[] args) {
        if (args != null && args.length > 0) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(VSUtil.getDiscoveryManager().getAbsolutePath());
            params.addAll(Arrays.asList(args));
            if (SystemUtil.isSourceCodeOnly()) {
                params.add("-no_build");
            }
            this.m_builder = new ProcessRunner(params.toArray(new String[params.size()]));
        } else {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("invalid.args", new Object[0])));
        }
    }

    public Map<String, Properties> run() throws AppScanException {
        return this.run(null);
    }

    public Map<String, Properties> run(IScanTargetProxy theProxy) throws AppScanException {
        try {
            final IScanTargetProxy proxy = theProxy;
            final HashMap<String, Properties> targets = new HashMap<String, Properties>();
            this.m_builder.run(new ProcessRunner.StreamHandler(){

                protected void handle(String line) {
                    try {
                        VsDiscoveryRunner.this.handleLine(line, targets);
                    }
                    catch (AppScanException e) {
                        CommonCore.getLogManager().log(new Message(4, Messages.getMessage("vs.discovery.runner.error", new Object[0])));
                    }
                }
            }, new ProcessRunner.StreamHandler(){

                protected void handle(String line) {
                    Message msg = line.startsWith("WARNING: ") ? new Message(2, line.substring("WARNING: ".length())) : (line.startsWith("ERROR: ") ? new Message(4, line.substring("ERROR: ".length())) : new Message(4, line));
                    if (proxy != null) {
                        proxy.getLogManager().log(msg);
                    } else {
                        CommonCore.getLogManager().log(msg);
                    }
                }
            });
            return targets;
        }
        catch (IOException e) {
            throw new AppScanException((Throwable)e);
        }
    }

    private void handleLine(String line, HashMap<String, Properties> targets) throws AppScanException {
        try {
            String value;
            String[] prop = line.split("=", 2);
            String key = prop[0];
            String string = value = prop.length == 2 ? prop[1] : "";
            if (key.equalsIgnoreCase("target")) {
                if (this.m_target != null && this.m_properties != null) {
                    targets.put(this.m_target, this.m_properties);
                }
                this.m_target = value;
                this.m_properties = new Properties();
            } else {
                this.m_properties.setProperty(key, value);
            }
            if (this.m_target != null && this.m_properties != null) {
                targets.put(this.m_target, this.m_properties);
            }
        }
        catch (Exception e) {
            throw new AppScanException((Throwable)e);
        }
    }
}

