/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import com.ibm.appscan.internal.discovery.vs.VSSolutionStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;

public class SLNStrategy
extends Strategy {
    private File m_directory;
    private StrategyFactoryRegistry m_registry;

    public SLNStrategy() {
    }

    SLNStrategy(File file, IStrategyFactoryRegistry registry) {
        this.init(file, registry);
    }

    public void init(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        this.m_directory = fileOrDirectory;
        this.m_registry = (StrategyFactoryRegistry)registry;
    }

    public String getName() {
        return this.m_directory.getName();
    }

    public String getType() {
        return "Visual Studio Solutions";
    }

    public String getPath() {
        return this.m_directory.getAbsolutePath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        File[] solutionFiles;
        for (File sln : solutionFiles = this.m_directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".sln");
            }
        })) {
            proxy.newScanTarget((ScanTargetStrategy)new VSSolutionStrategy(sln, (IStrategyFactoryRegistry)this.m_registry));
        }
    }
}

