/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VsDiscoveryRunner;
import com.ibm.appscan.internal.discovery.vs.AssemblyStrategy;
import com.ibm.appscan.internal.discovery.vs.VSStrategy;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class VSProjectStrategy
extends VSStrategy {
    private File m_project;

    public VSProjectStrategy() {
    }

    VSProjectStrategy(File project) {
        this.init(project, null);
    }

    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_project = file;
    }

    public String getName() {
        return this.m_project.getName();
    }

    public String getType() {
        return Messages.getMessage("vsproj", new Object[0]);
    }

    public String getPath() {
        return this.m_project.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        Map<String, Properties> targets = null;
        try {
            String[] args = new String[]{this.m_project.getAbsolutePath(), "-l", VSProjectStrategy.getLogDir(proxy)};
            targets = new VsDiscoveryRunner(args).run(proxy);
        }
        catch (AppScanException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("project.read.error", this.m_project.getAbsolutePath()), (Throwable)e);
        }
        if (targets != null) {
            for (String target : targets.keySet()) {
                Properties props = targets.get(target);
                String output = (String)props.remove("output");
                if (output == null) continue;
                File assembly = new File(output);
                proxy.newScanTarget((ScanTargetStrategy)new AssemblyStrategy(assembly, props));
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

