/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VsDiscoveryRunner;
import com.ibm.appscan.internal.discovery.vs.AssemblyStrategy;
import com.ibm.appscan.internal.discovery.vs.VSStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class VSWebSiteStrategy
extends VSStrategy {
    private File m_solution;
    private String m_guid;

    VSWebSiteStrategy(File solution, String guid) {
        this.m_solution = solution;
        this.m_guid = guid;
    }

    public String getName() {
        return this.m_guid;
    }

    public String getType() {
        return Messages.getMessage("vsweb", new Object[0]);
    }

    public String getPath() {
        return this.m_guid;
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void init(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        this.m_solution = fileOrDirectory;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        Map<String, Properties> targets = null;
        try {
            String[] args = new String[]{this.m_solution.getAbsolutePath(), this.m_guid, "-l", VSWebSiteStrategy.getLogDir(proxy)};
            targets = new VsDiscoveryRunner(args).run(proxy);
        }
        catch (AppScanException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("solution.read.error", this.m_solution.getAbsolutePath()), e.getLocalizedMessage());
        }
        if (targets != null) {
            for (String target : targets.keySet()) {
                File[] assemblies;
                File dir;
                Properties props = targets.get(target);
                String output = (String)props.remove("output");
                if (output == null || !(dir = new File(output)).isDirectory() || (assemblies = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".exe") || name.endsWith(".dll");
                    }
                })) == null) continue;
                for (File assembly : assemblies) {
                    proxy.newScanTarget((ScanTargetStrategy)new AssemblyStrategy(assembly, props));
                }
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

